/*
 * Decompiled with CFR 0.152.
 */
package beacon;

import common.CommonUtils;
import common.MudgeSanity;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class CommandBuilder {
    private static boolean A = false;
    protected ByteArrayOutputStream backing = new ByteArrayOutputStream(1024);
    protected DataOutputStream output = new DataOutputStream(this.backing);
    protected int command = 0;

    public void setCommand(int n) {
        this.command = n;
    }

    public void addStringArray(String[] stringArray) {
        this.addShort(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.addLengthAndString(stringArray[i]);
        }
    }

    public void addString(String string) {
        try {
            this.backing.write(CommonUtils.toBytes(string));
        }
        catch (IOException iOException) {
            MudgeSanity.logException("addString: '" + string + "'", iOException, false);
        }
    }

    public void addStringASCIIZ(String string) {
        this.addString(string);
        this.addByte(0);
    }

    public void addString(byte[] byArray) {
        this.backing.write(byArray, 0, byArray.length);
    }

    public void addLengthAndString(String string) {
        this.addLengthAndString(CommonUtils.toBytes(string));
    }

    public void addLengthAndStringASCIIZ(String string) {
        this.addLengthAndString(string + '\u0000');
    }

    public void addLengthAndString(byte[] byArray) {
        try {
            if (byArray.length == 0) {
                this.addInteger(0);
            } else {
                this.addInteger(byArray.length);
                this.backing.write(byArray);
            }
        }
        catch (IOException iOException) {
            MudgeSanity.logException("addLengthAndString: '" + byArray + "'", iOException, false);
        }
    }

    public void addShort(int n) {
        byte[] byArray = new byte[8];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.putShort((short)n);
        this.backing.write(byArray, 0, 2);
    }

    public void addByte(int n) {
        this.backing.write(n & 0xFF);
    }

    public void addInteger(int n) {
        byte[] byArray = new byte[8];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.putInt(n);
        this.backing.write(byArray, 0, 4);
    }

    public void addLong(long l) {
        byte[] byArray = new byte[8];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.putLong(l);
        this.backing.write(byArray, 0, 8);
    }

    public void pad(int n, int n2) {
        while (n % 1024 != 0) {
            this.addByte(0);
            ++n;
        }
    }

    public byte[] build() {
        try {
            this.output.flush();
            byte[] byArray = this.backing.toByteArray();
            this.backing.reset();
            this.A();
            this.output.writeInt(byArray.length);
            if (byArray.length > 0) {
                this.output.write(byArray, 0, byArray.length);
            }
            this.output.flush();
            byte[] byArray2 = this.backing.toByteArray();
            this.backing.reset();
            return byArray2;
        }
        catch (IOException iOException) {
            MudgeSanity.logException("command builder", iOException, false);
            return new byte[0];
        }
    }

    private final void A() throws IOException {
        if (A) {
            this.output.writeInt(this.B(this.command));
        } else {
            this.output.writeInt(this.A(this.command));
        }
    }

    private final int A(int n) {
        return n;
    }

    private static final void B() {
    }

    private final int B(int n) {
        switch (n) {
            case 3: 
            case 4: 
            case 19: {
                return n;
            }
        }
        return 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String string = "";
        synchronized ("") {
            CommandBuilder.B();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

