/*
 * Decompiled with CFR 0.152.
 */
package beacon;

import aggressor.AggressorClient;
import aggressor.DataUtils;
import beacon.CommandBuilder;
import common.BeaconEntry;
import common.CommonUtils;
import common.MudgeSanity;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class EncodedCommandBuilder
extends CommandBuilder {
    protected AggressorClient client;

    public EncodedCommandBuilder(AggressorClient aggressorClient) {
        this.client = aggressorClient;
    }

    public byte[] process(String string, String string2) {
        String string3 = this.getCharset(string);
        try {
            Charset charset = Charset.forName(string3);
            if (charset == null) {
                return CommonUtils.toBytes(string2);
            }
            ByteBuffer byteBuffer = charset.encode(string2);
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray, 0, byArray.length);
            return byArray;
        }
        catch (Exception exception) {
            MudgeSanity.logException("could not convert text for id " + string + " with " + string3, exception, false);
            return CommonUtils.toBytes(string2);
        }
    }

    public String getCharset(String string) {
        BeaconEntry beaconEntry = DataUtils.getBeacon(this.client.getData(), string);
        if (beaconEntry != null) {
            return beaconEntry.getCharset();
        }
        return null;
    }

    public void addEncodedString(String string, String string2) {
        this.addString(this.process(string, string2));
    }

    public void addLengthAndEncodedString(String string, String string2) {
        this.addLengthAndString(this.process(string, string2));
    }
}

