/*
 * Decompiled with CFR 0.152.
 */
package beacon;

import common.BeaconEntry;
import common.CommonUtils;
import common.StringStack;

public class Registry {
    public static final short HKLM = 0;
    public static final short HKCR = 1;
    public static final short HKCC = 2;
    public static final short HKCU = 3;
    public static final short HKU = 4;
    private static String[] A = new String[]{"HKLM\\", "HKCR\\", "HKCC\\", "HKCU\\", "HKU\\"};
    private static String[] B = new String[]{"HKEY_LOCAL_MACHINE\\", "HKEY_CLASSES_ROOT\\", "HKEY_CURRENT_CONFIG\\", "HKEY_CURRENT_USER\\", "HKEY_USERS\\"};
    public static final short KEY_WOW64_64KEY = 256;
    public static final short KEY_WOW64_32KEY = 512;
    protected String pathv = "";
    protected String value = "";
    protected short hive = (short)-1;
    protected String arch = "";
    protected boolean hasvalue = false;

    protected void parseHive(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.pathv.startsWith(stringArray[i])) continue;
            this.pathv = this.pathv.substring(stringArray[i].length());
            this.hive = (short)i;
            break;
        }
    }

    public String getPath() {
        return this.pathv;
    }

    public String getValue() {
        return this.value;
    }

    public short getHive() {
        return this.hive;
    }

    public Registry(String string, String string2, boolean bl) {
        this.arch = string;
        this.hasvalue = bl;
        if (bl) {
            StringStack stringStack = new StringStack(string2, " ");
            this.value = stringStack.pop();
            this.pathv = stringStack.toString();
        } else {
            this.pathv = string2;
        }
        this.parseHive(A);
        this.parseHive(B);
    }

    public short getFlags(BeaconEntry beaconEntry) {
        if (beaconEntry != null && "x86".equals(this.arch) && !beaconEntry.is64()) {
            CommonUtils.print_stat("Windows 2000 flag rule for " + beaconEntry);
            return 0;
        }
        if ("x86".equals(this.arch)) {
            return 512;
        }
        return 256;
    }

    public boolean isValid() {
        return this.getError() == null;
    }

    public String getError() {
        if (this.hasvalue && ("".equals(this.value) || "".equals(this.pathv))) {
            return "specify a value name too (e.g., HKLM\\foo\\bar Baz)";
        }
        if (this.hive == -1) {
            return "path must start with HKLM, HKCR, HKCC, HKCU, or HKU";
        }
        return null;
    }

    public String toString() {
        if (!this.isValid()) {
            return "[invalid]";
        }
        if ("".equals(this.value)) {
            return A[this.getHive()] + this.pathv + " (" + this.arch + ")";
        }
        return A[this.getHive()] + this.pathv + " /v " + this.value + " (" + this.arch + ")";
    }
}

