/*
 * Decompiled with CFR 0.152.
 */
package beacon;

import aggressor.AggressorClient;
import aggressor.DataUtils;
import common.BeaconEntry;
import common.StringStack;
import console.Console;
import console.GenericTabCompletion;
import cortana.Cortana;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SecureShellTabCompletion
extends GenericTabCompletion {
    protected AggressorClient client;
    protected String bid;

    public SecureShellTabCompletion(String string, AggressorClient aggressorClient, Console console) {
        super(console);
        this.client = aggressorClient;
        this.bid = string;
    }

    public static void filterList(List list, String string) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next() + "";
            if (string2.startsWith(string)) continue;
            iterator.remove();
        }
    }

    @Override
    public String transformText(String string) {
        return string.replace(" ~", " " + System.getProperty("user.home"));
    }

    public Collection getOptionsFromList(String string, List list) {
        LinkedList<String> linkedList = new LinkedList<String>();
        StringStack stringStack = new StringStack(string, " ");
        stringStack.pop();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            linkedList.add(stringStack.toString() + " " + iterator.next());
        }
        Collections.sort(linkedList);
        SecureShellTabCompletion.filterList(linkedList, string);
        return linkedList;
    }

    @Override
    public Collection getOptions(String string) {
        LinkedList<String> linkedList = DataUtils.getSSHCommands(this.client.getData()).commands();
        linkedList.addAll(this.client.getSSHAliases().commands());
        Collections.sort(linkedList);
        Cortana.filterList(linkedList, string);
        if (linkedList != null && linkedList.size() == 0 && string.startsWith("upload ")) {
            String string2 = string.substring(string.indexOf(" ") + 1);
            File file = new File(string2);
            if (!file.exists() || !file.isDirectory()) {
                file = file.getParentFile();
            }
            linkedList = new LinkedList<String>();
            if (file == null) {
                linkedList.add(string);
                return linkedList;
            }
            File[] fileArray = file.listFiles();
            for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                linkedList.add(string.substring(0, string.indexOf(" ")) + " " + fileArray[i].getAbsolutePath());
            }
            Collections.sort(linkedList);
            SecureShellTabCompletion.filterList(linkedList, string);
        } else {
            if (linkedList != null && linkedList.size() == 0 && (string.startsWith("help ") || string.startsWith("? "))) {
                List list = DataUtils.getSSHCommands(this.client.getData()).commands();
                return this.getOptionsFromList(string, list);
            }
            if (linkedList != null && linkedList.size() == 0 && string.startsWith("note ")) {
                BeaconEntry beaconEntry = DataUtils.getBeacon(this.client.getData(), this.bid);
                if (beaconEntry != null) {
                    LinkedList<String> linkedList2 = new LinkedList<String>();
                    linkedList2.add(beaconEntry.getNote());
                    return this.getOptionsFromList(string, linkedList2);
                }
                return this.getOptionsFromList(string, new LinkedList());
            }
            if (linkedList != null && linkedList.size() == 0 && string.matches("connect .*? .*")) {
                List list = DataUtils.getTCPPorts(this.client.getData());
                return this.getOptionsFromList(string, list);
            }
            if (linkedList != null && linkedList.size() == 0 && string.startsWith("connect ")) {
                List list = DataUtils.getTargetNames(this.client.getData());
                return this.getOptionsFromList(string, list);
            }
            if (linkedList != null && linkedList.size() == 0 && string.startsWith("unlink ")) {
                LinkedList<String> linkedList3 = new LinkedList<String>();
                for (BeaconEntry beaconEntry : DataUtils.getBeaconChildren(this.client.getData(), this.bid)) {
                    if (beaconEntry.getPivotHint().isReverse()) continue;
                    linkedList3.add(beaconEntry.getInternal() + " " + beaconEntry.getPid());
                }
                return this.getOptionsFromList(string, linkedList3);
            }
        }
        return linkedList;
    }
}

