/*
 * Decompiled with CFR 0.152.
 */
package c2profile;

import c2profile.HostProfile;
import c2profile.Profile;
import c2profile.SmartBuffer;
import c2profile.TooManyTokensException;
import cloudstrike.Response;
import common.CommonUtils;
import common.MudgeSanity;
import dialog.DialogUtils;
import encoders.Base64;
import encoders.Base64Url;
import encoders.MaskEncoder;
import encoders.NetBIOS;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class Program
implements Serializable {
    protected boolean sealed = false;
    protected boolean posts = false;
    protected boolean cookie = false;
    protected boolean host = false;
    public static final int APPEND = 1;
    public static final int PREPEND = 2;
    public static final int BASE64 = 3;
    public static final int PRINT = 4;
    public static final int PARAMETER = 5;
    public static final int HEADER = 6;
    public static final int BUILD = 7;
    public static final int NETBIOS = 8;
    public static final int _PARAMETER = 9;
    public static final int _HEADER = 10;
    public static final int NETBIOSU = 11;
    public static final int URI_APPEND = 12;
    public static final int BASE64URL = 13;
    public static final int STRREP = 14;
    public static final int MASK = 15;
    public static final int _HOSTHEADER = 16;
    public static final int STRREPEX = 17;
    protected List tsteps = new LinkedList();
    protected LinkedList rsteps = new LinkedList();

    public boolean usesHost() {
        return this.host;
    }

    public boolean usesCookie() {
        return this.cookie;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    public boolean postsData() {
        return this.posts;
    }

    public void addStep(String string, String string2, String string3, String string4) {
        Statement statement = new Statement();
        statement.arguments = new String[]{string2, string3, string4};
        this.addStep(string, statement);
    }

    public void addStep(String string, String string2, String string3) {
        Statement statement = new Statement();
        statement.arguments = new String[]{string2, string3};
        this.addStep(string, statement);
    }

    public void addStep(String string, String string2) {
        Statement statement = new Statement();
        statement.arguments = new String[]{string2};
        this.addStep(string, statement);
    }

    public void addStep(String string, Statement statement) {
        String string2 = statement.arguments[0];
        if (string.equals("append")) {
            statement.action = 1;
        } else if (string.equals("prepend")) {
            statement.action = 2;
        } else if (string.equals("base64")) {
            statement.action = 3;
        } else if (string.equals("print")) {
            statement.action = 4;
            this.sealed = true;
            this.posts = true;
        } else if (string.equals("parameter")) {
            statement.action = 5;
            this.sealed = true;
        } else if (string.equals("header")) {
            statement.action = 6;
            this.sealed = true;
        } else if (string.equals("build")) {
            statement.action = 7;
        } else if (string.equals("netbios")) {
            statement.action = 8;
        } else if (string.equals("!parameter")) {
            statement.action = 9;
        } else if (string.equals("!header")) {
            statement.action = 10;
        } else if (string.equals("!hostheader")) {
            statement.action = 16;
        } else if (string.equals("netbiosu")) {
            statement.action = 11;
        } else if (string.equals("uri-append")) {
            statement.action = 12;
            this.sealed = true;
        } else if (string.equals("base64url")) {
            statement.action = 13;
        } else if (string.equals("strrep")) {
            statement.action = 14;
        } else if (string.equals("strrepex")) {
            statement.action = 17;
        } else if (string.equals("mask")) {
            statement.action = 15;
        } else {
            throw new RuntimeException("Invalid action: " + string);
        }
        if (statement.action == 6 && string2 != null && "cookie".equals(string2.toLowerCase())) {
            this.cookie = true;
        } else if (statement.action == 10 && string2 != null && string2.toLowerCase().startsWith("cookie: ")) {
            this.cookie = true;
        } else if (statement.action == 6 && string2 != null && "host".equals(string2.toLowerCase())) {
            this.host = true;
        }
        this.tsteps.add(statement);
        this.rsteps.addFirst(statement);
    }

    public byte[] transform_binary(Profile profile) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.transform_binary(profile, dataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void transform_binary(Profile profile, DataOutputStream dataOutputStream) throws IOException {
        block17: for (Statement statement : this.tsteps) {
            switch (statement.action) {
                case 1: {
                    int n;
                    dataOutputStream.writeInt(1);
                    dataOutputStream.writeInt(statement.argumentLength(0));
                    for (n = 0; n < statement.arguments[0].length(); ++n) {
                        dataOutputStream.write((byte)statement.arguments[0].charAt(n));
                    }
                    continue block17;
                }
                case 2: {
                    int n;
                    dataOutputStream.writeInt(2);
                    dataOutputStream.writeInt(statement.argumentLength(0));
                    for (n = 0; n < statement.arguments[0].length(); ++n) {
                        dataOutputStream.write((byte)statement.arguments[0].charAt(n));
                    }
                    continue block17;
                }
                case 3: {
                    dataOutputStream.writeInt(3);
                    break;
                }
                case 13: {
                    dataOutputStream.writeInt(13);
                    break;
                }
                case 4: {
                    dataOutputStream.writeInt(4);
                    break;
                }
                case 5: {
                    int n;
                    dataOutputStream.writeInt(5);
                    dataOutputStream.writeInt(statement.argumentLength(0));
                    for (n = 0; n < statement.arguments[0].length(); ++n) {
                        dataOutputStream.write((byte)statement.arguments[0].charAt(n));
                    }
                    continue block17;
                }
                case 6: {
                    int n;
                    dataOutputStream.writeInt(6);
                    dataOutputStream.writeInt(statement.argumentLength(0));
                    for (n = 0; n < statement.arguments[0].length(); ++n) {
                        dataOutputStream.write((byte)statement.arguments[0].charAt(n));
                    }
                    continue block17;
                }
                case 7: {
                    dataOutputStream.writeInt(7);
                    if (statement.arguments[0].endsWith("metadata")) {
                        dataOutputStream.writeInt(0);
                    } else if (statement.arguments[0].endsWith("id")) {
                        dataOutputStream.writeInt(0);
                    } else if (statement.arguments[0].endsWith("output")) {
                        dataOutputStream.writeInt(1);
                    } else {
                        System.err.println("UNKNOWN DATA ARGUMENT: " + statement.arguments[0]);
                    }
                    profile.getProgram(statement.arguments[0]).transform_binary(profile, dataOutputStream);
                    break;
                }
                case 8: {
                    dataOutputStream.writeInt(8);
                    break;
                }
                case 9: {
                    int n;
                    dataOutputStream.writeInt(9);
                    dataOutputStream.writeInt(statement.argumentLength(0));
                    for (n = 0; n < statement.arguments[0].length(); ++n) {
                        dataOutputStream.write((byte)statement.arguments[0].charAt(n));
                    }
                    continue block17;
                }
                case 10: {
                    int n;
                    dataOutputStream.writeInt(10);
                    dataOutputStream.writeInt(statement.argumentLength(0));
                    for (n = 0; n < statement.arguments[0].length(); ++n) {
                        dataOutputStream.write((byte)statement.arguments[0].charAt(n));
                    }
                    continue block17;
                }
                case 16: {
                    int n;
                    dataOutputStream.writeInt(16);
                    dataOutputStream.writeInt(statement.argumentLength(0));
                    for (n = 0; n < statement.arguments[0].length(); ++n) {
                        dataOutputStream.write((byte)statement.arguments[0].charAt(n));
                    }
                    continue block17;
                }
                case 11: {
                    dataOutputStream.writeInt(11);
                    break;
                }
                case 12: {
                    dataOutputStream.writeInt(12);
                    break;
                }
                case 15: {
                    dataOutputStream.writeInt(15);
                    break;
                }
            }
        }
    }

    public void transform(Profile profile, Response response, byte[] byArray) {
        SmartBuffer smartBuffer = new SmartBuffer();
        smartBuffer.append(byArray);
        this.transform(profile, response, smartBuffer);
    }

    public void transform(Profile profile, Response response, SmartBuffer smartBuffer) {
        block16: for (Statement statement : this.tsteps) {
            switch (statement.action) {
                case 1: {
                    smartBuffer.append(Program.toBytes(statement.arguments[0]));
                    continue block16;
                }
                case 2: {
                    smartBuffer.prepend(Program.toBytes(statement.arguments[0]));
                    continue block16;
                }
                case 3: {
                    String string = Base64.encode(smartBuffer.getBytes());
                    smartBuffer.clear();
                    smartBuffer.append(Program.toBytes(string));
                    continue block16;
                }
                case 13: {
                    String string = Base64Url.encode(smartBuffer.getBytes());
                    smartBuffer.clear();
                    smartBuffer.append(Program.toBytes(string));
                    continue block16;
                }
                case 4: {
                    byte[] byArray = smartBuffer.getBytes();
                    response.data = new ByteArrayInputStream(byArray);
                    response.size = byArray.length;
                    response.offset = smartBuffer.getDataOffset();
                    response.addHeader("Content-Length", byArray.length + "");
                    continue block16;
                }
                case 5: {
                    response.addParameter(statement.arguments[0] + "=" + Program.A(smartBuffer.getBytes()));
                    continue block16;
                }
                case 6: {
                    response.addHeader(statement.arguments[0], Program.A(smartBuffer.getBytes()));
                    continue block16;
                }
                case 7: {
                    if (".http-post.client.output".equals(statement.arguments[0])) {
                        SmartBuffer smartBuffer2 = new SmartBuffer();
                        smartBuffer2.append(CommonUtils.randomData(16));
                        profile.getProgram(statement.arguments[0]).transform(profile, response, smartBuffer2);
                        continue block16;
                    }
                    profile.getProgram(statement.arguments[0]).transform(profile, response, smartBuffer);
                    continue block16;
                }
                case 8: {
                    String string = NetBIOS.encode('a', smartBuffer.getBytes());
                    smartBuffer.clear();
                    smartBuffer.append(Program.toBytes(string));
                    continue block16;
                }
                case 9: {
                    response.addParameter(statement.arguments[0]);
                    continue block16;
                }
                case 10: 
                case 16: {
                    response.addHeader(statement.arguments[0]);
                    continue block16;
                }
                case 11: {
                    String string = NetBIOS.encode('A', smartBuffer.getBytes());
                    smartBuffer.clear();
                    smartBuffer.append(Program.toBytes(string));
                    continue block16;
                }
                case 12: {
                    response.uri = Program.A(smartBuffer.getBytes());
                    continue block16;
                }
                case 15: {
                    String string = Program.A(MaskEncoder.encode(smartBuffer.getBytes()));
                    smartBuffer.clear();
                    smartBuffer.append(Program.toBytes(string));
                    continue block16;
                }
            }
            System.err.println("Unknown: " + statement);
        }
    }

    public byte[] recover_binary() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        block16: for (Statement statement : this.rsteps) {
            switch (statement.action) {
                case 1: {
                    dataOutputStream.writeInt(1);
                    dataOutputStream.writeInt(statement.argumentLength(0));
                    break;
                }
                case 2: {
                    dataOutputStream.writeInt(2);
                    dataOutputStream.writeInt(statement.argumentLength(0));
                    break;
                }
                case 3: {
                    dataOutputStream.writeInt(3);
                    break;
                }
                case 13: {
                    dataOutputStream.writeInt(13);
                    break;
                }
                case 4: {
                    dataOutputStream.writeInt(4);
                    break;
                }
                case 5: {
                    int n;
                    dataOutputStream.writeInt(5);
                    dataOutputStream.writeInt(statement.argumentLength(0));
                    for (n = 0; n < statement.arguments[0].length(); ++n) {
                        dataOutputStream.write(statement.arguments[0].charAt(n));
                    }
                    continue block16;
                }
                case 6: {
                    int n;
                    dataOutputStream.writeInt(5);
                    dataOutputStream.writeInt(statement.argumentLength(0));
                    for (n = 0; n < statement.arguments[0].length(); ++n) {
                        dataOutputStream.write(statement.arguments[0].charAt(n));
                    }
                    continue block16;
                }
                case 7: {
                    break;
                }
                case 8: {
                    dataOutputStream.writeInt(8);
                    break;
                }
                case 9: {
                    break;
                }
                case 10: 
                case 16: {
                    break;
                }
                case 11: {
                    dataOutputStream.writeInt(11);
                    break;
                }
                case 12: {
                    break;
                }
                case 15: {
                    dataOutputStream.writeInt(15);
                    break;
                }
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public List collissions(Profile profile) {
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        LinkedList linkedList = new LinkedList();
        this.collissions(profile, null, hashSet, hashMap, hashSet2, hashMap2, linkedList);
        return linkedList;
    }

    private static String[] A(String string) {
        String[] stringArray = string.split("[:=]");
        if (stringArray.length != 2) {
            return new String[]{string, ""};
        }
        stringArray[1] = stringArray[1].trim();
        return stringArray;
    }

    public void collissions(Profile profile, String string, Set set, Map map2, Set set2, Map map3, List list) {
        if (string != null) {
            if (string.startsWith(".http-get.client")) {
                this.A(profile, string, set2, map3, ".http-host-profiles.profile.http-get.parameter");
                this.B(profile, string, set2, map3, ".http-host-profiles.profile.http-get.header");
            }
            if (string.startsWith(".http-post.client")) {
                this.A(profile, string, set2, map3, ".http-host-profiles.profile.http-post.parameter");
                this.B(profile, string, set2, map3, ".http-host-profiles.profile.http-post.header");
            }
        }
        Iterator iterator = this.tsteps.iterator();
        while (iterator.hasNext()) {
            String string2 = null;
            String string3 = null;
            Statement statement = (Statement)iterator.next();
            switch (statement.action) {
                case 12: {
                    string2 = "uri-append";
                    string3 = "block '" + string + "'";
                    break;
                }
                case 4: {
                    string2 = "print";
                    string3 = "block '" + string + "'";
                    break;
                }
                case 9: {
                    String[] stringArray = Program.A(statement.arguments[0]);
                    string2 = "parameter " + stringArray[0];
                    string3 = "value '" + stringArray[1] + "'";
                    break;
                }
                case 5: {
                    string2 = "parameter " + statement.arguments[0];
                    string3 = "block '" + string + "'";
                    break;
                }
                case 10: 
                case 16: {
                    String[] stringArray = Program.A(statement.arguments[0]);
                    string2 = "header " + stringArray[0];
                    string3 = "value '" + stringArray[1] + "'";
                    break;
                }
                case 6: {
                    string2 = "header " + statement.arguments[0];
                    string3 = "block '" + string + "'";
                    break;
                }
                case 7: {
                    profile.getProgram(statement.arguments[0]).collissions(profile, statement.arguments[0], set, map2, set2, map3, list);
                }
            }
            if (string2 == null) continue;
            if (set2.contains(string2)) {
                list.add(string2 + ": " + string3 + ", " + map3.get(string2));
            }
            if (set.contains(string2)) {
                list.add(string2 + ": " + string3 + ", " + map2.get(string2));
                continue;
            }
            set.add(string2);
            map2.put(string2, string3);
        }
    }

    private void B(Profile profile, String string, Set set, Map map2, String string2) {
        ListIterator listIterator = profile.getHostProfiles().listIterator();
        while (listIterator.hasNext()) {
            HostProfile hostProfile = (HostProfile)listIterator.next();
            ListIterator listIterator2 = hostProfile.getList(string2).listIterator();
            while (listIterator2.hasNext()) {
                String string3 = listIterator2.next().toString();
                String[] stringArray = string3.split(":", -1);
                if (stringArray.length != 2) continue;
                try {
                    String[] stringArray2;
                    for (String string4 : stringArray2 = HostProfile.resolveDynamicData(stringArray[0].trim(), 32)) {
                        String string5 = "header " + string4;
                        String string6 = "Host Profile '" + hostProfile.getHostName() + "' Key '" + string2 + "' Header '" + stringArray[0] + "' Value '" + stringArray[1] + "'";
                        set.add(string5);
                        map2.put(string5, string6);
                    }
                }
                catch (TooManyTokensException tooManyTokensException) {
                    CommonUtils.print_error("Error loading headers: " + hostProfile.getHostName() + " key " + string2 + " - " + tooManyTokensException.getMessage());
                }
            }
        }
    }

    private void A(Profile profile, String string, Set set, Map map2, String string2) {
        ListIterator listIterator = profile.getHostProfiles().listIterator();
        while (listIterator.hasNext()) {
            HostProfile hostProfile = (HostProfile)listIterator.next();
            ListIterator listIterator2 = hostProfile.getList(string2).listIterator();
            while (listIterator2.hasNext()) {
                String string3 = listIterator2.next().toString();
                String[] stringArray = string3.split("=", -1);
                if (stringArray.length != 2) continue;
                try {
                    String[] stringArray2;
                    for (String string4 : stringArray2 = HostProfile.resolveDynamicData(stringArray[0].trim(), 32)) {
                        String string5 = "parameter " + string4;
                        String string6 = "Host Profile '" + hostProfile.getHostName() + "' Key '" + string2 + "' Parameter '" + stringArray[0] + "'";
                        set.add(string5);
                        map2.put(string5, string6);
                    }
                }
                catch (TooManyTokensException tooManyTokensException) {
                    CommonUtils.print_error("Error loading parameters: " + hostProfile.getHostName() + " key " + string2 + " - " + tooManyTokensException.getMessage());
                }
            }
        }
    }

    private static final String A(byte[] byArray) {
        try {
            return new String(byArray, "ISO8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public static final byte[] toBytes(String string) {
        int n = string.length();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        return byArray;
    }

    public String recover(Map map2, Map map3, String string, String string2) {
        String string3 = "";
        block24: for (Statement statement : this.rsteps) {
            switch (statement.action) {
                case 1: {
                    try {
                        string3 = string3.substring(0, string3.length() - statement.argumentLength(0));
                        continue block24;
                    }
                    catch (RuntimeException runtimeException) {
                        MudgeSanity.logException("substr('" + string3.replaceAll("\\P{Print}", ".") + "', 0, " + string3.length() + " - " + statement.argumentLength(0) + ")", runtimeException, false);
                        return "";
                    }
                }
                case 2: {
                    try {
                        string3 = string3.substring(statement.argumentLength(0), string3.length());
                        continue block24;
                    }
                    catch (RuntimeException runtimeException) {
                        MudgeSanity.logException("substr('" + string3.replaceAll("\\P{Print}", ".") + "', " + statement.argumentLength(0) + ", " + string3.length() + ")", runtimeException, false);
                        return "";
                    }
                }
                case 3: {
                    try {
                        string3 = Program.A(Base64.decode(string3));
                        continue block24;
                    }
                    catch (RuntimeException runtimeException) {
                        MudgeSanity.logException("base64 decode: " + string3, runtimeException, true);
                        return "";
                    }
                }
                case 13: {
                    try {
                        string3 = Program.A(Base64Url.decode(string3));
                        continue block24;
                    }
                    catch (RuntimeException runtimeException) {
                        MudgeSanity.logException("base64url decode: " + string3, runtimeException, true);
                        return "";
                    }
                }
                case 4: {
                    string3 = string;
                    continue block24;
                }
                case 5: {
                    string3 = DialogUtils.string(map3, statement.arguments[0]);
                    continue block24;
                }
                case 6: {
                    string3 = CommonUtils.getCaseInsensitive(map2, statement.arguments[0], "");
                    continue block24;
                }
                case 7: {
                    continue block24;
                }
                case 8: {
                    string3 = Program.A(NetBIOS.decode('a', string3));
                    continue block24;
                }
                case 9: {
                    continue block24;
                }
                case 10: 
                case 16: {
                    continue block24;
                }
                case 11: {
                    string3 = Program.A(NetBIOS.decode('A', string3));
                    continue block24;
                }
                case 12: {
                    string3 = string2;
                    continue block24;
                }
                case 15: {
                    string3 = Program.A(MaskEncoder.decode(CommonUtils.toBytes(string3)));
                    continue block24;
                }
            }
            System.err.println("Unknown: " + statement);
        }
        return string3;
    }

    public byte[] transformData(byte[] byArray, String string) {
        if (this.tsteps.size() == 0) {
            return byArray;
        }
        SmartBuffer smartBuffer = new SmartBuffer();
        smartBuffer.append(byArray);
        block6: for (Statement statement : this.tsteps) {
            switch (statement.action) {
                case 1: {
                    smartBuffer.append(Program.toBytes(statement.arguments[0]));
                    continue block6;
                }
                case 2: {
                    smartBuffer.prepend(Program.toBytes(statement.arguments[0]));
                    continue block6;
                }
                case 14: {
                    String string2 = statement.arguments[0].substring(0, statement.arguments[0].length() / 2);
                    String string3 = statement.arguments[0].substring(statement.arguments[0].length() / 2);
                    smartBuffer.strrep(string2, string3);
                    continue block6;
                }
                case 17: {
                    String string4 = statement.arguments[0];
                    if (string4 == null || !string4.equals(string)) continue block6;
                    String string5 = statement.arguments[1];
                    String string6 = statement.arguments[2];
                    smartBuffer.strrep(string5, string6);
                    continue block6;
                }
            }
            System.err.println("Unknown: " + statement);
        }
        return smartBuffer.getBytes();
    }

    public byte[] getPrependedData() {
        if (this.tsteps.size() == 0) {
            return new byte[0];
        }
        SmartBuffer smartBuffer = new SmartBuffer();
        for (Statement statement : this.tsteps) {
            switch (statement.action) {
                case 2: {
                    smartBuffer.prepend(Program.toBytes(statement.arguments[0]));
                }
            }
        }
        return smartBuffer.getBytes();
    }

    public byte[] getAppendedData() {
        if (this.tsteps.size() == 0) {
            return new byte[0];
        }
        SmartBuffer smartBuffer = new SmartBuffer();
        for (Statement statement : this.tsteps) {
            switch (statement.action) {
                case 1: {
                    smartBuffer.append(Program.toBytes(statement.arguments[0]));
                }
            }
        }
        return smartBuffer.getBytes();
    }

    public static final class Statement
    implements Serializable {
        public String[] arguments = new String[]{""};
        public int action = 0;

        public String toString() {
            return "(" + this.action + ":" + CommonUtils.join(this.arguments, ", ") + ")";
        }

        public int argumentLength(int n) {
            if (n < this.arguments.length) {
                if (this.arguments[n] == null) {
                    return 0;
                }
                return this.arguments[n].length();
            }
            throw new RuntimeException("Not enough arguments");
        }
    }
}

