/*
 * Decompiled with CFR 0.152.
 */
package cloudstrike;

import cloudstrike.NanoHTTPD;
import cloudstrike.Response;
import cloudstrike.ResponseFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;

public class NanoHTTPD {
    public static final String HTTP_OK = "200 OK";
    public static final String HTTP_PARTIAL_CONTENT = "206 Partial Content";
    public static final String HTTP_MULTISTATE = "207 Multi-Status";
    public static final String HTTP_REDIRECT = "301 Moved Permanently";
    public static final String HTTP_NOT_MODIFIED = "304 Not Modified";
    public static final String HTTP_FORBIDDEN = "403 Forbidden";
    public static final String HTTP_NOTFOUND = "404 Not Found";
    public static final String HTTP_BADREQUEST = "400 Bad Request";
    public static final String HTTP_TOOLARGE = "413 Entity Too Large";
    public static final String HTTP_RANGE_NOT_SATISFIABLE = "416 Range Not Satisfiable";
    public static final String HTTP_INTERNALERROR = "500 Internal Server Error";
    public static final String HTTP_NOTIMPLEMENTED = "501 Not Implemented";
    public static final String MIME_PLAINTEXT = "text/plain";
    public static final String MIME_HTML = "text/html";
    public static final String MIME_DEFAULT_BINARY = "application/octet-stream";
    protected boolean isssl = false;
    private ServerSocket ss = null;
    protected boolean alive = true;
    protected Thread fred;
    protected ResponseFilter filter = null;
    private int myTcpPort;
    private static SimpleDateFormat gmtFrmt = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss 'GMT'", Locale.US);

    public static final String printableOnly(String text) {
        return text.replace('\u001b', '.');
    }

    public static final void print_error(String message) {
        System.out.println("\u001b[01;31m[-]\u001b[0m " + NanoHTTPD.printableOnly(message));
    }

    public static final void print_info(String message) {
        System.out.println("\u001b[01;34m[*]\u001b[0m " + NanoHTTPD.printableOnly(message));
    }

    public static final void print_warn(String message) {
        System.out.println("\u001b[01;33m[!]\u001b[0m " + NanoHTTPD.printableOnly(message));
    }

    public static void logException(String activity, Throwable ex, boolean expected) {
        if (expected) {
            NanoHTTPD.print_warn("Trapped " + ex.getClass().getName() + " during " + activity + " [" + Thread.currentThread().getName() + "]: " + ex.getMessage());
        } else {
            NanoHTTPD.print_error("Trapped " + ex.getClass().getName() + " during " + activity + " [" + Thread.currentThread().getName() + "]: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public Response serve(String uri, String method, Properties header, Properties parms) {
        return new Response(HTTP_NOTFOUND, MIME_PLAINTEXT, "This is the default!");
    }

    public NanoHTTPD(int port) throws IOException {
        this(port, false, null, null);
    }

    public boolean alwaysRaw(String uri) {
        return false;
    }

    public NanoHTTPD(int port, boolean ssl, InputStream keystore, String password) throws IOException {
        this.myTcpPort = port;
        this.listen(ssl, keystore, password);
    }

    public boolean isSSL() {
        return this.isssl;
    }

    public SSLServerSocketFactory getSSLFactory(InputStream ksIs, String password) {
        try {
            if (ksIs == null) {
                ksIs = this.getClass().getClassLoader().getResourceAsStream("resources/ssl.store");
                password = "123456";
                NanoHTTPD.print_warn("Web Server will use default SSL certificate (you don't want this).\n\tUse a valid SSL certificate with Cobalt Strike: https://www.cobaltstrike.com/help-malleable-c2#validssl");
            } else {
                NanoHTTPD.print_info("Web Server will use user-specified SSL certifcate");
            }
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(ksIs, password.toCharArray());
            ksIs.close();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, password.toCharArray());
            SSLContext sslcontext = SSLContext.getInstance("SSL");
            sslcontext.init(kmf.getKeyManagers(), new TrustManager[]{new TrustEverything()}, new SecureRandom());
            SSLServerSocketFactory factory = sslcontext.getServerSocketFactory();
            return factory;
        }
        catch (Exception ex) {
            NanoHTTPD.logException("SSL certificate setup", ex, false);
            return null;
        }
    }

    public void listen(boolean ssl, InputStream keystore, String password) throws IOException {
        if (ssl) {
            this.isssl = true;
            SSLServerSocketFactory factory = this.getSSLFactory(keystore, password);
            this.ss = factory.createServerSocket(this.myTcpPort, 32);
            ((SSLServerSocket)this.ss).setEnabledCipherSuites(((SSLServerSocket)this.ss).getSupportedCipherSuites());
        } else {
            this.ss = new ServerSocket(this.myTcpPort);
        }
        Thread t = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */, "Web Server on port " + this.myTcpPort);
        t.setDaemon(true);
        t.start();
        this.fred = t;
    }

    public void setResponseFilter(ResponseFilter filter) {
        this.filter = filter;
    }

    public void stop() {
        this.alive = false;
        this.fred.interrupt();
        try {
            this.ss.close();
        }
        catch (IOException ioex) {
            NanoHTTPD.logException("stop web server", ioex, false);
        }
    }

    private String encodeUri(String uri) {
        try {
            return URLEncoder.encode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return URLEncoder.encode(uri);
        }
    }

    public int getPort() {
        return this.myTcpPort;
    }

    public static String getDate() {
        return gmtFrmt.format(new Date());
    }

    public static void main(String[] args) throws IOException {
        NanoHTTPD server = new NanoHTTPD(443, true, null, null);
        while (true) {
            Thread.yield();
        }
    }

    static /* synthetic */ ServerSocket access$000(NanoHTTPD x0) {
        return x0.ss;
    }

    static /* synthetic */ int access$100(NanoHTTPD x0) {
        return x0.myTcpPort;
    }

    static /* synthetic */ SimpleDateFormat access$200() {
        return gmtFrmt;
    }

    static {
        gmtFrmt.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

