/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.encoding.decoder;

import com.glavsoft.drawing.Renderer;
import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.encoding.decoder.FramebufferUpdateRectangle;
import com.glavsoft.rfb.encoding.decoder.ZlibDecoder;
import com.glavsoft.transport.Reader;

public class ZRLEDecoder
extends ZlibDecoder {
    private static final int DEFAULT_TILE_SIZE = 64;

    @Override
    public void decode(Reader reader, Renderer renderer, FramebufferUpdateRectangle rect) throws TransportException {
        int zippedLength = (int)reader.readUInt32();
        if (0 == zippedLength) {
            return;
        }
        int length = rect.width * rect.height * renderer.getBytesPerPixel();
        byte[] bytes = this.unzip(reader, zippedLength, length);
        int offset = zippedLength;
        int maxX = rect.x + rect.width;
        int maxY = rect.y + rect.height;
        int[] palette = new int[128];
        for (int tileY = rect.y; tileY < maxY; tileY += 64) {
            int tileHeight = Math.min(maxY - tileY, 64);
            for (int tileX = rect.x; tileX < maxX; tileX += 64) {
                int subencoding;
                int tileWidth = Math.min(maxX - tileX, 64);
                boolean isRle = ((subencoding = bytes[offset++] & 0xFF) & 0x80) != 0;
                int paletteSize = subencoding & 0x7F;
                offset += this.readPalette(bytes, offset, renderer, palette, paletteSize);
                if (1 == subencoding) {
                    renderer.fillRect(palette[0], tileX, tileY, tileWidth, tileHeight);
                    continue;
                }
                if (isRle) {
                    if (0 == paletteSize) {
                        offset += this.decodePlainRle(bytes, offset, renderer, tileX, tileY, tileWidth, tileHeight);
                        continue;
                    }
                    offset += this.decodePaletteRle(bytes, offset, renderer, palette, tileX, tileY, tileWidth, tileHeight, paletteSize);
                    continue;
                }
                if (0 == paletteSize) {
                    offset += this.decodeRaw(bytes, offset, renderer, tileX, tileY, tileWidth, tileHeight);
                    continue;
                }
                offset += this.decodePacked(bytes, offset, renderer, palette, paletteSize, tileX, tileY, tileWidth, tileHeight);
            }
        }
    }

    private int decodePlainRle(byte[] bytes, int offset, Renderer renderer, int tileX, int tileY, int tileWidth, int tileHeight) {
        int rlength;
        int bytesPerCPixel = renderer.getBytesPerPixelSignificant();
        int[] decodedBitmap = new int[tileWidth * tileHeight];
        int decodedEnd = tileWidth * tileHeight;
        int index = offset;
        for (int decodedOffset = 0; decodedOffset < decodedEnd; decodedOffset += rlength) {
            int color = renderer.getCompactPixelColor(bytes, index);
            index += bytesPerCPixel;
            rlength = 1;
            do {
                rlength += bytes[index] & 0xFF;
            } while ((bytes[index++] & 0xFF) == 255);
            assert (rlength <= decodedEnd - decodedOffset);
            renderer.fillColorBitmapWithColor(decodedBitmap, decodedOffset, rlength, color);
        }
        renderer.drawColoredBitmap(decodedBitmap, tileX, tileY, tileWidth, tileHeight);
        return index - offset;
    }

    private int decodePaletteRle(byte[] bytes, int offset, Renderer renderer, int[] palette, int tileX, int tileY, int tileWidth, int tileHeight, int paletteSize) {
        int rlength;
        int[] decodedBitmap = new int[tileWidth * tileHeight];
        int decodedEnd = tileWidth * tileHeight;
        int index = offset;
        for (int decodedOffset = 0; decodedOffset < decodedEnd; decodedOffset += rlength) {
            byte colorIndex = bytes[index++];
            int color = palette[colorIndex & 0x7F];
            rlength = 1;
            if ((colorIndex & 0x80) != 0) {
                do {
                    rlength += bytes[index] & 0xFF;
                } while (bytes[index++] == -1);
            }
            assert (rlength <= decodedEnd - decodedOffset);
            renderer.fillColorBitmapWithColor(decodedBitmap, decodedOffset, rlength, color);
        }
        renderer.drawColoredBitmap(decodedBitmap, tileX, tileY, tileWidth, tileHeight);
        return index - offset;
    }

    private int decodePacked(byte[] bytes, int offset, Renderer renderer, int[] palette, int paletteSize, int tileX, int tileY, int tileWidth, int tileHeight) {
        int[] decodedBytes = new int[tileWidth * tileHeight];
        int bitsPerPalletedPixel = paletteSize > 16 ? 8 : (paletteSize > 4 ? 4 : (paletteSize > 2 ? 2 : 1));
        int packedOffset = offset;
        int decodedOffset = 0;
        for (int i = 0; i < tileHeight; ++i) {
            int decodedRowEnd = decodedOffset + tileWidth;
            byte byteProcessed = 0;
            int bitsRemain = 0;
            while (decodedOffset < decodedRowEnd) {
                if (bitsRemain == 0) {
                    byteProcessed = bytes[packedOffset++];
                    bitsRemain = 8;
                }
                int index = byteProcessed >> (bitsRemain -= bitsPerPalletedPixel) & (1 << bitsPerPalletedPixel) - 1 & 0x7F;
                int color = palette[index];
                renderer.fillColorBitmapWithColor(decodedBytes, decodedOffset, 1, color);
                ++decodedOffset;
            }
        }
        renderer.drawColoredBitmap(decodedBytes, tileX, tileY, tileWidth, tileHeight);
        return packedOffset - offset;
    }

    private int decodeRaw(byte[] bytes, int offset, Renderer renderer, int tileX, int tileY, int tileWidth, int tileHeight) throws TransportException {
        return renderer.drawCompactBytes(bytes, offset, tileX, tileY, tileWidth, tileHeight);
    }

    private int readPalette(byte[] bytes, int offset, Renderer renderer, int[] palette, int paletteSize) {
        for (int i = 0; i < paletteSize; ++i) {
            palette[i] = renderer.getCompactPixelColor(bytes, offset + i * renderer.getBytesPerPixelSignificant());
        }
        return paletteSize * renderer.getBytesPerPixelSignificant();
    }
}

