/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.protocol;

import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.client.ClientToServerMessage;
import com.glavsoft.rfb.protocol.MessageQueue;
import com.glavsoft.rfb.protocol.ProtocolContext;
import com.glavsoft.transport.Writer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Logger;

public class SenderTask
implements Runnable {
    private final MessageQueue queue;
    private final Writer writer;
    private final ProtocolContext protocolContext;
    private volatile boolean isRunning = false;

    public SenderTask(MessageQueue messageQueue, Writer writer, ProtocolContext protocolContext) {
        this.queue = messageQueue;
        this.writer = writer;
        this.protocolContext = protocolContext;
    }

    @Override
    public void run() {
        this.isRunning = true;
        while (this.isRunning) {
            try {
                ClientToServerMessage message = this.queue.get();
                if (message == null) continue;
                message.send(this.writer);
            }
            catch (InterruptedException e) {
            }
            catch (TransportException e) {
                Logger.getLogger("com.glavsoft.rfb.protocol").severe("Close session: " + e.getMessage());
                if (this.isRunning) {
                    this.protocolContext.cleanUpSession("Connection closed");
                }
                this.stopTask();
            }
            catch (Throwable te) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                te.printStackTrace(pw);
                if (this.isRunning) {
                    this.protocolContext.cleanUpSession(te.getMessage() + "\n" + sw.toString());
                }
                this.stopTask();
            }
        }
    }

    public void stopTask() {
        this.isRunning = false;
    }
}

