/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing;

import com.glavsoft.core.SettingsChangedEvent;
import com.glavsoft.drawing.Renderer;
import com.glavsoft.rfb.IChangeSettingsListener;
import com.glavsoft.rfb.IRepaintController;
import com.glavsoft.rfb.encoding.PixelFormat;
import com.glavsoft.rfb.encoding.decoder.FramebufferUpdateRectangle;
import com.glavsoft.rfb.protocol.ProtocolContext;
import com.glavsoft.rfb.protocol.ProtocolSettings;
import com.glavsoft.transport.Reader;
import com.glavsoft.viewer.Viewer;
import com.glavsoft.viewer.swing.KeyEventListener;
import com.glavsoft.viewer.swing.ModifierButtonEventListener;
import com.glavsoft.viewer.swing.MouseEventListener;
import com.glavsoft.viewer.swing.RendererImpl;
import com.glavsoft.viewer.swing.SoftCursorImpl;
import com.glavsoft.viewer.swing.UiSettings;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class Surface
extends JPanel
implements IRepaintController,
IChangeSettingsListener {
    private int width;
    private int height;
    private SoftCursorImpl cursor;
    private RendererImpl renderer;
    private MouseEventListener mouseEventListener;
    private KeyEventListener keyEventListener;
    private boolean showCursor;
    private ModifierButtonEventListener modifierButtonListener;
    private boolean isUserInputEnabled = false;
    private final ProtocolContext context;
    private double scaleFactor;
    private final Viewer viewer;
    public Dimension oldSize;

    @Override
    public boolean isDoubleBuffered() {
        return false;
    }

    public Surface(ProtocolContext context, Viewer viewer, double scaleFactor) {
        this.context = context;
        this.viewer = viewer;
        this.scaleFactor = scaleFactor;
        this.init(context.getFbWidth(), context.getFbHeight());
        this.oldSize = this.getPreferredSize();
        this.showCursor = context.getSettings().isShowRemoteCursor();
    }

    public void setViewOnly(boolean really) {
        this.setUserInputEnabled(!really, this.context.getSettings().isConvertToAscii());
    }

    private void setUserInputEnabled(boolean enable, boolean convertToAscii) {
        if (enable == this.isUserInputEnabled) {
            return;
        }
        this.isUserInputEnabled = enable;
        if (enable) {
            if (null == this.mouseEventListener) {
                this.mouseEventListener = new MouseEventListener(this, this.context, this.scaleFactor);
            }
            this.addMouseListener(this.mouseEventListener);
            this.addMouseMotionListener(this.mouseEventListener);
            this.addMouseWheelListener(this.mouseEventListener);
            this.setFocusTraversalKeysEnabled(false);
            if (null == this.keyEventListener) {
                this.keyEventListener = new KeyEventListener(this.context);
                if (this.modifierButtonListener != null) {
                    this.keyEventListener.addModifierListener(this.modifierButtonListener);
                }
            }
            this.keyEventListener.setConvertToAscii(convertToAscii);
            this.addKeyListener(this.keyEventListener);
            this.enableInputMethods(false);
        } else {
            this.removeMouseListener(this.mouseEventListener);
            this.removeMouseMotionListener(this.mouseEventListener);
            this.removeMouseWheelListener(this.mouseEventListener);
            this.removeKeyListener(this.keyEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Renderer createRenderer(Reader reader, int width, int height, PixelFormat pixelFormat) {
        RendererImpl rendererImpl = this.renderer = new RendererImpl(reader, width, height, pixelFormat);
        synchronized (rendererImpl) {
            this.cursor = this.renderer.getCursor();
        }
        this.init(this.renderer.getWidth(), this.renderer.getHeight());
        this.updateFrameSize();
        return this.renderer;
    }

    private void init(int width, int height) {
        this.width = width;
        this.height = height;
        this.setSize(this.getPreferredSize());
    }

    private void updateFrameSize() {
        this.setSize(this.getPreferredSize());
        this.viewer.packContainer();
        this.requestFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        if (this.renderer == null) {
            return;
        }
        ((Graphics2D)g).scale(this.scaleFactor, this.scaleFactor);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Object object = this.renderer;
        synchronized (object) {
            Image offscreenImage = this.renderer.getOffscreenImage();
            if (offscreenImage != null) {
                g.drawImage(offscreenImage, 0, 0, null);
            }
        }
        object = this.cursor;
        synchronized (object) {
            Image cursorImage = this.cursor.getImage();
            if (this.showCursor && cursorImage != null && (this.scaleFactor != 1.0 || g.getClipBounds().intersects(this.cursor.rX, this.cursor.rY, this.cursor.width, this.cursor.height))) {
                g.drawImage(cursorImage, this.cursor.rX, this.cursor.rY, null);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension((int)((double)this.width * this.scaleFactor), (int)((double)this.height * this.scaleFactor));
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void repaintBitmap(FramebufferUpdateRectangle rect) {
        this.repaintBitmap(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public void repaintBitmap(int x, int y, int width, int height) {
        this.repaint((int)((double)x * this.scaleFactor), (int)((double)y * this.scaleFactor), (int)Math.ceil((double)width * this.scaleFactor), (int)Math.ceil((double)height * this.scaleFactor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repaintCursor() {
        SoftCursorImpl softCursorImpl = this.cursor;
        synchronized (softCursorImpl) {
            this.repaint((int)((double)this.cursor.oldRX * this.scaleFactor), (int)((double)this.cursor.oldRY * this.scaleFactor), (int)Math.ceil((double)this.cursor.oldWidth * this.scaleFactor) + 1, (int)Math.ceil((double)this.cursor.oldHeight * this.scaleFactor) + 1);
            this.repaint((int)((double)this.cursor.rX * this.scaleFactor), (int)((double)this.cursor.rY * this.scaleFactor), (int)Math.ceil((double)this.cursor.width * this.scaleFactor) + 1, (int)Math.ceil((double)this.cursor.height * this.scaleFactor) + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCursorPosition(short x, short y) {
        SoftCursorImpl softCursorImpl = this.cursor;
        synchronized (softCursorImpl) {
            this.cursor.updatePosition(x, y);
            this.repaintCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showCursor(boolean show) {
        SoftCursorImpl softCursorImpl = this.cursor;
        synchronized (softCursorImpl) {
            this.showCursor = show;
        }
    }

    public void addModifierListener(ModifierButtonEventListener modifierButtonListener) {
        this.modifierButtonListener = modifierButtonListener;
        if (this.keyEventListener != null) {
            this.keyEventListener.addModifierListener(modifierButtonListener);
        }
    }

    @Override
    public void settingsChanged(SettingsChangedEvent e) {
        if (ProtocolSettings.isRfbSettingsChangedFired(e)) {
            ProtocolSettings settings = (ProtocolSettings)e.getSource();
            this.setUserInputEnabled(!settings.isViewOnly(), settings.isConvertToAscii());
            this.showCursor(settings.isShowRemoteCursor());
        } else if (UiSettings.isUiSettingsChangedFired(e)) {
            UiSettings settings = (UiSettings)e.getSource();
            this.oldSize = this.getPreferredSize();
            this.scaleFactor = settings.getScaleFactor();
        }
        if (this.mouseEventListener != null) {
            this.mouseEventListener.setScaleFactor(this.scaleFactor);
        }
        this.updateFrameSize();
    }

    @Override
    public void setPixelFormat(PixelFormat pixelFormat) {
        if (this.renderer != null) {
            this.renderer.initPixelFormat(pixelFormat);
        }
    }
}

