/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import com.xmlmind.fo.converter.docx.Wml;
import com.xmlmind.fo.properties.Color;
import java.io.PrintWriter;

public final class Border
implements Cloneable {
    public static final int SIDE_ALL = 0;
    public static final int SIDE_TOP = 1;
    public static final int SIDE_BOTTOM = 2;
    public static final int SIDE_LEFT = 3;
    public static final int SIDE_RIGHT = 4;
    public int side;
    public int style;
    public double width;
    public Color color;
    public double space;

    public Border(int n) {
        this(n, 125, 0.0, null, 0.0);
    }

    public Border(int n, int n2, double d, Color color, double d2) {
        this.side = n;
        this.set(n2, d, color, d2);
    }

    public void set(int n, double d, Color color, double d2) {
        this.style = n;
        this.width = d;
        this.color = color;
        this.space = d2;
    }

    public boolean materialized() {
        if (this.style != 125 && this.style != 75 && this.width > 0.0) {
            return true;
        }
        return this.space > 0.0;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("<w:" + this.side());
        printWriter.print(" w:val=\"" + this.style() + "\"");
        if (this.width > 0.0) {
            printWriter.print(" w:sz=\"" + Math.round(8.0 * this.width()) + "\"");
        }
        if (this.color != null) {
            printWriter.print(" w:color=\"" + Wml.hexColorType(this.color) + "\"");
        }
        if (this.space > 0.0) {
            printWriter.print(" w:space=\"" + Math.round(this.space) + "\"");
        }
        printWriter.print(" />");
    }

    private String side() {
        String string;
        switch (this.side) {
            default: {
                string = "bdr";
                break;
            }
            case 1: {
                string = "top";
                break;
            }
            case 2: {
                string = "bottom";
                break;
            }
            case 3: {
                string = "left";
                break;
            }
            case 4: {
                string = "right";
            }
        }
        return string;
    }

    private String style() {
        String string;
        switch (this.style) {
            default: {
                string = "none";
                break;
            }
            case 187: {
                string = "single";
                break;
            }
            case 50: {
                string = "double";
                break;
            }
            case 49: {
                string = "dotted";
                break;
            }
            case 42: {
                string = "dashed";
                break;
            }
            case 73: {
                string = "threeDEngrave";
                break;
            }
            case 164: {
                string = "threeDEmboss";
                break;
            }
            case 89: {
                string = "inset";
                break;
            }
            case 143: {
                string = "outset";
            }
        }
        return string;
    }

    private double width() {
        if (this.style == 50) {
            double d = this.width / 3.0;
            if (d <= 0.0) {
                d = 1.0;
            }
            return d;
        }
        return this.width;
    }

    public Border copy() {
        Border border = null;
        try {
            border = (Border)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return border;
    }
}

