/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import com.xmlmind.fo.converter.docx.Border;
import com.xmlmind.fo.properties.Color;
import com.xmlmind.fo.properties.Value;
import java.io.PrintWriter;

public final class Borders {
    private static final double BORDER_THIN = 1.0;
    private static final double BORDER_MEDIUM = 2.0;
    private static final double BORDER_THICK = 3.0;
    private static final double BORDER_MIN_WIDTH = 0.25;
    private static final double BORDER_MAX_WIDTH = 12.0;
    public Border top = new Border(1);
    public Border bottom = new Border(2);
    public Border left = new Border(3);
    public Border right = new Border(4);

    public Borders() {
    }

    public Borders(Value[] valueArray) {
        this();
        this.initialize(valueArray);
    }

    public void initialize(Value[] valueArray) {
        Color color;
        double d;
        int n = valueArray[66].keyword();
        double d2 = Borders.space(valueArray[208]);
        if (n != 125) {
            d = Borders.width(valueArray[67]);
            color = valueArray[65].color();
            this.top.set(n, d, color, d2);
        } else {
            this.top.space = d2;
        }
        n = valueArray[35].keyword();
        d2 = Borders.space(valueArray[199]);
        if (n != 125) {
            d = Borders.width(valueArray[36]);
            color = valueArray[34].color();
            this.bottom.set(n, d, color, d2);
        } else {
            this.bottom.space = d2;
        }
        n = valueArray[47].keyword();
        d2 = Borders.space(valueArray[203]);
        if (n != 125) {
            d = Borders.width(valueArray[48]);
            color = valueArray[46].color();
            this.left.set(n, d, color, d2);
        } else {
            this.left.space = d2;
        }
        n = valueArray[51].keyword();
        d2 = Borders.space(valueArray[204]);
        if (n != 125) {
            d = Borders.width(valueArray[52]);
            color = valueArray[50].color();
            this.right.set(n, d, color, d2);
        } else {
            this.right.space = d2;
        }
    }

    private static double width(Value value) {
        double d = 0.0;
        if (value.type == 1) {
            switch (value.keyword()) {
                case 202: {
                    d = 1.0;
                    break;
                }
                case 118: {
                    d = 2.0;
                    break;
                }
                case 203: {
                    d = 3.0;
                }
            }
        } else if (value.type == 4) {
            d = value.length();
            if (d > 0.0) {
                if (d < 0.25) {
                    d = 0.25;
                } else if (d > 12.0) {
                    d = 12.0;
                }
            } else if (d < 0.0) {
                d = 0.0;
            }
        }
        return d;
    }

    private static double space(Value value) {
        double d = 0.0;
        if (value.type == 4 && (d = value.length()) < 0.0) {
            d = 0.0;
        }
        return d;
    }

    public boolean materialized() {
        return this.top.materialized() || this.bottom.materialized() || this.left.materialized() || this.right.materialized();
    }

    public void print(PrintWriter printWriter) {
        if (this.top.materialized()) {
            this.top.print(printWriter);
        }
        if (this.left.materialized()) {
            this.left.print(printWriter);
        }
        if (this.bottom.materialized()) {
            this.bottom.print(printWriter);
        }
        if (this.right.materialized()) {
            this.right.print(printWriter);
        }
    }

    public Borders copy() {
        Borders borders = new Borders();
        borders.top = this.top.copy();
        borders.bottom = this.bottom.copy();
        borders.left = this.left.copy();
        borders.right = this.right.copy();
        return borders;
    }
}

