/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import com.xmlmind.fo.util.Encoding;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;

public final class ContentTypes {
    public static final String TYPE_OFFICE_DOCUMENT = "application/vnd.openxmlformats-officedocument";
    public static final String TYPE_WORDPROCESSINGML = "application/vnd.openxmlformats-officedocument.wordprocessingml";
    public static final String TYPE_CUSTOMXML_PROPERTIES = "application/vnd.openxmlformats-officedocument.customXmlProperties+xml";
    public static final String TYPE_DOCUMENT_SETTINGS = "application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml";
    public static final String TYPE_FONT_TABLE = "application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml";
    public static final String TYPE_FOOTER = "application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml";
    public static final String TYPE_FOOTNOTES = "application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml";
    public static final String TYPE_HEADER = "application/vnd.openxmlformats-officedocument.wordprocessingml.header+xml";
    public static final String TYPE_MAIN_DOCUMENT = "application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml";
    public static final String TYPE_NUMBERING_DEFINITIONS = "application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml";
    public static final String TYPE_RELATIONSHIPS = "application/vnd.openxmlformats-package.relationships+xml";
    private static final String NAMESPACE_URI = "http://schemas.openxmlformats.org/package/2006/content-types";
    private Vector defaults = new Vector();
    private Vector overrides = new Vector();

    public ContentTypes() {
        this.addDefault("rels", TYPE_RELATIONSHIPS);
        this.addDefault("xml", "application/xml");
        this.addDefault("gif", "image/gif");
        this.addDefault("jpg", "image/jpeg");
        this.addDefault("png", "image/png");
        this.addDefault("wmf", "image/x-wmf");
        this.addDefault("emf", "image/x-emf");
    }

    public void addDefault(String string, String string2) {
        this.defaults.addElement(new Default(string, string2));
    }

    public void addOverride(String string, String string2) {
        this.overrides.addElement(new Override(string, string2));
    }

    public byte[] getBytes(String string) throws Exception {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("<?xml version=\"1.0\" encoding=\"" + Encoding.officialName(string) + "\"?>");
        this.print(printWriter);
        printWriter.flush();
        return stringWriter.toString().getBytes(string);
    }

    private void print(PrintWriter printWriter) {
        Object object;
        int n;
        printWriter.println("<Types xmlns=\"http://schemas.openxmlformats.org/package/2006/content-types\">");
        int n2 = this.defaults.size();
        for (n = 0; n < n2; ++n) {
            object = (Default)this.defaults.elementAt(n);
            printWriter.println("  <Default Extension=\"" + ((Default)object).extension + "\"");
            printWriter.println("    ContentType=\"" + ((Default)object).contentType + "\"/>");
        }
        n2 = this.overrides.size();
        for (n = 0; n < n2; ++n) {
            object = (Override)this.overrides.elementAt(n);
            printWriter.println("  <Override PartName=\"" + ((Override)object).partName + "\"");
            printWriter.println("    ContentType=\"" + ((Override)object).contentType + "\"/>");
        }
        printWriter.println("</Types>");
    }

    private class Override {
        String partName;
        String contentType;

        Override(String string, String string2) {
            this.partName = string;
            this.contentType = string2;
        }
    }

    private class Default {
        String extension;
        String contentType;

        Default(String string, String string2) {
            this.extension = string;
            this.contentType = string2;
        }
    }
}

