/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import com.xmlmind.fo.converter.docx.Wml;
import com.xmlmind.fo.font.FontUtil;
import java.io.PrintWriter;

public final class FontFace {
    public static final String FAMILY_ROMAN = "roman";
    public static final String FAMILY_SWISS = "swiss";
    public static final String FAMILY_MODERN = "modern";
    public static final String FAMILY_DECORATIVE = "decorative";
    public static final String FAMILY_SCRIPT = "script";
    public static final int CHARSET_UNDEFINED = -1;
    public static final int CHARSET_ANSI = 0;
    public static final int CHARSET_SYMBOL = 2;
    public static final int CHARSET_RUSSIAN = 204;
    public static final int CHARSET_EASTERN_EUROPEAN = 238;
    public String name;
    public String family;
    public int charset;

    public FontFace(String string) {
        this(string, null);
    }

    public FontFace(String string, String string2) {
        this(string, string2, -1);
    }

    public FontFace(String string, String string2, int n) {
        this.name = string;
        if (string2 == null) {
            switch (FontUtil.toGenericFamily(string, false)) {
                case 1: {
                    string2 = FAMILY_ROMAN;
                    break;
                }
                case 2: {
                    string2 = FAMILY_SWISS;
                    break;
                }
                case 3: {
                    string2 = FAMILY_MODERN;
                    break;
                }
                case 4: {
                    string2 = FAMILY_DECORATIVE;
                    break;
                }
                case 5: {
                    string2 = FAMILY_SCRIPT;
                }
            }
        }
        this.family = string2;
        this.charset = n;
    }

    public void print(PrintWriter printWriter) {
        printWriter.println("<w:font w:name=\"" + this.name + "\">");
        if (this.charset != -1) {
            String string = Wml.ucharHexNumberType(this.charset);
            printWriter.println("<w:charset w:val=\"" + string + "\" />");
        }
        if (this.family != null) {
            printWriter.println("<w:family w:val=\"" + this.family + "\" />");
        }
        printWriter.println("</w:font>");
    }

    public int hashCode() {
        return this.name.toLowerCase().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FontFace)) {
            return false;
        }
        FontFace fontFace = (FontFace)object;
        return this.name.equalsIgnoreCase(fontFace.name);
    }
}

