/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.docx.Borders;
import com.xmlmind.fo.converter.docx.RunProperties;
import com.xmlmind.fo.converter.docx.TabStops;
import com.xmlmind.fo.converter.docx.Wml;
import com.xmlmind.fo.properties.Color;
import com.xmlmind.fo.properties.Value;
import java.io.PrintWriter;

public final class ParagraphProperties {
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_CENTER = 1;
    public static final int ALIGNMENT_RIGHT = 2;
    public static final int ALIGNMENT_JUSTIFIED = 3;
    public int breakBefore;
    public double spaceBefore;
    public double lineHeight;
    public boolean keepTogether;
    public boolean keepWithNext;
    public int alignment;
    public double startIndent;
    public double endIndent;
    public double firstLineIndent;
    public int outlineLevel;
    public Borders borders;
    public Color background;
    public int numberingId;
    public TabStops tabStops = new TabStops();
    public RunProperties markProperties;

    public ParagraphProperties() {
    }

    public ParagraphProperties(Context context) {
        this();
        this.initialize(context);
    }

    public void initialize(Context context) {
        Context context2 = context.block();
        Value[] valueArray = context2.properties.values;
        this.breakBefore = context2.breakBefore;
        this.spaceBefore = context2.spaceBefore();
        this.lineHeight = ParagraphProperties.length(context2.lineHeight);
        this.keepTogether = ParagraphProperties.keep(valueArray[137]);
        this.keepWithNext = ParagraphProperties.keep(valueArray[141]);
        switch (valueArray[289].keyword()) {
            default: {
                break;
            }
            case 31: {
                this.alignment = 1;
                break;
            }
            case 52: 
            case 144: 
            case 165: {
                this.alignment = 2;
                break;
            }
            case 93: {
                this.alignment = 3;
            }
        }
        this.startIndent = ParagraphProperties.length(valueArray[277]);
        this.endIndent = ParagraphProperties.length(valueArray[97]);
        this.firstLineIndent = ParagraphProperties.length(valueArray[294]);
        this.outlineLevel = ParagraphProperties.integer(valueArray[322], 0);
        this.borders = new Borders(valueArray);
        this.background = context2.background;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("<w:pPr>");
        if (this.keepWithNext) {
            printWriter.print("<w:keepNext />");
        }
        if (this.keepTogether) {
            printWriter.print("<w:keepLines />");
        }
        if (this.breakBefore == 2) {
            printWriter.print("<w:pageBreakBefore />");
        }
        if (this.numberingId != 0) {
            printWriter.print("<w:numPr>");
            printWriter.print("<w:ilvl w:val=\"0\" />");
            printWriter.print("<w:numId w:val=\"" + this.numberingId + "\" />");
            printWriter.print("</w:numPr>");
        }
        if (this.borders != null && this.borders.materialized()) {
            printWriter.print("<w:pBdr>");
            this.borders.print(printWriter);
            printWriter.print("</w:pBdr>");
        }
        if (this.background != null) {
            printWriter.print("<w:shd");
            printWriter.print(" w:val=\"clear\"");
            printWriter.print(" w:fill=\"" + Wml.hexColorType(this.background) + "\"");
            printWriter.print(" />");
        }
        if (this.tabStops.count() > 0) {
            this.tabStops.print(printWriter);
        }
        printWriter.print("<w:spacing");
        printWriter.print(" w:before=\"" + Math.round(20.0 * this.spaceBefore) + "\"");
        printWriter.print(" w:after=\"0\"");
        if (this.lineHeight > 0.0) {
            printWriter.print(" w:line=\"" + Math.round(20.0 * this.lineHeight) + "\"");
            printWriter.print(" w:lineRule=\"atLeast\"");
        } else {
            printWriter.print(" w:line=\"240\" w:lineRule=\"auto\"");
        }
        printWriter.print(" />");
        if (this.startIndent > 0.0 || this.endIndent > 0.0 || this.firstLineIndent != 0.0) {
            printWriter.print("<w:ind");
            printWriter.print(" w:left=\"" + Math.round(20.0 * this.startIndent) + "\"");
            printWriter.print(" w:right=\"" + Math.round(20.0 * this.endIndent) + "\"");
            int n = (int)Math.round(20.0 * this.firstLineIndent);
            if (n < 0) {
                printWriter.print(" w:hanging=\"" + -n + "\"");
            } else {
                printWriter.print(" w:firstLine=\"" + n + "\"");
            }
            printWriter.print(" />");
        }
        if (this.alignment != 0) {
            printWriter.print("<w:jc");
            printWriter.print(" w:val=\"" + this.alignment() + "\"");
            printWriter.print(" />");
        }
        if (this.outlineLevel >= 1 && this.outlineLevel <= 9) {
            printWriter.print("<w:outlineLvl w:val=\"" + Integer.toString(this.outlineLevel - 1) + "\" />");
        }
        if (this.markProperties != null) {
            this.markProperties.print(printWriter);
        }
        printWriter.println("</w:pPr>");
    }

    private static int integer(Value value, int n) {
        if (value != null && value.type == 2) {
            return value.integer();
        }
        return n;
    }

    private static double length(Value value) {
        double d = 0.0;
        if (value.type == 4) {
            d = value.length();
        }
        return d;
    }

    private static boolean keep(Value value) {
        boolean bl = false;
        switch (value.type) {
            case 1: {
                if (value.keyword() != 8) break;
                bl = true;
                break;
            }
            case 2: {
                if (value.integer() <= 0) break;
                bl = true;
            }
        }
        return bl;
    }

    private String alignment() {
        String string;
        switch (this.alignment) {
            default: {
                string = "left";
                break;
            }
            case 1: {
                string = "center";
                break;
            }
            case 2: {
                string = "right";
                break;
            }
            case 3: {
                string = "both";
            }
        }
        return string;
    }
}

