/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import com.xmlmind.fo.converter.GraphicLayout;
import com.xmlmind.fo.converter.docx.DocxGraphicEnv;
import com.xmlmind.fo.converter.docx.RunProperties;
import com.xmlmind.fo.converter.docx.Wml;
import com.xmlmind.fo.graphic.Graphic;
import com.xmlmind.fo.graphic.GraphicEnv;
import com.xmlmind.fo.graphic.GraphicFactories;
import com.xmlmind.fo.objects.ExternalGraphic;
import com.xmlmind.fo.util.URLUtil;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Locale;

public class Picture {
    private Graphic graphic;
    private DocxGraphicEnv graphicEnv;
    private RunProperties properties;
    private boolean prescaled;
    private int imageResolution;
    private int imageRendererResolution;
    private String[] graphicFormats;
    private boolean useVML;
    private double xScale = 1.0;
    private double yScale = 1.0;
    private Graphic picture;
    private GraphicLayout layout;
    private int index;
    private String id;
    private static final String[] graphicFormats1 = new String[]{"image/x-wmf", "image/x-emf", "image/jpeg", "image/png"};
    private static final String[] graphicFormats2 = new String[]{"image/x-wmf", "image/x-emf", "image/png"};
    private NumberFormat numberFormat;

    public Picture(Graphic graphic, DocxGraphicEnv docxGraphicEnv, RunProperties runProperties, boolean bl, int n, int n2, boolean bl2, boolean bl3) {
        this.graphic = graphic;
        this.graphicEnv = docxGraphicEnv;
        this.properties = runProperties;
        this.prescaled = bl;
        this.imageResolution = n;
        this.imageRendererResolution = n2;
        this.graphicFormats = bl2 ? graphicFormats2 : graphicFormats1;
        this.useVML = bl3;
        this.numberFormat = NumberFormat.getInstance(Locale.US);
        this.numberFormat.setGroupingUsed(false);
        this.numberFormat.setMinimumIntegerDigits(1);
    }

    public double width() {
        double d = GraphicLayout.width(this.graphic, this.imageResolution);
        if (d == 0.0) {
            d = GraphicLayout.intrinsicWidth(this.graphic, this.imageResolution);
        }
        if (this.properties != null && this.properties.border != null) {
            d += (this.properties.border.width + this.properties.border.space) * 2.0;
        }
        return d;
    }

    public void layout(double d) throws Exception {
        if (this.id != null) {
            return;
        }
        if (this.properties != null && this.properties.border != null) {
            d -= (this.properties.border.width + this.properties.border.space) * 2.0;
        }
        this.layout = new GraphicLayout(this.graphic, this.imageResolution, d);
        double d2 = GraphicLayout.intrinsicWidth(this.graphic, this.imageRendererResolution);
        double d3 = GraphicLayout.intrinsicHeight(this.graphic, this.imageRendererResolution);
        if (this.layout.contentWidth != d2) {
            this.xScale = this.layout.contentWidth / d2;
        }
        if (this.layout.contentHeight != d3) {
            this.yScale = this.layout.contentHeight / d3;
        }
        switch (this.graphic.getType()) {
            case 2: {
                this.prescaled = true;
                break;
            }
            case 0: {
                this.prescaled = false;
                break;
            }
            default: {
                if (this.xScale < 1.0 && this.yScale < 1.0) break;
                this.prescaled = false;
            }
        }
        try {
            this.picture = this.prescaled ? GraphicFactories.convertGraphic(this.graphic, this.graphicFormats, this.xScale, this.yScale, null, (GraphicEnv)this.graphicEnv) : GraphicFactories.convertGraphic(this.graphic, this.graphicFormats, 1.0, 1.0, null, (GraphicEnv)this.graphicEnv);
        }
        catch (Exception exception) {
            this.graphicEnv.reportWarning("failed to convert image \"" + this.graphic.getLocation() + "\": " + exception.getMessage());
            return;
        }
        this.index = this.graphicEnv.images.count();
        String string = this.graphicEnv.images.add(URLUtil.locationToFilename(this.picture.getLocation()), this.picture.getFormat());
        this.id = this.graphicEnv.relationships.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/image", string);
        if (this.properties != null) {
            double d4 = this.properties.fontSize;
            double d5 = this.properties.fontSize / 4.0;
            double d6 = (d4 + d5) / 2.0 - d5;
            switch (this.properties.alignmentBaseline) {
                case 121: {
                    this.properties.baselineShift = -(this.layout.viewportHeight / 2.0) + d6;
                    break;
                }
                case 17: 
                case 199: {
                    this.properties.baselineShift = -this.layout.viewportHeight + d4;
                    break;
                }
                case 5: 
                case 198: {
                    this.properties.baselineShift = -d5;
                }
            }
        }
    }

    public void print(PrintWriter printWriter) {
        if (this.id == null) {
            return;
        }
        printWriter.println("<w:r>");
        if (this.properties != null) {
            this.properties.print(printWriter);
        }
        if (this.useVML) {
            this.printVMLPicture(printWriter);
        } else {
            this.printPicture(printWriter);
        }
        printWriter.println("</w:r>");
    }

    private void printPicture(PrintWriter printWriter) {
        printWriter.println("<w:drawing>");
        printWriter.println("<wp:inline>");
        printWriter.print("<wp:extent cx=\"");
        printWriter.print(Picture.ptToEMU(this.layout.viewportWidth));
        printWriter.print("\" cy=\"");
        printWriter.print(Picture.ptToEMU(this.layout.viewportHeight));
        printWriter.println("\"/>");
        String string = this.name();
        String string2 = this.role();
        printWriter.print("<wp:docPr id=\"");
        printWriter.print(this.graphicEnv.images.getNextId());
        printWriter.print("\" name=\"");
        printWriter.print(Wml.escape(string));
        if (string2 != null) {
            printWriter.print("\" descr=\"");
            printWriter.print(Wml.escape(string2));
        }
        printWriter.println("\"/>");
        printWriter.println("<a:graphic>");
        printWriter.println("<a:graphicData uri=\"http://schemas.openxmlformats.org/drawingml/2006/picture\">");
        printWriter.println("<p:pic>");
        printWriter.println("<p:nvPicPr>");
        printWriter.print("<p:cNvPr id=\"");
        printWriter.print(this.graphicEnv.images.getNextId());
        printWriter.print("\" name=\"");
        printWriter.print(Wml.escape(string));
        if (string2 != null) {
            printWriter.print("\" descr=\"");
            printWriter.print(Wml.escape(string2));
        }
        printWriter.println("\"/>");
        printWriter.println("<p:cNvPicPr/>");
        printWriter.println("</p:nvPicPr>");
        printWriter.println("<p:blipFill>");
        printWriter.print("<a:blip r:embed=\"");
        printWriter.print(this.id);
        printWriter.println("\"/>");
        if (this.layout.contentWidth != this.layout.viewportWidth || this.layout.contentHeight != this.layout.viewportHeight) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            if (this.layout.contentWidth < this.layout.viewportWidth) {
                d = -this.layout.contentX;
                double d5 = this.layout.contentX + this.layout.contentWidth;
                d3 = -(this.layout.viewportWidth - d5);
            } else if (this.layout.contentWidth > this.layout.viewportWidth) {
                d = this.layout.cropX;
                double d6 = this.layout.cropX + this.layout.viewportWidth;
                d3 = this.layout.contentWidth - d6;
            }
            d = d * 100000.0 / this.layout.contentWidth;
            d3 = d3 * 100000.0 / this.layout.contentWidth;
            if (this.layout.contentHeight < this.layout.viewportHeight) {
                d2 = -this.layout.contentY;
                double d7 = this.layout.contentY + this.layout.contentHeight;
                d4 = -(this.layout.viewportHeight - d7);
            } else if (this.layout.contentHeight > this.layout.viewportHeight) {
                d2 = this.layout.cropY;
                double d8 = this.layout.cropY + this.layout.viewportHeight;
                d4 = this.layout.contentHeight - d8;
            }
            d2 = d2 * 100000.0 / this.layout.contentHeight;
            d4 = d4 * 100000.0 / this.layout.contentHeight;
            printWriter.println("<a:srcRect");
            printWriter.print(" l=\"" + (int)Math.rint(d) + "\"");
            printWriter.print(" t=\"" + (int)Math.rint(d2) + "\"");
            printWriter.print(" r=\"" + (int)Math.rint(d3) + "\"");
            printWriter.print(" b=\"" + (int)Math.rint(d4) + "\"");
            printWriter.println(" />");
        } else {
            printWriter.println("<a:srcRect/>");
        }
        printWriter.println("<a:stretch>");
        printWriter.println("<a:fillRect/>");
        printWriter.println("</a:stretch>");
        printWriter.println("</p:blipFill>");
        printWriter.println("<p:spPr>");
        printWriter.println("<a:xfrm>");
        printWriter.println("<a:off x=\"0\" y=\"0\"/>");
        printWriter.print("<a:ext cx=\"");
        printWriter.print(Picture.ptToEMU(this.layout.viewportWidth));
        printWriter.print("\" cy=\"");
        printWriter.print(Picture.ptToEMU(this.layout.viewportHeight));
        printWriter.println("\"/>");
        printWriter.println("</a:xfrm>");
        printWriter.println("<a:prstGeom prst=\"rect\"/>");
        printWriter.println("</p:spPr>");
        printWriter.println("</p:pic>");
        printWriter.println("</a:graphicData>");
        printWriter.println("</a:graphic>");
        printWriter.println("</wp:inline>");
        printWriter.println("</w:drawing>");
    }

    private String name() {
        String string = null;
        Object object = this.graphic.getClientData();
        if (object != null && object instanceof ExternalGraphic && this.graphic.getType() != 2 && (string = this.graphic.getLocation()) != null) {
            string = URLUtil.locationToFilename(string);
        }
        if (string == null) {
            string = "Picture " + this.index;
        }
        return string;
    }

    private String role() {
        String string = null;
        ExternalGraphic externalGraphic = GraphicLayout.properties(this.graphic);
        if (externalGraphic != null && (string = externalGraphic.role) != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        return string;
    }

    private static final long ptToEMU(double d) {
        return (long)Math.rint(d * 914400.0 / 72.0);
    }

    private void printVMLPicture(PrintWriter printWriter) {
        printWriter.println("<w:pict>");
        printWriter.print("<v:shape filled=\"f\"");
        String string = null;
        ExternalGraphic externalGraphic = GraphicLayout.properties(this.graphic);
        if (externalGraphic != null) {
            string = externalGraphic.role;
        }
        if (string != null && string.length() > 0) {
            printWriter.print(" alt=\"");
            printWriter.print(Wml.escape(string));
            printWriter.print("\"");
        }
        printWriter.print(" style=\"");
        printWriter.print("width:" + this.format(this.layout.viewportWidth, 2) + "pt;");
        printWriter.print("height:" + this.format(this.layout.viewportHeight, 2) + "pt");
        printWriter.println("\">");
        printWriter.print("<v:imagedata r:id=\"" + this.id + "\"");
        if (this.layout.contentWidth != this.layout.viewportWidth || this.layout.contentHeight != this.layout.viewportHeight) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            if (this.layout.contentWidth < this.layout.viewportWidth) {
                d = -this.layout.contentX;
                double d5 = this.layout.contentX + this.layout.contentWidth;
                d3 = -(this.layout.viewportWidth - d5);
            } else if (this.layout.contentWidth > this.layout.viewportWidth) {
                d = this.layout.cropX;
                double d6 = this.layout.cropX + this.layout.viewportWidth;
                d3 = this.layout.contentWidth - d6;
            }
            d /= this.layout.contentWidth;
            d3 /= this.layout.contentWidth;
            if (this.layout.contentHeight < this.layout.viewportHeight) {
                d2 = -this.layout.contentY;
                double d7 = this.layout.contentY + this.layout.contentHeight;
                d4 = -(this.layout.viewportHeight - d7);
            } else if (this.layout.contentHeight > this.layout.viewportHeight) {
                d2 = this.layout.cropY;
                double d8 = this.layout.cropY + this.layout.viewportHeight;
                d4 = this.layout.contentHeight - d8;
            }
            printWriter.print(" cropleft=\"" + this.format(d, 2) + "\"");
            printWriter.print(" croptop=\"" + this.format(d2 /= this.layout.contentHeight, 2) + "\"");
            printWriter.print(" cropright=\"" + this.format(d3, 2) + "\"");
            printWriter.print(" cropbottom=\"" + this.format(d4 /= this.layout.contentHeight, 2) + "\"");
        }
        printWriter.println(" />");
        printWriter.println("</v:shape>");
        printWriter.println("</w:pict>");
    }

    private String format(double d, int n) {
        this.numberFormat.setMaximumFractionDigits(n);
        this.numberFormat.setMinimumFractionDigits(n);
        return this.numberFormat.format(d);
    }
}

