/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.docx.Border;
import com.xmlmind.fo.converter.docx.Borders;
import com.xmlmind.fo.converter.docx.FontFace;
import com.xmlmind.fo.converter.docx.FontTable;
import com.xmlmind.fo.converter.docx.Wml;
import com.xmlmind.fo.font.Font;
import com.xmlmind.fo.font.FontCache;
import com.xmlmind.fo.objects.Fo;
import com.xmlmind.fo.properties.Color;
import com.xmlmind.fo.properties.Value;
import java.io.PrintWriter;

public final class RunProperties
implements Cloneable {
    public FontFace font;
    public double fontSize;
    public boolean bold;
    public boolean italic;
    public boolean underline;
    public boolean strikeThrough;
    public boolean smallCaps;
    public boolean subscript;
    public boolean superscript;
    public double baselineShift;
    public int alignmentBaseline;
    public Color fgColor;
    public Color bgColor;
    public Color ulColor;
    public Border border;

    public RunProperties() {
    }

    public RunProperties(Context context, FontTable fontTable) {
        this();
        this.initialize(context, fontTable);
    }

    public void initialize(Context context, FontTable fontTable) {
        int n;
        int n2;
        Value[] valueArray = context.properties.values;
        Value[] valueArray2 = valueArray[104].list();
        this.font = fontTable.add(valueArray2[0].string());
        this.fontSize = valueArray[106].length();
        int n3 = valueArray[111].integer();
        if (n3 >= 700) {
            this.bold = true;
        }
        if ((n2 = valueArray[109].keyword()) == 92 || n2 == 139) {
            this.italic = true;
        }
        if ((n = valueArray[110].keyword()) == 184) {
            this.smallCaps = true;
        }
        this.underline = context.textDecoration.underline;
        this.strikeThrough = context.textDecoration.lineThrough;
        Value value = valueArray[14];
        if (value.type == 1) {
            switch (value.keyword()) {
                case 193: {
                    this.subscript = true;
                    break;
                }
                case 194: {
                    this.superscript = true;
                }
            }
        } else {
            this.baselineShift = value.length();
        }
        this.alignmentBaseline = valueArray[3].keyword();
        this.fgColor = valueArray[78].color();
        this.bgColor = context.background;
        this.ulColor = context.textDecoration.color;
        if (Fo.isInline(context.fo)) {
            Borders borders = new Borders(valueArray);
            if (borders.top.materialized() && borders.bottom.materialized() && borders.left.materialized() && borders.right.materialized()) {
                this.border = new Border(0);
                this.border.set(borders.top.style, borders.top.width, borders.top.color, borders.top.space);
            }
        }
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("<w:rPr>");
        if (this.font != null) {
            printWriter.print("<w:rFonts");
            printWriter.print(" w:ascii=\"" + this.font.name + "\"");
            printWriter.print(" w:hAnsi=\"" + this.font.name + "\"");
            printWriter.print(" />");
        }
        if (this.bold) {
            printWriter.print("<w:b />");
        }
        if (this.italic) {
            printWriter.print("<w:i />");
        }
        if (this.smallCaps) {
            printWriter.print("<w:smallCaps />");
        }
        if (this.strikeThrough) {
            printWriter.print("<w:strike />");
        }
        if (this.fgColor != null) {
            printWriter.print("<w:color");
            printWriter.print(" w:val=\"" + Wml.hexColorType(this.fgColor) + "\"");
            printWriter.print(" />");
        }
        if (this.baselineShift != 0.0) {
            printWriter.print("<w:position w:val=\"" + Math.round(2.0 * this.baselineShift) + "\" />");
        }
        if (this.fontSize > 0.0) {
            printWriter.print("<w:sz w:val=\"" + Math.round(2.0 * this.fontSize) + "\" />");
        }
        if (this.underline) {
            printWriter.print("<w:u");
            printWriter.print(" w:val=\"single\"");
            if (this.ulColor != null) {
                printWriter.print(" w:color=\"" + Wml.hexColorType(this.ulColor) + "\"");
            }
            printWriter.print(" />");
        }
        if (this.border != null) {
            this.border.print(printWriter);
        }
        if (this.bgColor != null) {
            printWriter.print("<w:shd");
            printWriter.print(" w:val=\"clear\"");
            printWriter.print(" w:fill=\"" + Wml.hexColorType(this.bgColor) + "\"");
            printWriter.print(" />");
        }
        if (this.subscript) {
            printWriter.print("<w:vertAlign w:val=\"subscript\" />");
        } else if (this.superscript) {
            printWriter.print("<w:vertAlign w:val=\"superscript\" />");
        }
        printWriter.println("</w:rPr>");
    }

    public Font getFont() {
        int n = -1;
        if (this.font.family != null) {
            if ("roman".equals(this.font.family)) {
                n = 1;
            } else if ("swiss".equals(this.font.family)) {
                n = 2;
            } else if ("modern".equals(this.font.family)) {
                n = 3;
            } else if ("decorative".equals(this.font.family)) {
                n = 4;
            } else if ("script".equals(this.font.family)) {
                n = 5;
            }
        }
        int n2 = 0;
        if (this.bold) {
            n2 |= 1;
        }
        if (this.italic) {
            n2 |= 2;
        }
        int n3 = (int)Math.ceil(this.fontSize);
        if (n < 0) {
            return FontCache.getFont(this.font.name, n2, n3);
        }
        return FontCache.getFont(n, n2, n3);
    }

    public RunProperties copy() {
        RunProperties runProperties = null;
        try {
            runProperties = (RunProperties)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return runProperties;
    }
}

