/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import com.xmlmind.fo.converter.docx.Borders;
import com.xmlmind.fo.objects.PageSequence;
import com.xmlmind.fo.objects.Region;
import com.xmlmind.fo.objects.SimplePageMaster;
import com.xmlmind.fo.properties.Value;
import java.io.PrintWriter;

public final class Section {
    public double pageWidth;
    public double pageHeight;
    public double marginTop;
    public double marginBottom;
    public double marginLeft;
    public double marginRight;
    public double headerOffset = 36.0;
    public double footerOffset = 36.0;
    public int columnCount;
    public double columnGap;
    public double columnWidth;
    public double contentWidth;
    public Borders borders;
    public boolean titlePage;
    public boolean mirrorMargins;
    public boolean isLast;
    public char numberFormat = (char)49;
    public int startPageNumber;
    public String oddHeaderId;
    public String evenHeaderId;
    public String firstHeaderId;
    public String oddFooterId;
    public String evenFooterId;
    public String firstFooterId;

    public Section() {
    }

    public Section(SimplePageMaster simplePageMaster, SimplePageMaster simplePageMaster2, SimplePageMaster simplePageMaster3, PageSequence pageSequence) {
        this();
        this.initialize(simplePageMaster, simplePageMaster2, simplePageMaster3, pageSequence);
    }

    public void initialize(SimplePageMaster simplePageMaster, SimplePageMaster simplePageMaster2, SimplePageMaster simplePageMaster3, PageSequence pageSequence) {
        Region region = simplePageMaster.regions[0];
        if (simplePageMaster.pageWidth.type == 4) {
            this.pageWidth = simplePageMaster.pageWidth.length();
        }
        if (simplePageMaster.pageHeight.type == 4) {
            this.pageHeight = simplePageMaster.pageHeight.length();
        }
        this.marginTop = Section.length(simplePageMaster.marginTop);
        this.marginBottom = Section.length(simplePageMaster.marginBottom);
        this.marginLeft = Section.length(simplePageMaster.marginLeft);
        this.marginRight = Section.length(simplePageMaster.marginRight);
        if (this.marginTop > 0.0) {
            this.headerOffset = this.marginTop;
        }
        if (this.marginBottom > 0.0) {
            this.footerOffset = this.marginBottom;
        }
        this.marginTop += Section.length(region.marginTop);
        this.marginBottom += Section.length(region.marginBottom);
        this.marginLeft += Section.length(region.marginLeft);
        this.marginRight += Section.length(region.marginRight);
        this.marginTop += Section.length(region.paddingTop);
        this.marginBottom += Section.length(region.paddingBottom);
        this.marginLeft += Section.length(region.paddingLeft);
        this.marginRight += Section.length(region.paddingRight);
        this.contentWidth = this.pageWidth - (this.marginLeft + this.marginRight);
        this.columnCount = region.columnCount;
        this.columnGap = Section.length(region.columnGap);
        this.columnWidth = this.contentWidth;
        if (this.columnCount > 1) {
            this.columnWidth -= (double)(this.columnCount - 1) * this.columnGap;
            this.columnWidth /= (double)this.columnCount;
        }
        if (simplePageMaster2 != null) {
            double d = Section.length(simplePageMaster2.marginLeft);
            double d2 = Section.length(simplePageMaster2.marginRight);
            region = simplePageMaster2.regions[0];
            d += Section.length(region.marginLeft);
            d2 += Section.length(region.marginRight);
            if ((d += Section.length(region.paddingLeft)) == this.marginRight && (d2 += Section.length(region.paddingRight)) == this.marginLeft) {
                this.mirrorMargins = true;
            }
        }
        this.borders = new Borders(region.properties);
        if (simplePageMaster3 != null) {
            this.titlePage = true;
        }
        if (pageSequence.initialPageNumber > 0) {
            this.startPageNumber = pageSequence.initialPageNumber;
        }
        int n = pageSequence.format.length();
        for (int i = 0; i < n; ++i) {
            char c = pageSequence.format.charAt(i);
            if (!Character.isLetterOrDigit(c)) continue;
            this.numberFormat = c;
            break;
        }
    }

    public void start(PrintWriter printWriter) {
    }

    public void end(PrintWriter printWriter) {
        if (!this.isLast) {
            printWriter.println("<w:p>");
            printWriter.println("<w:pPr>");
        }
        printWriter.println("<w:sectPr>");
        if (this.oddHeaderId != null) {
            printWriter.println("<w:headerReference w:type=\"default\" r:id=\"" + this.oddHeaderId + "\" />");
        }
        if (this.evenHeaderId != null) {
            printWriter.println("<w:headerReference w:type=\"even\" r:id=\"" + this.evenHeaderId + "\" />");
        }
        if (this.firstHeaderId != null) {
            printWriter.println("<w:headerReference w:type=\"first\" r:id=\"" + this.firstHeaderId + "\" />");
        }
        if (this.oddFooterId != null) {
            printWriter.println("<w:footerReference w:type=\"default\" r:id=\"" + this.oddFooterId + "\" />");
        }
        if (this.evenFooterId != null) {
            printWriter.println("<w:footerReference w:type=\"even\" r:id=\"" + this.evenFooterId + "\" />");
        }
        if (this.firstFooterId != null) {
            printWriter.println("<w:footerReference w:type=\"first\" r:id=\"" + this.firstFooterId + "\" />");
        }
        printWriter.print("<w:pgSz");
        printWriter.print(" w:w=\"" + Math.round(20.0 * this.pageWidth) + "\"");
        printWriter.print(" w:h=\"" + Math.round(20.0 * this.pageHeight) + "\"");
        if (this.pageWidth > this.pageHeight) {
            printWriter.print(" w:orient=\"landscape\"");
        }
        printWriter.println(" />");
        printWriter.print("<w:pgMar");
        printWriter.print(" w:top=\"" + Math.round(20.0 * this.marginTop) + "\"");
        printWriter.print(" w:bottom=\"" + Math.round(20.0 * this.marginBottom) + "\"");
        printWriter.print(" w:left=\"" + Math.round(20.0 * this.marginLeft) + "\"");
        printWriter.print(" w:right=\"" + Math.round(20.0 * this.marginRight) + "\"");
        printWriter.print(" w:header=\"" + Math.round(20.0 * this.headerOffset) + "\"");
        printWriter.print(" w:footer=\"" + Math.round(20.0 * this.footerOffset) + "\"");
        printWriter.print(" w:gutter=\"0\"");
        printWriter.println(" />");
        if (this.borders.materialized()) {
            printWriter.print("<w:pgBorders>");
            this.borders.print(printWriter);
            printWriter.println("</w:pgBorders>");
        }
        printWriter.print("<w:pgNumType");
        printWriter.print(" w:fmt=\"" + this.numberFormat() + "\"");
        if (this.startPageNumber > 0) {
            printWriter.print(" w:start=\"" + this.startPageNumber + "\"");
        }
        printWriter.println(" />");
        if (this.columnCount > 1) {
            printWriter.print("<w:cols");
            printWriter.print(" w:num=\"" + this.columnCount + "\"");
            printWriter.print(" w:space=\"" + Math.round(20.0 * this.columnGap) + "\"");
            printWriter.println(" />");
        }
        if (this.titlePage) {
            printWriter.println("<w:titlePg />");
        }
        printWriter.println("</w:sectPr>");
        if (!this.isLast) {
            printWriter.println("</w:pPr>");
            printWriter.println("</w:p>");
        }
    }

    private static double length(Value value) {
        double d = 0.0;
        if (value.type == 4) {
            d = value.length();
        }
        return d;
    }

    private String numberFormat() {
        String string;
        switch (this.numberFormat) {
            default: {
                string = "decimal";
                break;
            }
            case 'a': {
                string = "lowerLetter";
                break;
            }
            case 'A': {
                string = "upperLetter";
                break;
            }
            case 'i': {
                string = "lowerRoman";
                break;
            }
            case 'I': {
                string = "upperRoman";
            }
        }
        return string;
    }
}

