/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import com.xmlmind.fo.converter.docx.List;
import com.xmlmind.fo.converter.docx.Paragraph;
import com.xmlmind.fo.converter.docx.Relationships;
import com.xmlmind.fo.converter.docx.Table;
import com.xmlmind.fo.converter.docx.TableAndCaption;
import com.xmlmind.fo.util.Encoding;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;

public final class StaticContent {
    public static final int TYPE_HEADER = 0;
    public static final int TYPE_FOOTER = 1;
    private int type;
    private Vector content = new Vector();
    private Relationships relationships = new Relationships();

    public StaticContent(int n) {
        this.type = n;
    }

    public void add(Paragraph paragraph) {
        this.add(1, paragraph);
    }

    public void add(Table table) {
        this.add(2, table);
    }

    public void add(TableAndCaption tableAndCaption) {
        this.add(3, tableAndCaption);
    }

    public void add(List list) {
        this.add(4, list);
    }

    private void add(int n, Object object) {
        this.content.addElement(new Element(n, object));
    }

    public Relationships relationships() {
        return this.relationships;
    }

    public void write(String string, String string2) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        fileOutputStream.write(this.getBytes(string2));
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    public byte[] getBytes(String string) throws Exception {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("<?xml version=\"1.0\" encoding=\"" + Encoding.officialName(string) + "\"?>");
        this.print(printWriter);
        printWriter.flush();
        return stringWriter.toString().getBytes(string);
    }

    private void print(PrintWriter printWriter) {
        printWriter.println("<w:" + this.type() + " xmlns:w=\"" + "http://schemas.openxmlformats.org/wordprocessingml/2006/main" + "\"" + " xmlns:r=\"" + "http://schemas.openxmlformats.org/officeDocument/2006/relationships" + "\"" + " xmlns:a=\"" + "http://schemas.openxmlformats.org/drawingml/2006/main" + "\"" + " xmlns:p=\"" + "http://schemas.openxmlformats.org/drawingml/2006/picture" + "\"" + " xmlns:wp=\"" + "http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing" + "\"" + " xmlns:v=\"" + "urn:schemas-microsoft-com:vml" + "\"" + ">");
        int n = this.content.size();
        block6: for (int i = 0; i < n; ++i) {
            Element element = (Element)this.content.elementAt(i);
            switch (element.type) {
                case 1: {
                    Paragraph paragraph = (Paragraph)element.object;
                    paragraph.print(printWriter);
                    continue block6;
                }
                case 2: {
                    Table table = (Table)element.object;
                    table.print(printWriter);
                    continue block6;
                }
                case 3: {
                    TableAndCaption tableAndCaption = (TableAndCaption)element.object;
                    tableAndCaption.print(printWriter);
                    continue block6;
                }
                case 4: {
                    List list = (List)element.object;
                    list.print(printWriter);
                }
            }
        }
        printWriter.println("</w:" + this.type() + ">");
    }

    private String type() {
        String string;
        switch (this.type) {
            default: {
                string = "hdr";
                break;
            }
            case 1: {
                string = "ftr";
            }
        }
        return string;
    }

    private class Element {
        static final int TYPE_PARAGRAPH = 1;
        static final int TYPE_TABLE = 2;
        static final int TYPE_TABLE_AND_CAPTION = 3;
        static final int TYPE_LIST = 4;
        int type;
        Object object;

        Element(int n, Object object) {
            this.type = n;
            this.object = object;
        }
    }
}

