/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.docx.Borders;
import com.xmlmind.fo.converter.docx.List;
import com.xmlmind.fo.converter.docx.NumberingDefinitions;
import com.xmlmind.fo.converter.docx.Paragraph;
import com.xmlmind.fo.converter.docx.ParagraphProperties;
import com.xmlmind.fo.converter.docx.Table;
import com.xmlmind.fo.converter.docx.TableAndCaption;
import com.xmlmind.fo.converter.docx.Wml;
import com.xmlmind.fo.properties.Color;
import com.xmlmind.fo.properties.Value;
import java.io.PrintWriter;
import java.util.Vector;

public final class TableCell
implements Cloneable {
    public static final int ALIGNMENT_TOP = 0;
    public static final int ALIGNMENT_CENTER = 1;
    public static final int ALIGNMENT_BOTTOM = 2;
    public static final int MERGE_NONE = 0;
    public static final int MERGE_START = 1;
    public static final int MERGE_CONTINUE = 2;
    public int colNumber;
    public int colSpan;
    public int rowSpan;
    public double width;
    public boolean relativeWidth;
    public boolean startsRow;
    public boolean endsRow;
    public Borders borders;
    public double marginTop;
    public double marginBottom;
    public double marginLeft;
    public double marginRight;
    public Color background;
    public int alignment;
    public boolean requiresLayout;
    public boolean isInvisible;
    public int hMerge = 0;
    public int vMerge = 0;
    private Vector content = new Vector();

    public TableCell(int n) {
        this.colNumber = n;
        this.colSpan = 1;
        this.rowSpan = 1;
        this.borders = new Borders();
        this.alignment = 0;
    }

    public TableCell(Context context) {
        this.initialize(context);
    }

    public void initialize(Context context) {
        Value[] valueArray = context.properties.values;
        this.colNumber = TableCell.number(valueArray[82]);
        this.colSpan = TableCell.number(valueArray[187]);
        this.rowSpan = TableCell.number(valueArray[188]);
        if (valueArray[279].keyword() == 209) {
            this.startsRow = true;
        }
        if (valueArray[98].keyword() == 209) {
            this.endsRow = true;
        }
        Value value = valueArray[308];
        switch (value.type) {
            case 4: {
                this.width = value.length();
                break;
            }
            case 13: {
                this.width = value.percentage();
                this.relativeWidth = true;
            }
        }
        this.borders = new Borders(valueArray);
        this.marginTop = this.borders.top.space;
        this.borders.top.space = 0.0;
        this.marginBottom = this.borders.bottom.space;
        this.borders.bottom.space = 0.0;
        this.marginLeft = this.borders.left.space;
        this.borders.left.space = 0.0;
        this.marginRight = this.borders.right.space;
        this.borders.right.space = 0.0;
        Value value2 = valueArray[8];
        if (value2.type == 24) {
            this.background = value2.color();
        }
        switch (valueArray[93].keyword()) {
            default: {
                this.alignment = 0;
                break;
            }
            case 31: {
                this.alignment = 1;
                break;
            }
            case 4: {
                this.alignment = 2;
            }
        }
    }

    private static int number(Value value) {
        int n = (int)Math.round(value.number());
        if (n < 1) {
            n = 1;
        }
        return n;
    }

    public void add(Paragraph paragraph) {
        this.add(0, paragraph);
    }

    public void add(Table table) {
        this.add(1, table);
    }

    public void add(TableAndCaption tableAndCaption) {
        this.add(2, tableAndCaption);
    }

    public void add(List list) {
        this.add(3, list);
    }

    private void add(int n, Object object) {
        this.content.addElement(new Element(n, object));
    }

    public void keepWithNext() {
        if (this.isEmpty()) {
            Paragraph paragraph = Paragraph.empty();
            paragraph.properties.keepWithNext = true;
            this.add(paragraph);
            return;
        }
        Element element = (Element)this.content.elementAt(0);
        switch (element.type) {
            case 0: {
                Paragraph paragraph = (Paragraph)element.object;
                if (paragraph.properties == null) {
                    paragraph.properties = new ParagraphProperties();
                }
                paragraph.properties.keepWithNext = true;
            }
        }
    }

    public void breakBefore(int n) {
        if (this.isEmpty()) {
            Paragraph paragraph = Paragraph.empty();
            paragraph.properties.breakBefore = n;
            this.add(paragraph);
            return;
        }
        Element element = (Element)this.content.elementAt(0);
        switch (element.type) {
            case 0: {
                Paragraph paragraph = (Paragraph)element.object;
                if (paragraph.properties == null) {
                    paragraph.properties = new ParagraphProperties();
                }
                paragraph.properties.breakBefore = n;
            }
        }
    }

    public boolean isEmpty() {
        return this.content.size() == 0;
    }

    public boolean hasMargin() {
        return this.marginTop > 0.0 || this.marginBottom > 0.0 || this.marginLeft > 0.0 || this.marginRight > 0.0;
    }

    public void layout(double d, NumberingDefinitions numberingDefinitions) throws Exception {
        d -= this.marginLeft + this.marginRight;
        int n = this.content.size();
        block6: for (int i = 0; i < n; ++i) {
            Element element = (Element)this.content.elementAt(i);
            switch (element.type) {
                case 0: {
                    Paragraph paragraph = (Paragraph)element.object;
                    if (!paragraph.requiresLayout()) continue block6;
                    paragraph.layout(d);
                    continue block6;
                }
                case 1: {
                    Table table = (Table)element.object;
                    table.layout(d, numberingDefinitions);
                    continue block6;
                }
                case 2: {
                    TableAndCaption tableAndCaption = (TableAndCaption)element.object;
                    tableAndCaption.layout(d, numberingDefinitions);
                    continue block6;
                }
                case 3: {
                    List list = (List)element.object;
                    list.layout(d, numberingDefinitions);
                }
            }
        }
    }

    public void print(PrintWriter printWriter) {
        printWriter.println("<w:tc>");
        printWriter.print("<w:tcPr>");
        if (this.hMerge != 0) {
            printWriter.print("<w:hMerge w:val=\"" + TableCell.merge(this.hMerge) + "\" />");
        }
        if (this.vMerge != 0) {
            printWriter.print("<w:vMerge w:val=\"" + TableCell.merge(this.vMerge) + "\" />");
        }
        if (this.borders != null && this.borders.materialized()) {
            printWriter.print("<w:tcBorders>");
            this.borders.print(printWriter);
            printWriter.print("</w:tcBorders>");
        }
        if (this.background != null) {
            printWriter.print("<w:shd");
            printWriter.print(" w:val=\"clear\"");
            printWriter.print(" w:fill=\"" + Wml.hexColorType(this.background) + "\"");
            printWriter.print(" />");
        }
        if (this.hasMargin()) {
            printWriter.print("<w:tcMar>");
            if (this.marginTop > 0.0) {
                printWriter.print(TableCell.margin("top", this.marginTop));
            }
            if (this.marginLeft > 0.0) {
                printWriter.print(TableCell.margin("left", this.marginLeft));
            }
            if (this.marginBottom > 0.0) {
                printWriter.print(TableCell.margin("bottom", this.marginBottom));
            }
            if (this.marginRight > 0.0) {
                printWriter.print(TableCell.margin("right", this.marginRight));
            }
            printWriter.print("</w:tcMar>");
        }
        printWriter.print("<w:vAlign w:val=\"" + this.alignment() + "\" />");
        printWriter.println("</w:tcPr>");
        if (this.isEmpty()) {
            Paragraph.EMPTY.print(printWriter);
        } else {
            int n = this.content.size();
            block10: for (int i = 0; i < n; ++i) {
                Element element = (Element)this.content.elementAt(i);
                switch (element.type) {
                    case 0: {
                        Paragraph paragraph = (Paragraph)element.object;
                        paragraph.print(printWriter);
                        continue block10;
                    }
                    case 1: {
                        Table table = (Table)element.object;
                        table.print(printWriter);
                        continue block10;
                    }
                    case 2: {
                        TableAndCaption tableAndCaption = (TableAndCaption)element.object;
                        tableAndCaption.print(printWriter);
                        continue block10;
                    }
                    case 3: {
                        List list = (List)element.object;
                        list.print(printWriter);
                    }
                }
            }
            Element element = (Element)this.content.lastElement();
            switch (element.type) {
                case 1: {
                    Paragraph.EMPTY.print(printWriter);
                    break;
                }
                case 2: {
                    TableAndCaption tableAndCaption = (TableAndCaption)element.object;
                    if (tableAndCaption.caption != null && tableAndCaption.caption.side != 0) break;
                    Paragraph.EMPTY.print(printWriter);
                }
            }
        }
        printWriter.println("</w:tc>");
    }

    private static String merge(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "restart";
                break;
            }
            case 2: {
                string = "continue";
            }
        }
        return string;
    }

    private static String margin(String string, double d) {
        return "<w:" + string + " w:w=\"" + Math.round(20.0 * d) + "\" w:type=\"dxa\" />";
    }

    private String alignment() {
        String string;
        switch (this.alignment) {
            default: {
                string = "top";
                break;
            }
            case 1: {
                string = "center";
                break;
            }
            case 2: {
                string = "bottom";
            }
        }
        return string;
    }

    public double minWidth() {
        double d = 0.0;
        int n = this.content.size();
        block6: for (int i = 0; i < n; ++i) {
            Element element = (Element)this.content.elementAt(i);
            switch (element.type) {
                case 0: {
                    Paragraph paragraph = (Paragraph)element.object;
                    double d2 = paragraph.minWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                    continue block6;
                }
                case 1: {
                    Table table = (Table)element.object;
                    double d2 = table.minWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                    continue block6;
                }
                case 2: {
                    TableAndCaption tableAndCaption = (TableAndCaption)element.object;
                    double d2 = tableAndCaption.minWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                    continue block6;
                }
                case 3: {
                    List list = (List)element.object;
                    double d2 = list.minWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                }
            }
        }
        d += this.marginLeft + this.marginRight;
        d += 1.5;
        if (!this.relativeWidth && this.width > d) {
            d = this.width;
        }
        return d;
    }

    public double maxWidth() {
        double d = 0.0;
        int n = this.content.size();
        block6: for (int i = 0; i < n; ++i) {
            Element element = (Element)this.content.elementAt(i);
            switch (element.type) {
                case 0: {
                    Paragraph paragraph = (Paragraph)element.object;
                    double d2 = paragraph.maxWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                    continue block6;
                }
                case 1: {
                    Table table = (Table)element.object;
                    double d2 = table.maxWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                    continue block6;
                }
                case 2: {
                    TableAndCaption tableAndCaption = (TableAndCaption)element.object;
                    double d2 = tableAndCaption.maxWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                    continue block6;
                }
                case 3: {
                    List list = (List)element.object;
                    double d2 = list.maxWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                }
            }
        }
        d += this.marginLeft + this.marginRight;
        d += 1.5;
        if (!this.relativeWidth && this.width > d) {
            d = this.width;
        }
        return d;
    }

    public TableCell copy() {
        TableCell tableCell = null;
        try {
            tableCell = (TableCell)this.clone();
            if (this.borders != null) {
                tableCell.borders = this.borders.copy();
            }
            tableCell.content = new Vector();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return tableCell;
    }

    private class Element {
        static final int TYPE_PARAGRAPH = 0;
        static final int TYPE_TABLE = 1;
        static final int TYPE_TABLE_AND_CAPTION = 2;
        static final int TYPE_LIST = 3;
        int type;
        Object object;

        Element(int n, Object object) {
            this.type = n;
            this.object = object;
        }
    }
}

