/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.docx.Borders;
import com.xmlmind.fo.converter.docx.TableCell;
import com.xmlmind.fo.converter.docx.TableRow;
import com.xmlmind.fo.properties.Color;
import com.xmlmind.fo.properties.Value;
import java.io.PrintWriter;
import java.util.Vector;

public class TableGroup {
    public static final int TYPE_HEADER = 0;
    public static final int TYPE_BODY = 1;
    public static final int TYPE_FOOTER = 2;
    public int type;
    public Borders borders;
    public Color background;
    public TableRow[] rows;
    public Vector list = new Vector();

    public TableGroup() {
        this(1);
    }

    public TableGroup(int n) {
        this.type = n;
    }

    public TableGroup(Context context) {
        this(1, context);
    }

    public TableGroup(int n, Context context) {
        this(n);
        this.initialize(context);
    }

    public void initialize(Context context) {
        Value[] valueArray = context.properties.values;
        this.borders = new Borders(valueArray);
        Value value = valueArray[8];
        if (value.type == 24) {
            this.background = value.color();
        }
    }

    public void add(TableRow tableRow) {
        this.list.addElement(tableRow);
        if (tableRow.background == null) {
            tableRow.background = this.background;
        }
        if (this.type == 0) {
            tableRow.isHeaderRow = true;
        }
    }

    public int size() {
        return this.list.size();
    }

    public TableRow get(int n) {
        return (TableRow)this.list.elementAt(n);
    }

    public void normalize(int n) {
        int n2;
        Object object;
        int n3;
        int n4 = 0;
        int n5 = this.size();
        for (n3 = 0; n3 < n5; ++n3) {
            object = this.get(n3);
            n2 = n3 + ((TableRow)object).span() - 1;
            if (n2 <= n4) continue;
            n4 = n2;
        }
        for (n3 = this.size(); n3 <= n4; ++n3) {
            this.add(new TableRow());
        }
        this.rows = new TableRow[this.size()];
        for (n3 = 0; n3 < this.rows.length; ++n3) {
            this.rows[n3] = this.get(n3);
            this.rows[n3].normalize(n);
        }
        for (n3 = 0; n3 < this.rows.length; ++n3) {
            for (n2 = 0; n2 < n; ++n2) {
                object = this.rows[n3].cells[n2];
                if (((TableCell)object).rowSpan <= 1) continue;
                n4 = n3 + ((TableCell)object).rowSpan - 1;
                for (int i = n3 + 1; i <= n4; ++i) {
                    TableCell tableCell = ((TableCell)object).copy();
                    tableCell.rowSpan = 1;
                    tableCell.vMerge = 2;
                    tableCell.borders.top.style = 75;
                    tableCell.borders.top.width = 0.0;
                    tableCell.marginTop = 0.0;
                    if (i < n4) {
                        tableCell.borders.bottom.style = 75;
                        tableCell.borders.bottom.width = 0.0;
                        tableCell.marginBottom = 0.0;
                    }
                    this.rows[i].cells[n2] = tableCell;
                }
                ((TableCell)object).vMerge = 1;
                ((TableCell)object).borders.bottom.style = 75;
                ((TableCell)object).borders.bottom.width = 0.0;
                ((TableCell)object).marginBottom = 0.0;
            }
        }
    }

    public void print(PrintWriter printWriter) {
        for (int i = 0; i < this.rows.length; ++i) {
            this.rows[i].print(printWriter);
        }
    }
}

