/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.docx.Bookmark;
import com.xmlmind.fo.converter.docx.Borders;
import com.xmlmind.fo.converter.docx.TableCell;
import com.xmlmind.fo.converter.docx.Wml;
import com.xmlmind.fo.properties.Color;
import com.xmlmind.fo.properties.Value;
import java.io.PrintWriter;
import java.util.Vector;

public final class TableRow {
    public int breakBefore;
    public int breakAfter;
    public boolean keepTogether;
    public boolean keepWithNext;
    public boolean keepWithPrevious;
    public double height;
    public Borders borders;
    public Color background;
    public boolean requiresLayout;
    public boolean isHeaderRow;
    public Bookmark[] bookmarks;
    public TableCell[] cells;
    private Vector list = new Vector();

    public TableRow() {
        this.breakBefore = 0;
        this.breakAfter = 0;
        this.borders = new Borders();
    }

    public TableRow(Context context) {
        this.initialize(context);
    }

    public void initialize(Context context) {
        Value[] valueArray = context.properties.values;
        this.breakBefore = context.properties.breakBefore();
        this.breakAfter = context.properties.breakAfter();
        this.keepTogether = TableRow.keep(valueArray[137]);
        this.keepWithNext = TableRow.keep(valueArray[141]);
        this.keepWithPrevious = TableRow.keep(valueArray[145]);
        Value value = valueArray[118];
        if (value.type == 4) {
            this.height = value.length();
        }
        this.borders = new Borders(valueArray);
        Value value2 = valueArray[8];
        if (value2.type == 24) {
            this.background = value2.color();
        }
    }

    private static boolean keep(Value value) {
        boolean bl = false;
        switch (value.type) {
            case 1: {
                if (value.keyword() != 8) break;
                bl = true;
                break;
            }
            case 2: {
                if (value.integer() <= 0) break;
                bl = true;
            }
        }
        return bl;
    }

    public void add(TableCell tableCell) {
        this.list.addElement(tableCell);
    }

    public int size() {
        return this.list.size();
    }

    public TableCell get(int n) {
        return (TableCell)this.list.elementAt(n);
    }

    public int span() {
        int n = 1;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            TableCell tableCell = this.get(i);
            if (tableCell.rowSpan <= n) continue;
            n = tableCell.rowSpan;
        }
        return n;
    }

    public void normalize(int n) {
        int n2;
        this.cells = new TableCell[n];
        int n3 = this.size();
        for (n2 = 0; n2 < n3; ++n2) {
            TableCell tableCell = this.get(n2);
            int n4 = tableCell.colNumber - 1;
            this.cells[n4] = tableCell;
            if (tableCell.colSpan <= 1) continue;
            int n5 = n4 + tableCell.colSpan - 1;
            for (int i = n4 + 1; i <= n5; ++i) {
                this.cells[i] = tableCell.copy();
                this.cells[i].colNumber = i + 1;
                this.cells[i].colSpan = 1;
                this.cells[i].hMerge = 2;
                this.cells[i].borders.left.style = 75;
                this.cells[i].borders.left.width = 0.0;
                this.cells[i].marginLeft = 0.0;
                if (i >= n5) continue;
                this.cells[i].borders.right.style = 75;
                this.cells[i].borders.right.width = 0.0;
                this.cells[i].marginRight = 0.0;
            }
            tableCell.hMerge = 1;
            tableCell.borders.right.style = 75;
            tableCell.borders.right.width = 0.0;
            tableCell.marginRight = 0.0;
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (this.cells[n2] != null) continue;
            this.cells[n2] = new TableCell(n2 + 1);
            this.cells[n2].isInvisible = true;
        }
    }

    public void print(PrintWriter printWriter) {
        int n;
        if (this.bookmarks != null) {
            for (n = 0; n < this.bookmarks.length; ++n) {
                this.bookmarks[n].start(printWriter);
            }
        }
        printWriter.println("<w:tr>");
        printWriter.print("<w:tblPrEx>");
        if (this.borders != null && this.borders.materialized()) {
            printWriter.print("<w:tblBorders>");
            this.borders.print(printWriter);
            printWriter.print("</w:tblBorders>");
        }
        if (this.background != null) {
            printWriter.print("<w:shd");
            printWriter.print(" w:val=\"clear\"");
            printWriter.print(" w:fill=\"" + Wml.hexColorType(this.background) + "\"");
            printWriter.print(" />");
        }
        printWriter.println("</w:tblPrEx>");
        printWriter.print("<w:trPr>");
        if (this.keepTogether) {
            printWriter.print("<w:cantSplit />");
        }
        if (this.height > 0.0) {
            printWriter.print("<w:trHeight");
            printWriter.print(" w:val=\"" + Math.round(20.0 * this.height) + "\"");
            printWriter.print(" w:hRule=\"atLeast\"");
            printWriter.print(" />");
        }
        if (this.isHeaderRow) {
            printWriter.print("<w:tblHeader />");
        }
        printWriter.println("</w:trPr>");
        for (n = 0; n < this.cells.length; ++n) {
            this.cells[n].print(printWriter);
        }
        printWriter.println("</w:tr>");
        if (this.bookmarks != null) {
            for (n = this.bookmarks.length - 1; n >= 0; --n) {
                this.bookmarks[n].end(printWriter);
            }
        }
    }
}

