/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.docx;

import com.xmlmind.fo.converter.docx.ColorTable;
import com.xmlmind.fo.properties.Color;

public final class Wml {
    public static final String NS_WORDPROCESSINGML = "http://schemas.openxmlformats.org/wordprocessingml/2006/main";
    public static final String NS_DRAWINGML = "http://schemas.openxmlformats.org/drawingml/2006/main";
    public static final String NS_DRAWINGML_PICTURE = "http://schemas.openxmlformats.org/drawingml/2006/picture";
    public static final String NS_DRAWINGML_WPDRAWING = "http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing";
    public static final String NS_RELATIONSHIPS = "http://schemas.openxmlformats.org/officeDocument/2006/relationships";
    public static final String NS_CUSTOMXML = "http://schemas.openxmlformats.org/officeDocument/2006/customXml";
    public static final String NS_VML = "urn:schemas-microsoft-com:vml";

    public static String ucharHexNumberType(int n) {
        return Wml.hexBinary(n, 1);
    }

    public static int rgb(Color color) {
        if (color.name != null) {
            color = ColorTable.get(color.name);
        }
        return (color.red << 16) + (color.green << 8) + color.blue;
    }

    public static String hexColorType(Color color) {
        return Wml.hexBinary(Wml.rgb(color), 3);
    }

    public static String hexBinary(int n, int n2) {
        return Integer.toHexString(n + (1 << 8 * n2)).substring(1);
    }

    public static String escape(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    if (i > 1 && string.charAt(i - 1) == ']' && string.charAt(i - 2) == ']') {
                        stringBuffer.append("&gt;");
                        continue block6;
                    }
                    stringBuffer.append(c);
                    continue block6;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

