/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.odt.FontTable;
import com.xmlmind.fo.converter.odt.GraphicStyle;
import com.xmlmind.fo.converter.odt.ListStyle;
import com.xmlmind.fo.converter.odt.ParagraphStyle;
import com.xmlmind.fo.converter.odt.TableCellStyle;
import com.xmlmind.fo.converter.odt.TableColumnStyle;
import com.xmlmind.fo.converter.odt.TableRowStyle;
import com.xmlmind.fo.converter.odt.TableStyle;
import com.xmlmind.fo.converter.odt.TextStyle;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;

public class AutomaticStyles {
    private FontTable fontTable;
    private Hashtable paragraphStyles = new Hashtable();
    private Vector paragraphStyleList = new Vector();
    private Hashtable textStyles = new Hashtable();
    private Vector textStyleList = new Vector();
    private Hashtable graphicStyles = new Hashtable();
    private Vector graphicStyleList = new Vector();
    private Hashtable listStyles = new Hashtable();
    private Vector listStyleList = new Vector();
    private Hashtable tableStyles = new Hashtable();
    private Vector tableStyleList = new Vector();
    private Hashtable tableColumnStyles = new Hashtable();
    private Vector tableColumnStyleList = new Vector();
    private Hashtable tableRowStyles = new Hashtable();
    private Vector tableRowStyleList = new Vector();
    private Hashtable tableCellStyles = new Hashtable();
    private Vector tableCellStyleList = new Vector();

    public AutomaticStyles(FontTable fontTable) {
        this.fontTable = fontTable;
    }

    public ParagraphStyle add(ParagraphStyle paragraphStyle) {
        ParagraphStyle paragraphStyle2 = (ParagraphStyle)this.paragraphStyles.get(paragraphStyle);
        if (paragraphStyle2 == null) {
            paragraphStyle.name = "P" + this.paragraphStyles.size();
            this.paragraphStyles.put(paragraphStyle, paragraphStyle);
            this.paragraphStyleList.addElement(paragraphStyle);
        } else {
            paragraphStyle = paragraphStyle2;
        }
        return paragraphStyle;
    }

    public TextStyle add(TextStyle textStyle) {
        TextStyle textStyle2 = (TextStyle)this.textStyles.get(textStyle);
        if (textStyle2 == null) {
            textStyle.font = this.fontTable.add(textStyle.font);
            textStyle.name = "T" + this.textStyles.size();
            this.textStyles.put(textStyle, textStyle);
            this.textStyleList.addElement(textStyle);
        } else {
            textStyle = textStyle2;
        }
        return textStyle;
    }

    public GraphicStyle add(GraphicStyle graphicStyle) {
        GraphicStyle graphicStyle2 = (GraphicStyle)this.graphicStyles.get(graphicStyle);
        if (graphicStyle2 == null) {
            graphicStyle.name = "G" + this.graphicStyles.size();
            this.graphicStyles.put(graphicStyle, graphicStyle);
            this.graphicStyleList.addElement(graphicStyle);
        } else {
            graphicStyle = graphicStyle2;
        }
        return graphicStyle;
    }

    public ListStyle add(ListStyle listStyle) {
        ListStyle listStyle2 = (ListStyle)this.listStyles.get(listStyle);
        if (listStyle2 == null) {
            listStyle.textStyle.font = this.fontTable.add(listStyle.textStyle.font);
            listStyle.name = "L" + this.listStyles.size();
            this.listStyles.put(listStyle, listStyle);
            this.listStyleList.addElement(listStyle);
        } else {
            if (listStyle.listLevel > listStyle2.listLevel) {
                listStyle2.listLevel = listStyle.listLevel;
            }
            listStyle = listStyle2;
        }
        return listStyle;
    }

    public TableStyle add(TableStyle tableStyle) {
        TableStyle tableStyle2 = (TableStyle)this.tableStyles.get(tableStyle);
        if (tableStyle2 == null) {
            tableStyle.name = "TB" + this.tableStyles.size();
            this.tableStyles.put(tableStyle, tableStyle);
            this.tableStyleList.addElement(tableStyle);
        } else {
            tableStyle = tableStyle2;
        }
        return tableStyle;
    }

    public TableColumnStyle add(TableColumnStyle tableColumnStyle) {
        TableColumnStyle tableColumnStyle2 = (TableColumnStyle)this.tableColumnStyles.get(tableColumnStyle);
        if (tableColumnStyle2 == null) {
            tableColumnStyle.name = "TC" + this.tableColumnStyles.size();
            this.tableColumnStyles.put(tableColumnStyle, tableColumnStyle);
            this.tableColumnStyleList.addElement(tableColumnStyle);
        } else {
            tableColumnStyle = tableColumnStyle2;
        }
        return tableColumnStyle;
    }

    public TableRowStyle add(TableRowStyle tableRowStyle) {
        TableRowStyle tableRowStyle2 = (TableRowStyle)this.tableRowStyles.get(tableRowStyle);
        if (tableRowStyle2 == null) {
            tableRowStyle.name = "TR" + this.tableRowStyles.size();
            this.tableRowStyles.put(tableRowStyle, tableRowStyle);
            this.tableRowStyleList.addElement(tableRowStyle);
        } else {
            tableRowStyle = tableRowStyle2;
        }
        return tableRowStyle;
    }

    public TableCellStyle add(TableCellStyle tableCellStyle) {
        TableCellStyle tableCellStyle2 = (TableCellStyle)this.tableCellStyles.get(tableCellStyle);
        if (tableCellStyle2 == null) {
            tableCellStyle.name = "TL" + this.tableCellStyles.size();
            this.tableCellStyles.put(tableCellStyle, tableCellStyle);
            this.tableCellStyleList.addElement(tableCellStyle);
        } else {
            tableCellStyle = tableCellStyle2;
        }
        return tableCellStyle;
    }

    public void print(PrintWriter printWriter) {
        Object object;
        int n;
        int n2 = this.paragraphStyleList.size();
        for (n = 0; n < n2; ++n) {
            object = (ParagraphStyle)this.paragraphStyleList.elementAt(n);
            ((ParagraphStyle)object).print(printWriter);
        }
        n2 = this.textStyleList.size();
        for (n = 0; n < n2; ++n) {
            object = (TextStyle)this.textStyleList.elementAt(n);
            ((TextStyle)object).print(printWriter);
        }
        n2 = this.graphicStyleList.size();
        for (n = 0; n < n2; ++n) {
            object = (GraphicStyle)this.graphicStyleList.elementAt(n);
            ((GraphicStyle)object).print(printWriter);
        }
        n2 = this.listStyleList.size();
        for (n = 0; n < n2; ++n) {
            object = (ListStyle)this.listStyleList.elementAt(n);
            ((ListStyle)object).print(printWriter);
        }
        n2 = this.tableStyleList.size();
        for (n = 0; n < n2; ++n) {
            object = (TableStyle)this.tableStyleList.elementAt(n);
            ((TableStyle)object).print(printWriter);
        }
        n2 = this.tableColumnStyleList.size();
        for (n = 0; n < n2; ++n) {
            object = (TableColumnStyle)this.tableColumnStyleList.elementAt(n);
            ((TableColumnStyle)object).print(printWriter);
        }
        n2 = this.tableRowStyleList.size();
        for (n = 0; n < n2; ++n) {
            object = (TableRowStyle)this.tableRowStyleList.elementAt(n);
            ((TableRowStyle)object).print(printWriter);
        }
        n2 = this.tableCellStyleList.size();
        for (n = 0; n < n2; ++n) {
            object = (TableCellStyle)this.tableCellStyleList.elementAt(n);
            ((TableCellStyle)object).print(printWriter);
        }
    }
}

