/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.odt.Odt;
import com.xmlmind.fo.converter.odt.Span;
import com.xmlmind.fo.converter.odt.TextStyle;
import com.xmlmind.fo.util.Encoder;
import java.io.PrintWriter;

public final class BookmarkReference {
    public static final int FORMAT_PAGE = 0;
    public static final int FORMAT_TEXT = 1;
    public String name;
    public int format;
    public TextStyle style;
    public String value;

    public BookmarkReference(String string, int n) {
        this(string, n, null);
    }

    public BookmarkReference(String string, int n, TextStyle textStyle) {
        this.name = string;
        this.format = n;
        this.style = textStyle;
    }

    public static BookmarkReference page(String string) {
        return BookmarkReference.page(string, null);
    }

    public static BookmarkReference page(String string, TextStyle textStyle) {
        BookmarkReference bookmarkReference = new BookmarkReference(string, 0, textStyle);
        bookmarkReference.value = "0";
        return bookmarkReference;
    }

    public void print(PrintWriter printWriter, Encoder encoder) {
        if (this.name == null || this.name.length() == 0) {
            return;
        }
        if (this.style != null) {
            Span.start(printWriter, this.style);
        }
        printWriter.print("<text:bookmark-ref");
        printWriter.print(" text:ref-name=\"" + Odt.escape(this.name, encoder) + "\"");
        printWriter.println(" text:reference-format=\"" + this.format() + "\"");
        printWriter.print(">");
        if (this.value != null) {
            printWriter.print(Odt.escape(this.value, encoder));
        }
        printWriter.println("</text:bookmark-ref");
        printWriter.print(">");
        if (this.style != null) {
            Span.end(printWriter);
        }
    }

    private String format() {
        if (this.format == 1) {
            return "text";
        }
        return "page";
    }
}

