/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.odt.Border;
import com.xmlmind.fo.converter.odt.Odt;
import com.xmlmind.fo.properties.Value;
import java.io.PrintWriter;

public final class Borders {
    private static final double BORDER_THIN = 1.0;
    private static final double BORDER_MEDIUM = 2.0;
    private static final double BORDER_THICK = 3.0;
    public Border top;
    public Border bottom;
    public Border left;
    public Border right;

    public Borders() {
        this.top = new Border();
        this.bottom = new Border();
        this.left = new Border();
        this.right = new Border();
    }

    private Borders(Border border, Border border2, Border border3, Border border4) {
        this.top = border;
        this.bottom = border2;
        this.left = border3;
        this.right = border4;
    }

    public Borders(Value[] valueArray) {
        this();
        this.initialize(valueArray);
    }

    public void initialize(Value[] valueArray) {
        int n;
        double d;
        int n2 = valueArray[66].keyword();
        if (n2 != 125) {
            d = Borders.width(valueArray[67]);
            n = Odt.rgb(valueArray[65].color());
            this.top.set(n2, n, d);
        }
        if ((n2 = valueArray[35].keyword()) != 125) {
            d = Borders.width(valueArray[36]);
            n = Odt.rgb(valueArray[34].color());
            this.bottom.set(n2, n, d);
        }
        if ((n2 = valueArray[47].keyword()) != 125) {
            d = Borders.width(valueArray[48]);
            n = Odt.rgb(valueArray[46].color());
            this.left.set(n2, n, d);
        }
        if ((n2 = valueArray[51].keyword()) != 125) {
            d = Borders.width(valueArray[52]);
            n = Odt.rgb(valueArray[50].color());
            this.right.set(n2, n, d);
        }
    }

    private static double width(Value value) {
        double d = 0.0;
        if (value.type == 1) {
            switch (value.keyword()) {
                case 202: {
                    d = 1.0;
                    break;
                }
                case 118: {
                    d = 2.0;
                    break;
                }
                case 203: {
                    d = 3.0;
                }
            }
        } else {
            d = value.length();
            if (d < 0.0) {
                d = 0.0;
            }
        }
        return d;
    }

    public boolean materialized() {
        return this.top.materialized() || this.bottom.materialized() || this.left.materialized() || this.right.materialized();
    }

    public void print(PrintWriter printWriter) {
        if (this.top.materialized()) {
            printWriter.println(" fo:border-top=\"" + this.top.toString() + "\"");
        }
        if (this.bottom.materialized()) {
            printWriter.println(" fo:border-bottom=\"" + this.bottom.toString() + "\"");
        }
        if (this.left.materialized()) {
            printWriter.println(" fo:border-left=\"" + this.left.toString() + "\"");
        }
        if (this.right.materialized()) {
            printWriter.println(" fo:border-right=\"" + this.right.toString() + "\"");
        }
    }

    public int hashCode() {
        int n = 0;
        n = Borders.shift(n) ^ this.top.hashCode();
        n = Borders.shift(n) ^ this.bottom.hashCode();
        n = Borders.shift(n) ^ this.left.hashCode();
        n = Borders.shift(n) ^ this.right.hashCode();
        return n;
    }

    private static int shift(int n) {
        return n << 1 | n >>> 31;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Borders)) {
            return false;
        }
        Borders borders = (Borders)object;
        return this.top.equals(borders.top) && this.bottom.equals(borders.bottom) && this.left.equals(borders.left) && this.right.equals(borders.right);
    }

    public Borders copy() {
        return new Borders(this.top.copy(), this.bottom.copy(), this.left.copy(), this.right.copy());
    }
}

