/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.odt.Borders;
import com.xmlmind.fo.converter.odt.Odt;
import java.io.PrintWriter;

public final class GraphicStyle {
    public static final int COLOR_TRANSPARENT = -1;
    public static final int ANCHOR_TYPE_PAGE = 0;
    public static final int ANCHOR_TYPE_FRAME = 1;
    public static final int ANCHOR_TYPE_PARAGRAPH = 2;
    public static final int ANCHOR_TYPE_CHAR = 3;
    public static final int ANCHOR_TYPE_AS_CHAR = 4;
    public static final int VP_TOP = 0;
    public static final int VP_MIDDLE = 1;
    public static final int VP_BOTTOM = 2;
    public static final int VP_FROM_TOP = 3;
    public static final int VP_BELOW = 4;
    public static final int VR_PAGE = 0;
    public static final int VR_PAGE_CONTENT = 1;
    public static final int VR_FRAME = 2;
    public static final int VR_FRAME_CONTENT = 3;
    public static final int VR_PARAGRAPH = 4;
    public static final int VR_PARAGRAPH_CONTENT = 5;
    public static final int VR_CHAR = 6;
    public static final int VR_LINE = 7;
    public static final int VR_BASELINE = 8;
    public static final int VR_TEXT = 9;
    public String name;
    public int anchorType;
    public int verticalPosition;
    public int verticalRelation;
    public double marginTop;
    public double marginBottom;
    public double marginLeft;
    public double marginRight;
    public Borders borders = new Borders();
    public double paddingTop;
    public double paddingBottom;
    public double paddingLeft;
    public double paddingRight;
    public int background = -1;
    public double clipTop;
    public double clipBottom;
    public double clipLeft;
    public double clipRight;

    public void print(PrintWriter printWriter) {
        printWriter.print("<style:style style:family=\"graphic\"");
        printWriter.println(" style:name=\"" + this.name + "\"");
        printWriter.println(" style:parent-style-name=\"Graphics\"");
        printWriter.println(">");
        printWriter.println("<style:graphic-properties");
        printWriter.println(" text:anchor-type=\"" + this.anchorType() + "\"");
        printWriter.println(" style:vertical-pos=\"" + this.verticalPosition() + "\"");
        printWriter.println(" style:vertical-rel=\"" + this.verticalRelation() + "\"");
        if (this.marginTop > 0.0) {
            printWriter.println(" fo:margin-top=\"" + Odt.length(this.marginTop, 1) + "\"");
        }
        if (this.marginBottom > 0.0) {
            printWriter.println(" fo:margin-bottom=\"" + Odt.length(this.marginBottom, 1) + "\"");
        }
        if (this.marginLeft != 0.0) {
            printWriter.println(" fo:margin-left=\"" + Odt.length(this.marginLeft, 1) + "\"");
        }
        if (this.marginRight != 0.0) {
            printWriter.println(" fo:margin-right=\"" + Odt.length(this.marginRight, 1) + "\"");
        }
        this.borders.print(printWriter);
        if (this.paddingTop > 0.0) {
            printWriter.println(" fo:padding-top=\"" + Odt.length(this.paddingTop, 1) + "\"");
        }
        if (this.paddingBottom > 0.0) {
            printWriter.println(" fo:padding-bottom=\"" + Odt.length(this.paddingBottom, 1) + "\"");
        }
        if (this.paddingLeft > 0.0) {
            printWriter.println(" fo:padding-left=\"" + Odt.length(this.paddingLeft, 1) + "\"");
        }
        if (this.paddingRight > 0.0) {
            printWriter.println(" fo:padding-right=\"" + Odt.length(this.paddingRight, 1) + "\"");
        }
        if (this.background != -1) {
            printWriter.println(" fo:background-color=\"" + Odt.color(this.background) + "\"");
        }
        if (this.clipTop != 0.0 || this.clipBottom != 0.0 || this.clipLeft != 0.0 || this.clipRight != 0.0) {
            printWriter.println(" fo:clip=\"" + this.clipping() + "\"");
        }
        printWriter.println("/>");
        printWriter.println("</style:style>");
    }

    private String anchorType() {
        String string = "page";
        switch (this.anchorType) {
            case 1: {
                string = "frame";
                break;
            }
            case 2: {
                string = "paragraph";
                break;
            }
            case 3: {
                string = "char";
                break;
            }
            case 4: {
                string = "as-char";
            }
        }
        return string;
    }

    private String verticalPosition() {
        String string = "top";
        switch (this.verticalPosition) {
            case 1: {
                string = "middle";
                break;
            }
            case 2: {
                string = "bottom";
                break;
            }
            case 3: {
                string = "from-top";
                break;
            }
            case 4: {
                string = "below";
            }
        }
        return string;
    }

    private String verticalRelation() {
        String string = "page";
        switch (this.verticalRelation) {
            case 1: {
                string = "page-content";
                break;
            }
            case 2: {
                string = "frame";
                break;
            }
            case 3: {
                string = "frame-content";
                break;
            }
            case 4: {
                string = "paragraph";
                break;
            }
            case 5: {
                string = "paragraph-content";
                break;
            }
            case 6: {
                string = "char";
                break;
            }
            case 7: {
                string = "line";
                break;
            }
            case 8: {
                string = "baseline";
                break;
            }
            case 9: {
                string = "text";
            }
        }
        return string;
    }

    private String clipping() {
        StringBuffer stringBuffer = new StringBuffer("rect(");
        stringBuffer.append(Odt.length(this.clipTop, 1));
        stringBuffer.append(" " + Odt.length(this.clipRight, 1));
        stringBuffer.append(" " + Odt.length(this.clipBottom, 1));
        stringBuffer.append(" " + Odt.length(this.clipLeft, 1));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 0;
        n = GraphicStyle.shift(n) ^ this.anchorType;
        n = GraphicStyle.shift(n) ^ this.verticalPosition;
        n = GraphicStyle.shift(n) ^ this.verticalRelation;
        n = GraphicStyle.shift(n) ^ GraphicStyle.hash(this.marginTop);
        n = GraphicStyle.shift(n) ^ GraphicStyle.hash(this.marginBottom);
        n = GraphicStyle.shift(n) ^ GraphicStyle.hash(this.marginLeft);
        n = GraphicStyle.shift(n) ^ GraphicStyle.hash(this.marginRight);
        n = GraphicStyle.shift(n) ^ this.borders.hashCode();
        n = GraphicStyle.shift(n) ^ GraphicStyle.hash(this.paddingTop);
        n = GraphicStyle.shift(n) ^ GraphicStyle.hash(this.paddingBottom);
        n = GraphicStyle.shift(n) ^ GraphicStyle.hash(this.paddingLeft);
        n = GraphicStyle.shift(n) ^ GraphicStyle.hash(this.paddingRight);
        n = GraphicStyle.shift(n) ^ this.background;
        n = GraphicStyle.shift(n) ^ GraphicStyle.hash(this.clipTop);
        n = GraphicStyle.shift(n) ^ GraphicStyle.hash(this.clipBottom);
        n = GraphicStyle.shift(n) ^ GraphicStyle.hash(this.clipLeft);
        n = GraphicStyle.shift(n) ^ GraphicStyle.hash(this.clipRight);
        return n >>> 16 | n << 16;
    }

    private static int hash(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)(l ^ l >>> 32);
    }

    private static int shift(int n) {
        return n << 1 | n >>> 31;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GraphicStyle)) {
            return false;
        }
        GraphicStyle graphicStyle = (GraphicStyle)object;
        return this.anchorType == graphicStyle.anchorType && this.verticalPosition == graphicStyle.verticalPosition && this.verticalRelation == graphicStyle.verticalRelation && this.marginTop == graphicStyle.marginTop && this.marginBottom == graphicStyle.marginBottom && this.marginLeft == graphicStyle.marginLeft && this.marginRight == graphicStyle.marginRight && this.borders.equals(graphicStyle.borders) && this.paddingTop == graphicStyle.paddingTop && this.paddingBottom == graphicStyle.paddingBottom && this.paddingLeft == graphicStyle.paddingLeft && this.paddingRight == graphicStyle.paddingRight && this.background == graphicStyle.background && this.clipTop == graphicStyle.clipTop && this.clipBottom == graphicStyle.clipBottom && this.clipLeft == graphicStyle.clipLeft && this.clipRight == graphicStyle.clipRight;
    }
}

