/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.odt.ListItem;
import com.xmlmind.fo.converter.odt.ListStyle;
import com.xmlmind.fo.converter.odt.StyleTable;
import com.xmlmind.fo.properties.LabelFormat;
import com.xmlmind.fo.properties.Value;
import com.xmlmind.fo.util.Encoder;
import java.io.PrintWriter;
import java.util.Vector;

public final class List {
    public static final int TYPE_LIST_BLOCK = 0;
    public static final int TYPE_PLAIN_PARAGRAPHS = 1;
    private int level;
    private LabelFormat labelFormat;
    private int type;
    private ListStyle style;
    private double marginLeft;
    private Vector items = new Vector();

    public List(int n, Context context) {
        this.level = n;
        this.initialize(context);
    }

    private void initialize(Context context) {
        Value[] valueArray = context.properties.values;
        Value value = valueArray[321];
        if (value != null && value.type == 30) {
            this.labelFormat = value.labelFormat();
        }
    }

    public void add(ListItem listItem) {
        this.items.addElement(listItem);
    }

    public int type() {
        return this.type;
    }

    public void layout(int n, double d, StyleTable styleTable) throws Exception {
        this.type = n;
        this.layout(d, styleTable);
    }

    public void layout(double d, StyleTable styleTable) throws Exception {
        ListItem listItem;
        int n;
        if (this.items.size() == 0) {
            return;
        }
        int n2 = this.items.size();
        for (n = 0; n < n2; ++n) {
            listItem = (ListItem)this.items.elementAt(n);
            listItem.layout(d, styleTable);
            if (this.marginLeft != 0.0) continue;
            this.marginLeft = listItem.labelStart;
        }
        if (this.type == 0) {
            listItem = (ListItem)this.items.elementAt(0);
            this.style = listItem.listStyle(this.labelFormat);
            if (this.style != null) {
                this.style.listLevel = this.level;
                this.style = styleTable.add(this.style);
            } else {
                this.type = 1;
            }
        }
        n2 = this.items.size();
        for (n = 0; n < n2; ++n) {
            listItem = (ListItem)this.items.elementAt(n);
            listItem.setup(this.type, this.style, styleTable);
        }
    }

    public void print(PrintWriter printWriter, Encoder encoder) {
        int n = this.items.size();
        if (n == 0) {
            return;
        }
        if (this.type == 0) {
            boolean bl = false;
            printWriter.print("<text:list");
            printWriter.print(" text:style-name=\"" + this.style.name + "\"");
            printWriter.println(">");
            int n2 = n;
            for (int i = 0; i < n2; ++i) {
                if (bl) {
                    printWriter.print("<text:list");
                    printWriter.print(" text:style-name=\"" + this.style.name + "\"");
                    printWriter.print(" text:continue-numbering=\"true\"");
                    printWriter.println(">");
                    bl = false;
                }
                ListItem listItem = (ListItem)this.items.elementAt(i);
                bl = listItem.print(printWriter, encoder);
            }
            if (!bl) {
                printWriter.println("</text:list>");
            }
        } else {
            int n3 = n;
            for (int i = 0; i < n3; ++i) {
                ListItem listItem = (ListItem)this.items.elementAt(i);
                listItem.print(printWriter, encoder);
            }
        }
    }

    public double minWidth() {
        double d = 0.0;
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            ListItem listItem = (ListItem)this.items.elementAt(i);
            double d2 = listItem.minWidth();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public double maxWidth() {
        double d = 0.0;
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            ListItem listItem = (ListItem)this.items.elementAt(i);
            double d2 = listItem.maxWidth();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public double marginLeft() {
        return this.marginLeft;
    }
}

