/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.odt.Odt;
import com.xmlmind.fo.converter.odt.ParagraphStyle;
import com.xmlmind.fo.converter.odt.TextStyle;
import java.io.PrintWriter;

public final class ListStyle {
    public static final int TYPE_NUMBER = 0;
    public static final int TYPE_BULLET = 1;
    public static final int FORMAT_DECIMAL = 0;
    public static final int FORMAT_LOWERCASE_LETTER = 1;
    public static final int FORMAT_UPPERCASE_LETTER = 2;
    public static final int FORMAT_LOWERCASE_ROMAN = 3;
    public static final int FORMAT_UPPERCASE_ROMAN = 4;
    public String name;
    public int listLevel = 1;
    public int labelType;
    public int numberFormat;
    public String numberPrefix = "";
    public String numberSuffix = "";
    public int startValue = 1;
    public char bulletCharacter;
    public int labelAlignment = 0;
    public double labelWidth;
    public double labelDistance;
    public TextStyle textStyle;

    public ListStyle(int n, int n2) {
        this(n, n2, null);
    }

    public ListStyle(int n, int n2, TextStyle textStyle) {
        this.labelType = 0;
        this.numberFormat = n;
        this.startValue = n2;
        this.textStyle = textStyle;
    }

    public ListStyle(char c) {
        this(c, null);
    }

    public ListStyle(char c, TextStyle textStyle) {
        this.labelType = 1;
        this.bulletCharacter = c;
        this.textStyle = textStyle;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("<text:list-style");
        printWriter.println(" style:name=\"" + this.name + "\">");
        for (int i = 1; i <= this.listLevel; ++i) {
            printWriter.println("<text:list-level-style-" + this.labelType());
            printWriter.println(" text:level=\"" + i + "\"");
            if (this.textStyle != null && this.textStyle.name != null) {
                printWriter.println(" text:style-name=\"" + this.textStyle.name + "\"");
            }
            if (this.labelType == 1) {
                printWriter.println(" text:bullet-char=\"&#" + Integer.toString(this.bulletCharacter) + ";\"");
            } else {
                printWriter.println(" style:num-format=\"" + this.numberFormat() + "\"");
                if (this.numberPrefix.length() > 0) {
                    printWriter.println(" style:num-prefix=\"" + this.numberPrefix + "\"");
                }
                if (this.numberSuffix.length() > 0) {
                    printWriter.println(" style:num-suffix=\"" + this.numberSuffix + "\"");
                }
                if (this.startValue != 1) {
                    printWriter.println(" text:start-value=\"" + this.startValue + "\"");
                }
            }
            printWriter.println(">");
            printWriter.println("<style:list-level-properties");
            printWriter.println(" fo:text-align=\"" + this.labelAlignment() + "\"");
            if (this.labelWidth > 0.0) {
                printWriter.println(" text:min-label-width=\"" + Odt.length(this.labelWidth, 1) + "\"");
            }
            if (this.labelDistance > 0.0) {
                printWriter.println(" text:min-label-distance=\"" + Odt.length(this.labelDistance, 1) + "\"");
            }
            printWriter.println("/>");
            printWriter.println("</text:list-level-style-" + this.labelType() + ">");
        }
        printWriter.println("</text:list-style>");
    }

    private String labelType() {
        if (this.labelType == 1) {
            return "bullet";
        }
        return "number";
    }

    private char numberFormat() {
        char c = '1';
        switch (this.numberFormat) {
            case 1: {
                c = 'a';
                break;
            }
            case 2: {
                c = 'A';
                break;
            }
            case 3: {
                c = 'i';
                break;
            }
            case 4: {
                c = 'I';
            }
        }
        return c;
    }

    private String labelAlignment() {
        return ParagraphStyle.toString(this.labelAlignment);
    }

    public int hashCode() {
        int n = 0;
        n = ListStyle.shift(n) ^ this.labelType;
        n = ListStyle.shift(n) ^ this.numberFormat;
        n = ListStyle.shift(n) ^ this.numberPrefix.hashCode();
        n = ListStyle.shift(n) ^ this.numberSuffix.hashCode();
        n = ListStyle.shift(n) ^ this.startValue;
        n = ListStyle.shift(n) ^ this.bulletCharacter;
        n = ListStyle.shift(n) ^ this.labelAlignment;
        n = ListStyle.shift(n) ^ ListStyle.hash(this.labelWidth);
        n = ListStyle.shift(n) ^ ListStyle.hash(this.labelDistance);
        if (this.textStyle != null) {
            n = ListStyle.shift(n) ^ this.textStyle.hashCode();
        }
        return n >>> 16 | n << 16;
    }

    private static int hash(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)(l ^ l >>> 32);
    }

    private static int shift(int n) {
        return n << 1 | n >>> 31;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ListStyle)) {
            return false;
        }
        ListStyle listStyle = (ListStyle)object;
        return this.labelType == listStyle.labelType && this.numberFormat == listStyle.numberFormat && this.numberPrefix.equals(listStyle.numberPrefix) && this.numberSuffix.equals(listStyle.numberSuffix) && this.startValue == listStyle.startValue && this.bulletCharacter == listStyle.bulletCharacter && this.labelAlignment == listStyle.labelAlignment && this.labelWidth == listStyle.labelWidth && this.labelDistance == listStyle.labelDistance && (this.textStyle == null && listStyle.textStyle == null || this.textStyle != null && this.textStyle.equals(listStyle.textStyle));
    }
}

