/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.odt.Borders;
import com.xmlmind.fo.converter.odt.Odt;
import com.xmlmind.fo.converter.odt.TabStops;
import com.xmlmind.fo.properties.Value;
import java.io.PrintWriter;

public final class ParagraphStyle
implements Cloneable {
    public static final int BREAK_AUTO = 0;
    public static final int BREAK_COLUMN = 1;
    public static final int BREAK_PAGE = 2;
    public static final int COLOR_TRANSPARENT = -1;
    public static final int ALIGN_START = 0;
    public static final int ALIGN_END = 1;
    public static final int ALIGN_LEFT = 2;
    public static final int ALIGN_RIGHT = 3;
    public static final int ALIGN_CENTER = 4;
    public static final int ALIGN_JUSTIFY = 5;
    public String name;
    public int breakBefore = 0;
    public boolean keepTogether;
    public boolean keepWithNext;
    public double marginTop;
    public double marginBottom;
    public double marginLeft;
    public double marginRight;
    public Borders borders;
    public double paddingTop;
    public double paddingBottom;
    public double paddingLeft;
    public double paddingRight;
    public int background = -1;
    public int textAlign = 0;
    public int textAlignLast = 0;
    public double textIndent;
    public double lineHeight;
    public int outlineLevel;
    public TabStops tabStops = new TabStops();
    public String listStyleName = "";
    public String masterPageName = "";

    public ParagraphStyle() {
        this.borders = new Borders();
    }

    public ParagraphStyle(Context context) {
        this.initialize(context);
    }

    public void initialize(Context context) {
        Context context2 = context.block();
        Value[] valueArray = context2.properties.values;
        switch (context2.breakBefore) {
            case 1: {
                this.breakBefore = 1;
                break;
            }
            case 2: {
                this.breakBefore = 2;
            }
        }
        this.keepTogether = ParagraphStyle.keep(valueArray[137]);
        this.keepWithNext = ParagraphStyle.keep(valueArray[141]);
        this.marginTop = context2.spaceBefore();
        this.marginLeft = ParagraphStyle.length(valueArray[277]);
        this.marginRight = ParagraphStyle.length(valueArray[97]);
        this.borders = new Borders(valueArray);
        this.paddingTop = ParagraphStyle.length(valueArray[208]);
        this.paddingBottom = ParagraphStyle.length(valueArray[199]);
        this.paddingLeft = ParagraphStyle.length(valueArray[203]);
        this.paddingRight = ParagraphStyle.length(valueArray[204]);
        this.marginLeft -= this.paddingLeft;
        if (this.borders.left.materialized()) {
            this.marginLeft -= this.borders.left.width;
        }
        this.marginRight -= this.paddingRight;
        if (this.borders.right.materialized()) {
            this.marginRight -= this.borders.right.width;
        }
        if (context2.background != null) {
            this.background = Odt.rgb(context2.background);
        }
        switch (valueArray[289].keyword()) {
            case 52: 
            case 165: {
                this.textAlign = 1;
                break;
            }
            case 31: {
                this.textAlign = 4;
                break;
            }
            case 93: {
                this.textAlign = 5;
                break;
            }
            default: {
                this.textAlign = 0;
            }
        }
        if (this.textAlign == 5) {
            switch (valueArray[290].keyword()) {
                case 31: {
                    this.textAlignLast = 4;
                    break;
                }
                case 93: {
                    this.textAlignLast = 5;
                    break;
                }
                default: {
                    this.textAlignLast = 0;
                }
            }
        }
        this.textIndent = ParagraphStyle.length(valueArray[294]);
        this.lineHeight = ParagraphStyle.length(context2.lineHeight);
        this.outlineLevel = ParagraphStyle.integer(valueArray[322], 0);
    }

    private static boolean keep(Value value) {
        boolean bl = false;
        switch (value.type) {
            case 1: {
                if (value.keyword() != 8) break;
                bl = true;
                break;
            }
            case 2: {
                if (value.integer() <= 0) break;
                bl = true;
            }
        }
        return bl;
    }

    private static double length(Value value) {
        double d = 0.0;
        if (value.type == 4) {
            d = value.length();
        }
        return d;
    }

    private static int integer(Value value, int n) {
        if (value != null && value.type == 2) {
            return value.integer();
        }
        return n;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("<style:style style:family=\"paragraph\"");
        printWriter.print(" style:name=\"" + this.name + "\"");
        if (this.listStyleName.length() > 0) {
            printWriter.print(" style:list-style-name=\"" + this.listStyleName + "\"");
        }
        if (this.masterPageName.length() > 0) {
            printWriter.print(" style:master-page-name=\"" + this.masterPageName + "\"");
        }
        if (this.outlineLevel >= 1 && this.outlineLevel <= 9) {
            printWriter.print(" style:default-outline-level=\"" + Integer.toString(this.outlineLevel) + "\"");
        }
        printWriter.println(">");
        printWriter.println("<style:paragraph-properties");
        if (this.breakBefore != 0) {
            printWriter.println(" fo:break-before=\"" + this.breakBefore() + "\"");
        }
        if (this.keepTogether) {
            printWriter.println(" fo:keep-together=\"always\"");
        }
        if (this.keepWithNext) {
            printWriter.println(" fo:keep-with-next=\"always\"");
        }
        if (this.marginTop > 0.0) {
            printWriter.println(" fo:margin-top=\"" + Odt.length(this.marginTop, 1) + "\"");
        }
        if (this.marginBottom > 0.0) {
            printWriter.println(" fo:margin-bottom=\"" + Odt.length(this.marginBottom, 1) + "\"");
        }
        if (this.marginLeft != 0.0) {
            printWriter.println(" fo:margin-left=\"" + Odt.length(this.marginLeft, 1) + "\"");
        }
        if (this.marginRight != 0.0) {
            printWriter.println(" fo:margin-right=\"" + Odt.length(this.marginRight, 1) + "\"");
        }
        this.borders.print(printWriter);
        if (this.paddingTop > 0.0) {
            printWriter.println(" fo:padding-top=\"" + Odt.length(this.paddingTop, 1) + "\"");
        }
        if (this.paddingBottom > 0.0) {
            printWriter.println(" fo:padding-bottom=\"" + Odt.length(this.paddingBottom, 1) + "\"");
        }
        if (this.paddingLeft > 0.0) {
            printWriter.println(" fo:padding-left=\"" + Odt.length(this.paddingLeft, 1) + "\"");
        }
        if (this.paddingRight > 0.0) {
            printWriter.println(" fo:padding-right=\"" + Odt.length(this.paddingRight, 1) + "\"");
        }
        if (this.background != -1) {
            printWriter.println(" fo:background-color=\"" + Odt.color(this.background) + "\"");
        }
        printWriter.println(" fo:text-align=\"" + this.textAlign() + "\"");
        if (this.textAlign == 5) {
            printWriter.println(" fo:text-align-last=\"" + this.textAlignLast() + "\"");
        }
        if (this.textIndent != 0.0) {
            printWriter.println(" fo:text-indent=\"" + Odt.length(this.textIndent, 1) + "\"");
        }
        if (this.lineHeight > 0.0) {
            printWriter.println(" style:line-height-at-least=\"" + Odt.length(this.lineHeight, 1) + "\"");
        }
        printWriter.println(">");
        if (this.tabStops.count() > 0) {
            this.tabStops.print(printWriter);
        }
        printWriter.println("</style:paragraph-properties>");
        printWriter.println("</style:style>");
    }

    private String breakBefore() {
        String string = "auto";
        switch (this.breakBefore) {
            case 1: {
                string = "column";
                break;
            }
            case 2: {
                string = "page";
            }
        }
        return string;
    }

    private String textAlign() {
        return ParagraphStyle.toString(this.textAlign);
    }

    public static String toString(int n) {
        String string = "start";
        switch (n) {
            case 1: {
                string = "end";
                break;
            }
            case 2: {
                string = "left";
                break;
            }
            case 3: {
                string = "right";
                break;
            }
            case 4: {
                string = "center";
                break;
            }
            case 5: {
                string = "justify";
            }
        }
        return string;
    }

    private String textAlignLast() {
        String string = "start";
        switch (this.textAlignLast) {
            case 4: {
                string = "center";
                break;
            }
            case 5: {
                string = "justify";
            }
        }
        return string;
    }

    public int hashCode() {
        int n = 0;
        n = ParagraphStyle.shift(n) ^ this.breakBefore;
        n = ParagraphStyle.shift(n) ^ ParagraphStyle.hash(this.keepTogether);
        n = ParagraphStyle.shift(n) ^ ParagraphStyle.hash(this.keepWithNext);
        n = ParagraphStyle.shift(n) ^ ParagraphStyle.hash(this.marginTop);
        n = ParagraphStyle.shift(n) ^ ParagraphStyle.hash(this.marginBottom);
        n = ParagraphStyle.shift(n) ^ ParagraphStyle.hash(this.marginLeft);
        n = ParagraphStyle.shift(n) ^ ParagraphStyle.hash(this.marginRight);
        n = ParagraphStyle.shift(n) ^ this.borders.hashCode();
        n = ParagraphStyle.shift(n) ^ ParagraphStyle.hash(this.paddingTop);
        n = ParagraphStyle.shift(n) ^ ParagraphStyle.hash(this.paddingBottom);
        n = ParagraphStyle.shift(n) ^ ParagraphStyle.hash(this.paddingLeft);
        n = ParagraphStyle.shift(n) ^ ParagraphStyle.hash(this.paddingRight);
        n = ParagraphStyle.shift(n) ^ this.background;
        n = ParagraphStyle.shift(n) ^ this.textAlign;
        n = ParagraphStyle.shift(n) ^ this.textAlignLast;
        n = ParagraphStyle.shift(n) ^ ParagraphStyle.hash(this.textIndent);
        n = ParagraphStyle.shift(n) ^ ParagraphStyle.hash(this.lineHeight);
        n = ParagraphStyle.shift(n) ^ this.outlineLevel;
        n = ParagraphStyle.shift(n) ^ this.tabStops.hashCode();
        n = ParagraphStyle.shift(n) ^ this.listStyleName.hashCode();
        n = ParagraphStyle.shift(n) ^ this.masterPageName.hashCode();
        return n >>> 16 | n << 16;
    }

    private static int hash(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)(l ^ l >>> 32);
    }

    private static int hash(boolean bl) {
        return bl ? 1 : 0;
    }

    private static int shift(int n) {
        return n << 1 | n >>> 31;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ParagraphStyle)) {
            return false;
        }
        ParagraphStyle paragraphStyle = (ParagraphStyle)object;
        return this.breakBefore == paragraphStyle.breakBefore && this.keepTogether == paragraphStyle.keepTogether && this.keepWithNext == paragraphStyle.keepWithNext && this.marginTop == paragraphStyle.marginTop && this.marginBottom == paragraphStyle.marginBottom && this.marginLeft == paragraphStyle.marginLeft && this.marginRight == paragraphStyle.marginRight && this.borders.equals(paragraphStyle.borders) && this.paddingTop == paragraphStyle.paddingTop && this.paddingBottom == paragraphStyle.paddingBottom && this.paddingLeft == paragraphStyle.paddingLeft && this.paddingRight == paragraphStyle.paddingRight && this.background == paragraphStyle.background && this.textAlign == paragraphStyle.textAlign && this.textAlignLast == paragraphStyle.textAlignLast && this.textIndent == paragraphStyle.textIndent && this.lineHeight == paragraphStyle.lineHeight && this.outlineLevel == paragraphStyle.outlineLevel && this.tabStops.equals(paragraphStyle.tabStops) && this.listStyleName.equals(paragraphStyle.listStyleName) && this.masterPageName.equals(paragraphStyle.masterPageName);
    }

    public ParagraphStyle copy() {
        ParagraphStyle paragraphStyle = null;
        try {
            paragraphStyle = (ParagraphStyle)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return paragraphStyle;
    }
}

