/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.odt.AutomaticStyles;
import com.xmlmind.fo.converter.odt.FontTable;
import com.xmlmind.fo.converter.odt.GraphicStyle;
import com.xmlmind.fo.converter.odt.ListStyle;
import com.xmlmind.fo.converter.odt.MasterPage;
import com.xmlmind.fo.converter.odt.PageLayout;
import com.xmlmind.fo.converter.odt.ParagraphStyle;
import com.xmlmind.fo.converter.odt.TableCellStyle;
import com.xmlmind.fo.converter.odt.TableColumnStyle;
import com.xmlmind.fo.converter.odt.TableRowStyle;
import com.xmlmind.fo.converter.odt.TableStyle;
import com.xmlmind.fo.converter.odt.TextStyle;
import com.xmlmind.fo.util.Encoder;
import com.xmlmind.fo.util.EncoderFactory;
import com.xmlmind.fo.util.Encoding;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;

public class StyleTable {
    public static final int CONTENT_STYLES = 0;
    public static final int LOCAL_STYLES = 1;
    private FontTable fontTable;
    private AutomaticStyles contentStyles;
    private AutomaticStyles localStyles;
    private AutomaticStyles automaticStyles;
    private Hashtable labelStyles = new Hashtable();
    private Vector labelStyleList = new Vector();
    private Vector pageLayouts = new Vector();
    private Vector masterPages = new Vector();

    public StyleTable(FontTable fontTable) {
        this.fontTable = fontTable;
        this.contentStyles = new AutomaticStyles(fontTable);
        this.localStyles = new AutomaticStyles(fontTable);
        this.select(0);
    }

    public void select(int n) {
        this.automaticStyles = n == 1 ? this.localStyles : this.contentStyles;
    }

    public ParagraphStyle add(ParagraphStyle paragraphStyle) {
        return this.automaticStyles.add(paragraphStyle);
    }

    public TextStyle add(TextStyle textStyle) {
        return this.automaticStyles.add(textStyle);
    }

    public GraphicStyle add(GraphicStyle graphicStyle) {
        return this.automaticStyles.add(graphicStyle);
    }

    public ListStyle add(ListStyle listStyle) {
        if (listStyle.textStyle != null) {
            listStyle.textStyle = this.addLabelStyle(listStyle.textStyle.copy());
        }
        return this.automaticStyles.add(listStyle);
    }

    private TextStyle addLabelStyle(TextStyle textStyle) {
        TextStyle textStyle2 = (TextStyle)this.labelStyles.get(textStyle);
        if (textStyle2 == null) {
            textStyle.font = this.fontTable.add(textStyle.font);
            textStyle.name = "List_Item_Label_" + this.labelStyles.size();
            this.labelStyles.put(textStyle, textStyle);
            this.labelStyleList.addElement(textStyle);
        } else {
            textStyle = textStyle2;
        }
        return textStyle;
    }

    public TableStyle add(TableStyle tableStyle) {
        return this.automaticStyles.add(tableStyle);
    }

    public TableColumnStyle add(TableColumnStyle tableColumnStyle) {
        return this.automaticStyles.add(tableColumnStyle);
    }

    public TableRowStyle add(TableRowStyle tableRowStyle) {
        return this.automaticStyles.add(tableRowStyle);
    }

    public TableCellStyle add(TableCellStyle tableCellStyle) {
        return this.automaticStyles.add(tableCellStyle);
    }

    public String add(PageLayout pageLayout) {
        pageLayout.name = "PL" + this.pageLayouts.size();
        this.pageLayouts.addElement(pageLayout);
        return pageLayout.name;
    }

    public String add(MasterPage masterPage) {
        masterPage.name = "MP" + this.masterPages.size();
        this.masterPages.addElement(masterPage);
        return masterPage.name;
    }

    public void write(String string, String string2) throws Exception {
        Object object;
        int n;
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(fileOutputStream), string2);
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(outputStreamWriter));
        printWriter.println("<?xml version=\"1.0\" encoding=\"" + Encoding.officialName(string2) + "\"?>");
        printWriter.print("<office:document-styles");
        printWriter.print(" xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\"");
        printWriter.print(" xmlns:style=\"urn:oasis:names:tc:opendocument:xmlns:style:1.0\"");
        printWriter.print(" xmlns:fo=\"urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0\"");
        printWriter.print(" xmlns:svg=\"urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0\"");
        printWriter.print(" xmlns:text=\"urn:oasis:names:tc:opendocument:xmlns:text:1.0\"");
        printWriter.print(" xmlns:draw=\"urn:oasis:names:tc:opendocument:xmlns:drawing:1.0\"");
        printWriter.print(" xmlns:table=\"urn:oasis:names:tc:opendocument:xmlns:table:1.0\"");
        printWriter.print(" xmlns:xlink=\"http://www.w3.org/1999/xlink\"");
        printWriter.print(" office:version=\"1.0\"");
        printWriter.println(">");
        this.fontTable.print(printWriter);
        printWriter.println("<office:styles>");
        int n2 = this.labelStyleList.size();
        for (n = 0; n < n2; ++n) {
            object = (TextStyle)this.labelStyleList.elementAt(n);
            ((TextStyle)object).print(printWriter);
        }
        printWriter.println("</office:styles>");
        printWriter.println("<office:automatic-styles>");
        this.localStyles.print(printWriter);
        n2 = this.pageLayouts.size();
        for (n = 0; n < n2; ++n) {
            object = (PageLayout)this.pageLayouts.elementAt(n);
            ((PageLayout)object).print(printWriter);
        }
        printWriter.println("</office:automatic-styles>");
        printWriter.println("<office:master-styles>");
        object = null;
        String string3 = Encoding.officialName(string2);
        if (!string3.startsWith("UTF")) {
            object = EncoderFactory.newEncoder(string3);
        }
        n2 = this.masterPages.size();
        for (n = 0; n < n2; ++n) {
            MasterPage masterPage = (MasterPage)this.masterPages.elementAt(n);
            masterPage.print(printWriter, (Encoder)object);
        }
        printWriter.println("</office:master-styles>");
        printWriter.println("</office:document-styles>");
        printWriter.flush();
        printWriter.close();
    }

    public void print(PrintWriter printWriter) {
        this.fontTable.print(printWriter);
        printWriter.println("<office:automatic-styles>");
        this.contentStyles.print(printWriter);
        printWriter.println("</office:automatic-styles>");
    }
}

