/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.odt.Odt;
import java.io.PrintWriter;

public final class TabStop {
    public static final double POSITION_UNSPECIFIED = Double.MAX_VALUE;
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_CENTER = 1;
    public static final int ALIGNMENT_RIGHT = 2;
    public static final int ALIGNMENT_CHAR = 3;
    public static final int LEADER_TYPE_NONE = 0;
    public static final int LEADER_TYPE_SINGLE = 1;
    public static final int LEADER_TYPE_DOUBLE = 2;
    public static final int LEADER_STYLE_NONE = 0;
    public static final int LEADER_STYLE_SOLID = 1;
    public static final int LEADER_STYLE_DOTTED = 2;
    public static final int LEADER_STYLE_DASHED = 3;
    public double position;
    public int alignment;
    public int leaderType;
    public int leaderStyle;
    public double leaderWidth;

    public TabStop() {
        this(Double.MAX_VALUE);
    }

    public TabStop(double d) {
        this.position = d;
    }

    public void print(PrintWriter printWriter) {
        printWriter.println("<style:tab-stop");
        printWriter.println(" style:position=\"" + Odt.length(this.position, 1) + "\"");
        printWriter.println(" style:type=\"" + this.type() + "\"");
        if (this.alignment == 3) {
            printWriter.println(" style:char=\".\"");
        }
        if (this.leaderType != 0 && this.leaderStyle != 0) {
            printWriter.println(" style:leader-type=\"" + this.leaderType() + "\"");
            printWriter.println(" style:leader-style=\"" + this.leaderStyle() + "\"");
            if (this.leaderWidth > 0.0) {
                printWriter.println(" style:leader-width=\"" + Odt.length(this.leaderWidth, 1) + "\"");
            }
        }
        printWriter.println("/>");
    }

    private String type() {
        String string = "left";
        switch (this.alignment) {
            case 1: {
                string = "center";
                break;
            }
            case 2: {
                string = "right";
                break;
            }
            case 3: {
                string = "char";
            }
        }
        return string;
    }

    private String leaderType() {
        String string = "none";
        switch (this.leaderType) {
            case 1: {
                string = "single";
                break;
            }
            case 2: {
                string = "double";
            }
        }
        return string;
    }

    private String leaderStyle() {
        String string = "none";
        switch (this.leaderStyle) {
            case 1: {
                string = "solid";
                break;
            }
            case 2: {
                string = "dotted";
                break;
            }
            case 3: {
                string = "dash";
            }
        }
        return string;
    }

    public int hashCode() {
        int n = 0;
        n = TabStop.shift(n) ^ TabStop.hash(this.position);
        n = TabStop.shift(n) ^ this.alignment;
        n = TabStop.shift(n) ^ this.leaderType;
        n = TabStop.shift(n) ^ this.leaderStyle;
        n = TabStop.shift(n) ^ TabStop.hash(this.leaderWidth);
        return n;
    }

    private static int hash(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)(l ^ l >>> 32);
    }

    private static int shift(int n) {
        return n << 1 | n >>> 31;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TabStop)) {
            return false;
        }
        TabStop tabStop = (TabStop)object;
        return this.position == tabStop.position && this.alignment == tabStop.alignment && this.leaderType == tabStop.leaderType && this.leaderStyle == tabStop.leaderStyle && this.leaderWidth == tabStop.leaderWidth;
    }
}

