/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.odt.List;
import com.xmlmind.fo.converter.odt.Odt;
import com.xmlmind.fo.converter.odt.Paragraph;
import com.xmlmind.fo.converter.odt.StyleTable;
import com.xmlmind.fo.converter.odt.Table;
import com.xmlmind.fo.converter.odt.TableAndCaption;
import com.xmlmind.fo.converter.odt.TableCellStyle;
import com.xmlmind.fo.properties.Color;
import com.xmlmind.fo.properties.Value;
import com.xmlmind.fo.util.Encoder;
import java.io.PrintWriter;
import java.util.Vector;

public final class TableCell {
    public int colNumber;
    public int colSpan;
    public int rowSpan;
    public double width;
    public boolean relativeWidth;
    public boolean startsRow;
    public boolean endsRow;
    public TableCellStyle style;
    public boolean isCovered;
    public boolean requiresLayout;
    private Vector content = new Vector();

    public TableCell(int n) {
        this.colNumber = n;
        this.colSpan = 1;
        this.rowSpan = 1;
        this.style = new TableCellStyle();
    }

    public TableCell(Context context) {
        this.initialize(context);
    }

    public void initialize(Context context) {
        Value[] valueArray = context.properties.values;
        this.colNumber = TableCell.number(valueArray[82]);
        this.colSpan = TableCell.number(valueArray[187]);
        this.rowSpan = TableCell.number(valueArray[188]);
        Value value = valueArray[308];
        switch (value.type) {
            case 4: {
                this.width = value.length();
                break;
            }
            case 13: {
                this.width = value.percentage();
                this.relativeWidth = true;
            }
        }
        if (valueArray[279].keyword() == 209) {
            this.startsRow = true;
        }
        if (valueArray[98].keyword() == 209) {
            this.endsRow = true;
        }
        this.style = new TableCellStyle(context);
    }

    private static int number(Value value) {
        int n = (int)Math.round(value.number());
        if (n < 1) {
            n = 1;
        }
        return n;
    }

    public boolean hasBackground() {
        return this.style.background != -1;
    }

    public void setBackground(Color color) {
        this.style.background = Odt.rgb(color);
    }

    private void add(int n, Object object) {
        this.content.addElement(new Element(n, object));
    }

    public void add(Paragraph paragraph) {
        this.add(0, paragraph);
    }

    public void add(Table table) {
        this.add(1, table);
    }

    public void add(TableAndCaption tableAndCaption) {
        this.add(2, tableAndCaption);
    }

    public void add(List list) {
        this.add(3, list);
    }

    public void layout(double d, StyleTable styleTable) throws Exception {
        d -= this.style.paddingLeft + this.style.paddingRight;
        int n = this.content.size();
        block6: for (int i = 0; i < n; ++i) {
            Element element = (Element)this.content.elementAt(i);
            switch (element.type) {
                case 0: {
                    Paragraph paragraph = (Paragraph)element.object;
                    if (!paragraph.requiresLayout()) continue block6;
                    paragraph.layout(d);
                    paragraph.style = styleTable.add(paragraph.style);
                    continue block6;
                }
                case 1: {
                    Table table = (Table)element.object;
                    table.layout(d, styleTable);
                    continue block6;
                }
                case 2: {
                    TableAndCaption tableAndCaption = (TableAndCaption)element.object;
                    tableAndCaption.layout(d, styleTable);
                    continue block6;
                }
                case 3: {
                    List list = (List)element.object;
                    list.layout(d, styleTable);
                }
            }
        }
    }

    public void print(PrintWriter printWriter, Encoder encoder) {
        if (this.isCovered) {
            printWriter.print("<table:covered-table-cell");
            printWriter.print(" table:style-name=\"" + this.style.name + "\"");
            printWriter.println("/>");
            return;
        }
        printWriter.print("<table:table-cell");
        printWriter.print(" table:style-name=\"" + this.style.name + "\"");
        if (this.colSpan > 1) {
            printWriter.print(" table:number-columns-spanned=\"" + this.colSpan + "\"");
        }
        if (this.rowSpan > 1) {
            printWriter.print(" table:number-rows-spanned=\"" + this.rowSpan + "\"");
        }
        printWriter.println(">");
        int n = this.content.size();
        block6: for (int i = 0; i < n; ++i) {
            Element element = (Element)this.content.elementAt(i);
            switch (element.type) {
                case 0: {
                    Paragraph paragraph = (Paragraph)element.object;
                    paragraph.print(printWriter, encoder);
                    continue block6;
                }
                case 1: {
                    Table table = (Table)element.object;
                    table.print(printWriter, encoder);
                    continue block6;
                }
                case 2: {
                    TableAndCaption tableAndCaption = (TableAndCaption)element.object;
                    tableAndCaption.print(printWriter, encoder);
                    continue block6;
                }
                case 3: {
                    List list = (List)element.object;
                    list.print(printWriter, encoder);
                }
            }
        }
        printWriter.print("</table:table-cell>");
    }

    public double minWidth() {
        double d = 0.0;
        int n = this.content.size();
        block6: for (int i = 0; i < n; ++i) {
            Element element = (Element)this.content.elementAt(i);
            switch (element.type) {
                case 0: {
                    Paragraph paragraph = (Paragraph)element.object;
                    double d2 = paragraph.minWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                    continue block6;
                }
                case 1: {
                    Table table = (Table)element.object;
                    double d2 = table.minWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                    continue block6;
                }
                case 2: {
                    TableAndCaption tableAndCaption = (TableAndCaption)element.object;
                    double d2 = tableAndCaption.minWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                    continue block6;
                }
                case 3: {
                    List list = (List)element.object;
                    double d2 = list.minWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                }
            }
        }
        d += this.style.paddingLeft + this.style.paddingRight;
        d += 1.5;
        if (!this.relativeWidth && this.width > d) {
            d = this.width;
        }
        return d;
    }

    public double maxWidth() {
        double d = 0.0;
        int n = this.content.size();
        block6: for (int i = 0; i < n; ++i) {
            Element element = (Element)this.content.elementAt(i);
            switch (element.type) {
                case 0: {
                    Paragraph paragraph = (Paragraph)element.object;
                    double d2 = paragraph.maxWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                    continue block6;
                }
                case 1: {
                    Table table = (Table)element.object;
                    double d2 = table.maxWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                    continue block6;
                }
                case 2: {
                    TableAndCaption tableAndCaption = (TableAndCaption)element.object;
                    double d2 = tableAndCaption.maxWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                    continue block6;
                }
                case 3: {
                    List list = (List)element.object;
                    double d2 = list.maxWidth();
                    if (!(d2 > d)) continue block6;
                    d = d2;
                }
            }
        }
        d += this.style.paddingLeft + this.style.paddingRight;
        d += 1.5;
        if (!this.relativeWidth && this.width > d) {
            d = this.width;
        }
        return d;
    }

    private class Element {
        static final int TYPE_PARAGRAPH = 0;
        static final int TYPE_TABLE = 1;
        static final int TYPE_TABLE_AND_CAPTION = 2;
        static final int TYPE_LIST = 3;
        int type;
        Object object;

        Element(int n, Object object) {
            this.type = n;
            this.object = object;
        }
    }
}

