/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.odt.Borders;
import com.xmlmind.fo.converter.odt.Odt;
import com.xmlmind.fo.converter.odt.TableCell;
import com.xmlmind.fo.converter.odt.TableRowStyle;
import com.xmlmind.fo.properties.Color;
import com.xmlmind.fo.properties.Value;
import com.xmlmind.fo.util.Encoder;
import java.io.PrintWriter;
import java.util.Vector;

public final class TableRow {
    public Borders borders;
    public TableRowStyle style;
    public TableCell[] cells;
    public boolean requiresLayout;
    private Vector list = new Vector();

    public TableRow() {
        this.borders = new Borders();
        this.style = new TableRowStyle();
    }

    public TableRow(Context context) {
        this.initialize(context);
    }

    public void initialize(Context context) {
        Value[] valueArray = context.properties.values;
        this.borders = new Borders(valueArray);
        this.style = new TableRowStyle(context);
    }

    public boolean hasBackground() {
        return this.style.background != -1;
    }

    public void setBackground(Color color) {
        this.style.background = Odt.rgb(color);
    }

    public void add(TableCell tableCell) {
        this.list.addElement(tableCell);
    }

    public int size() {
        return this.list.size();
    }

    public TableCell get(int n) {
        return (TableCell)this.list.elementAt(n);
    }

    public int span() {
        int n = 1;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            TableCell tableCell = this.get(i);
            if (tableCell.rowSpan <= n) continue;
            n = tableCell.rowSpan;
        }
        return n;
    }

    public void normalize(int n) {
        int n2;
        this.cells = new TableCell[n];
        int n3 = this.size();
        for (n2 = 0; n2 < n3; ++n2) {
            TableCell tableCell = this.get(n2);
            int n4 = tableCell.colNumber - 1;
            this.cells[n4] = tableCell;
            if (tableCell.colSpan <= 1) continue;
            int n5 = n4 + tableCell.colSpan - 1;
            for (int i = n4 + 1; i <= n5; ++i) {
                this.cells[i] = new TableCell(i + 1);
                this.cells[i].rowSpan = tableCell.rowSpan;
                this.cells[i].isCovered = true;
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (this.cells[n2] != null) continue;
            this.cells[n2] = new TableCell(n2 + 1);
        }
    }

    public void print(PrintWriter printWriter, Encoder encoder) {
        printWriter.print("<table:table-row");
        printWriter.print(" table:style-name=\"" + this.style.name + "\"");
        printWriter.println(">");
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i].print(printWriter, encoder);
        }
        printWriter.print("</table:table-row>");
    }
}

