/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.odt.Odt;
import com.xmlmind.fo.properties.Value;
import java.io.PrintWriter;

public final class TableRowStyle {
    public static final int BREAK_AUTO = 0;
    public static final int BREAK_COLUMN = 1;
    public static final int BREAK_PAGE = 2;
    public static final int COLOR_TRANSPARENT = -1;
    public String name;
    public int breakBefore;
    public int breakAfter;
    public boolean keepTogether;
    public double height;
    public boolean optimizeHeight;
    public int background;

    public TableRowStyle() {
        this.background = -1;
    }

    public TableRowStyle(Context context) {
        this.initialize(context);
    }

    public void initialize(Context context) {
        Value value;
        Value[] valueArray = context.properties.values;
        switch (context.properties.breakBefore()) {
            case 1: {
                this.breakBefore = 1;
                break;
            }
            case 2: {
                this.breakBefore = 2;
            }
        }
        switch (context.properties.breakAfter()) {
            case 1: {
                this.breakAfter = 1;
                break;
            }
            case 2: {
                this.breakAfter = 2;
            }
        }
        this.keepTogether = TableRowStyle.keep(valueArray[137]);
        if (context.properties.isSpecified(118)) {
            value = valueArray[118];
            if (value.type == 4) {
                this.height = value.length();
            }
        } else {
            this.optimizeHeight = true;
        }
        value = valueArray[8];
        this.background = value.type == 24 ? Odt.rgb(value.color()) : -1;
    }

    private static boolean keep(Value value) {
        boolean bl = false;
        switch (value.type) {
            case 1: {
                if (value.keyword() != 8) break;
                bl = true;
                break;
            }
            case 2: {
                if (value.integer() <= 0) break;
                bl = true;
            }
        }
        return bl;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("<style:style style:family=\"table-row\"");
        printWriter.print(" style:name=\"" + this.name + "\"");
        printWriter.println(">");
        printWriter.println("<style:table-row-properties");
        if (this.breakBefore != 0) {
            printWriter.println(" fo:break-before=\"" + this.breakBefore() + "\"");
        }
        if (this.breakAfter != 0) {
            printWriter.println(" fo:break-after=\"" + this.breakAfter() + "\"");
        }
        if (this.keepTogether) {
            printWriter.println(" fo:keep-together=\"always\"");
        }
        if (this.height > 0.0) {
            printWriter.println(" style:min-row-height=\"" + Odt.length(this.height, 1) + "\"");
        }
        printWriter.println(" style:use-optimal-row-height=\"" + this.optimizeHeight() + "\"");
        if (this.background != -1) {
            printWriter.println(" fo:background-color=\"" + Odt.color(this.background) + "\"");
        }
        printWriter.println(">");
        printWriter.println("</style:table-row-properties>");
        printWriter.println("</style:style>");
    }

    private String breakBefore() {
        String string = "auto";
        switch (this.breakBefore) {
            case 1: {
                string = "column";
                break;
            }
            case 2: {
                string = "page";
            }
        }
        return string;
    }

    private String breakAfter() {
        String string = "auto";
        switch (this.breakAfter) {
            case 1: {
                string = "column";
                break;
            }
            case 2: {
                string = "page";
            }
        }
        return string;
    }

    private String optimizeHeight() {
        if (this.optimizeHeight) {
            return "true";
        }
        return "false";
    }

    public int hashCode() {
        int n = 0;
        n = TableRowStyle.shift(n) ^ this.breakBefore;
        n = TableRowStyle.shift(n) ^ this.breakAfter;
        n = TableRowStyle.shift(n) ^ TableRowStyle.hash(this.keepTogether);
        n = TableRowStyle.shift(n) ^ TableRowStyle.hash(this.height);
        n = TableRowStyle.shift(n) ^ TableRowStyle.hash(this.optimizeHeight);
        n = TableRowStyle.shift(n) ^ this.background;
        return n >>> 16 | n << 16;
    }

    private static int hash(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)(l ^ l >>> 32);
    }

    private static int hash(boolean bl) {
        return bl ? 1 : 0;
    }

    private static int shift(int n) {
        return n << 1 | n >>> 31;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TableRowStyle)) {
            return false;
        }
        TableRowStyle tableRowStyle = (TableRowStyle)object;
        return this.breakBefore == tableRowStyle.breakBefore && this.breakAfter == tableRowStyle.breakAfter && this.keepTogether == tableRowStyle.keepTogether && this.height == tableRowStyle.height && this.optimizeHeight == tableRowStyle.optimizeHeight && this.background == tableRowStyle.background;
    }
}

