/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.odt;

import com.xmlmind.fo.converter.odt.Odt;
import com.xmlmind.fo.converter.odt.Span;
import com.xmlmind.fo.converter.odt.TextStyle;
import com.xmlmind.fo.font.Font;
import com.xmlmind.fo.util.Encoder;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public final class Text {
    public String content;
    public TextStyle style;
    public boolean preserveSpace;

    public Text() {
        this("");
    }

    public Text(String string) {
        this(string, null);
    }

    public Text(String string, TextStyle textStyle) {
        this(string, textStyle, false);
    }

    public Text(String string, TextStyle textStyle, boolean bl) {
        this.content = string;
        this.style = textStyle;
        this.preserveSpace = bl;
    }

    public void print(PrintWriter printWriter, Encoder encoder) {
        Span.start(printWriter, this.style);
        if (this.preserveSpace) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.content, " ", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (string.equals(" ")) {
                    int n = 1;
                    while (stringTokenizer.hasMoreTokens() && (string = stringTokenizer.nextToken()).equals(" ")) {
                        ++n;
                    }
                    printWriter.print(" ");
                    if (n > 1) {
                        printWriter.print("<text:s text:c=\"" + (n - 1) + "\"/>");
                    }
                    if (string.equals(" ")) break;
                }
                printWriter.print(Odt.escape(string, encoder));
            }
        } else {
            printWriter.print(Odt.escape(this.content, encoder));
        }
        Span.end(printWriter);
    }

    public boolean isSpace() {
        int n = this.content.length();
        for (int i = 0; i < n; ++i) {
            if (this.content.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public void trimLeft() {
        int n = this.content.length();
        if (n == 0 || this.content.charAt(0) != ' ') {
            return;
        }
        for (int i = 1; i < n; ++i) {
            if (this.content.charAt(i) == ' ') continue;
            this.content = this.content.substring(i);
            return;
        }
        this.content = "";
    }

    public void trimRight() {
        int n = this.content.length();
        if (n == 0 || this.content.charAt(n - 1) != ' ') {
            return;
        }
        for (int i = n - 2; i >= 0; --i) {
            if (this.content.charAt(i) == ' ') continue;
            this.content = this.content.substring(0, i + 1);
            return;
        }
        this.content = "";
    }

    public double textWidth() {
        double d;
        Font font = null;
        if (this.style != null) {
            font = this.style.getFont();
        }
        if (font != null) {
            d = (double)font.getTextExtents((String)this.content).width / 20.0;
            d = this.adjustWidth(d);
        } else {
            d = (double)this.content.length() * this.charWidth();
        }
        return d;
    }

    public double wordWidth() {
        double d;
        Font font = null;
        if (this.style != null) {
            font = this.style.getFont();
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(this.content);
        if (font != null) {
            while (stringTokenizer.hasMoreTokens()) {
                int n2 = font.getTextExtents((String)stringTokenizer.nextToken()).width;
                if (n2 <= n) continue;
                n = n2;
            }
            d = (double)n / 20.0;
            d = this.adjustWidth(d);
        } else {
            while (stringTokenizer.hasMoreTokens()) {
                int n3 = stringTokenizer.nextToken().length();
                if (n3 <= n) continue;
                n = n3;
            }
            d = (double)n * this.charWidth();
        }
        return d;
    }

    private double adjustWidth(double d) {
        String string = this.style.font.name.toLowerCase();
        if (string.indexOf("dejavu") >= 0 || string.indexOf("vera") >= 0) {
            d *= 1.25;
        }
        return d;
    }

    private double charWidth() {
        double d = this.style != null ? this.style.fontSize : 12.0;
        return 3.0 * d / 4.0;
    }
}

