/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.rtf;

import java.io.PrintWriter;

public class Border
implements Cloneable {
    public static final int SIDE_TOP = 1;
    public static final int SIDE_BOTTOM = 2;
    public static final int SIDE_LEFT = 3;
    public static final int SIDE_RIGHT = 4;
    public static final int SIDE_ALL = 5;
    public int side;
    public int style;
    public int width;
    public int color;
    public int space;

    public Border(int n) {
        this(n, 125, 0, 0, 0);
    }

    public Border(int n, int n2, int n3, int n4, int n5) {
        this.side = n;
        this.set(n2, n3, n4, n5);
    }

    public void set(int n, int n2, int n3, int n4) {
        this.style = n;
        this.width = n2;
        this.color = n3;
        this.space = n4;
    }

    public void set(Border border) {
        this.set(border.style, border.width, border.color, border.space);
    }

    public boolean materialized() {
        return this.style != 125 && this.style != 75 && this.width > 0;
    }

    public void print(PrintWriter printWriter) {
        switch (this.side) {
            case 1: {
                printWriter.print("\\brdrt");
                break;
            }
            case 2: {
                printWriter.print("\\brdrb");
                break;
            }
            case 3: {
                printWriter.print("\\brdrl");
                break;
            }
            case 4: {
                printWriter.print("\\brdrr");
                break;
            }
            case 5: {
                printWriter.print("\\chbrdr");
                break;
            }
            default: {
                return;
            }
        }
        printWriter.print("\\brdr" + this.style());
        printWriter.print("\\brdrw" + this.width());
        printWriter.print("\\brsp" + this.space);
        if (this.color > 0) {
            printWriter.print("\\brdrcf" + this.color);
        }
    }

    protected String style() {
        String string;
        switch (this.style) {
            default: {
                string = "s";
                break;
            }
            case 187: {
                string = "s";
                break;
            }
            case 50: {
                string = "db";
                break;
            }
            case 49: {
                string = "dot";
                break;
            }
            case 42: {
                string = "dash";
                break;
            }
            case 73: {
                string = "engrave";
                break;
            }
            case 164: {
                string = "emboss";
                break;
            }
            case 89: {
                string = "inset";
                break;
            }
            case 143: {
                string = "outset";
            }
        }
        return string;
    }

    protected int width() {
        if (this.style == 50) {
            int n = this.width / 3;
            if (n <= 0) {
                n = 1;
            }
            return n;
        }
        return this.width;
    }

    public Border copy() {
        try {
            return (Border)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

