/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.rtf;

import com.xmlmind.fo.font.FontUtil;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;

public final class FontTable {
    public static final String FAMILY_ROMAN = "roman";
    public static final String FAMILY_SWISS = "swiss";
    public static final String FAMILY_MODERN = "modern";
    public static final String FAMILY_DECOR = "decor";
    public static final String FAMILY_SCRIPT = "script";
    public static final String FAMILY_TECH = "tech";
    private int defCharSet;
    private Vector fonts = new Vector();
    private Hashtable indexes = new Hashtable();

    public FontTable(int n) {
        this.defCharSet = n;
    }

    public int add(String string) {
        return this.add(string, this.defCharSet);
    }

    public int add(String string, int n) {
        return this.add(new Font(null, n, string, null));
    }

    public int add(Font font) {
        this.fonts.addElement(font);
        int n = this.fonts.size() - 1;
        Integer n2 = new Integer(n);
        this.indexes.put(this.key(font.name, font.charSet), n2);
        if (font.aliases != null) {
            for (int i = 0; i < font.aliases.length; ++i) {
                this.indexes.put(this.key(font.aliases[i], font.charSet), n2);
            }
        }
        return n;
    }

    private String key(String string, int n) {
        return string.toLowerCase() + "," + n;
    }

    public void print(PrintWriter printWriter) {
        printWriter.println("{\\fonttbl");
        int n = this.fonts.size();
        for (int i = 0; i < n; ++i) {
            Font font = (Font)this.fonts.elementAt(i);
            printWriter.print("\\f" + i);
            printWriter.print("\\f" + font.family);
            printWriter.print("\\fcharset" + font.charSet);
            printWriter.println(" " + font.name + ";");
        }
        printWriter.println("}");
    }

    public int index(String string, int n) {
        Integer n2 = (Integer)this.indexes.get(this.key(string, n));
        if (n2 != null) {
            return n2;
        }
        return -1;
    }

    public int index(String string) {
        return this.index(string, this.defCharSet);
    }

    public Font font(int n) {
        return (Font)this.fonts.elementAt(n);
    }

    public String name(int n) {
        return this.font((int)n).name;
    }

    public static class Font
    implements Cloneable {
        public String family;
        public int charSet;
        public String name;
        public String[] aliases;

        public Font(String string, int n, String string2, String[] stringArray) {
            if (string == null) {
                switch (FontUtil.toGenericFamily(string2, false)) {
                    case 1: {
                        string = FontTable.FAMILY_ROMAN;
                        break;
                    }
                    case 2: {
                        string = FontTable.FAMILY_SWISS;
                        break;
                    }
                    case 3: {
                        string = FontTable.FAMILY_MODERN;
                        break;
                    }
                    case 4: {
                        string = FontTable.FAMILY_DECOR;
                        break;
                    }
                    case 5: {
                        string = FontTable.FAMILY_SCRIPT;
                        break;
                    }
                    default: {
                        string = "nil";
                    }
                }
            }
            this.family = string;
            this.charSet = n;
            this.name = string2;
            this.aliases = stringArray;
        }

        public Font copy() {
            try {
                return (Font)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }
}

