/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.rtf;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.rtf.Borders;
import com.xmlmind.fo.converter.rtf.ColorTable;
import com.xmlmind.fo.converter.rtf.Rtf;
import com.xmlmind.fo.converter.rtf.RunProperties;
import com.xmlmind.fo.converter.rtf.Text;
import com.xmlmind.fo.properties.Value;
import com.xmlmind.fo.util.Encoder;
import java.io.PrintWriter;
import java.util.Vector;

public final class ParProperties {
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_CENTER = 1;
    public static final int ALIGNMENT_RIGHT = 2;
    public static final int ALIGNMENT_JUSTIFIED = 3;
    public int breakBefore;
    public int spaceBefore;
    public int lineHeight;
    public boolean keepTogether;
    public boolean keepWithNext;
    public int alignment = 0;
    public int startIndent;
    public int endIndent;
    public int firstLineIndent;
    public int outlineLevel;
    public Borders borders;
    public int background;
    public int listId;
    public Text listText;
    public Vector tabs;
    public boolean isInTable;
    public int nestingLevel;
    public RunProperties markProperties;

    public ParProperties() {
    }

    public ParProperties(Context context, ColorTable colorTable) {
        this();
        this.initialize(context, colorTable);
    }

    public void initialize(Context context, ColorTable colorTable) {
        Context context2 = context.block();
        Value[] valueArray = context2.properties.values;
        this.breakBefore = context2.breakBefore;
        this.spaceBefore = Rtf.toTwips(context2.spaceBefore());
        this.lineHeight = ParProperties.length(context2.lineHeight);
        this.keepTogether = ParProperties.keep(valueArray[137]);
        this.keepWithNext = ParProperties.keep(valueArray[141]);
        switch (valueArray[289].keyword()) {
            default: {
                break;
            }
            case 31: {
                this.alignment = 1;
                break;
            }
            case 52: 
            case 144: 
            case 165: {
                this.alignment = 2;
                break;
            }
            case 93: {
                this.alignment = 3;
            }
        }
        this.startIndent = ParProperties.length(valueArray[277]);
        this.endIndent = ParProperties.length(valueArray[97]);
        this.firstLineIndent = ParProperties.length(valueArray[294]);
        this.outlineLevel = ParProperties.integer(valueArray[322], 0);
        this.borders = new Borders(valueArray, colorTable);
        if (context2.background != null) {
            this.background = Rtf.colorIndex(context2.background, colorTable);
        }
    }

    public void addTab(Tab tab) {
        if (this.tabs == null) {
            this.tabs = new Vector();
        }
        this.tabs.addElement(tab);
    }

    public boolean hasTabs() {
        return this.tabs != null && this.tabs.size() > 0;
    }

    public Tab[] tabs() {
        Tab[] tabArray = null;
        if (this.hasTabs()) {
            tabArray = new Tab[this.tabs.size()];
            for (int i = 0; i < tabArray.length; ++i) {
                tabArray[i] = (Tab)this.tabs.elementAt(i);
            }
        }
        return tabArray;
    }

    public void print(PrintWriter printWriter, Encoder encoder) throws Exception {
        printWriter.print("\\pard");
        if (this.borders != null && this.borders.materialized()) {
            this.borders.print(printWriter);
        }
        if (this.isInTable) {
            printWriter.print("\\intbl");
            if (this.nestingLevel > 1) {
                printWriter.print("\\itap" + this.nestingLevel);
            }
        }
        if (this.keepTogether) {
            printWriter.print("\\keep");
        }
        if (this.keepWithNext) {
            printWriter.print("\\keepn");
        }
        if (this.outlineLevel >= 1 && this.outlineLevel <= 9) {
            printWriter.print("\\outlinelevel" + Integer.toString(this.outlineLevel - 1));
        }
        if (this.breakBefore == 2) {
            printWriter.print("\\pagebb");
        }
        if (this.spaceBefore > 0) {
            printWriter.print("\\sb" + this.spaceBefore);
        }
        switch (this.alignment) {
            case 2: {
                printWriter.print("\\qr");
                break;
            }
            case 1: {
                printWriter.print("\\qc");
                break;
            }
            case 3: {
                printWriter.print("\\qj");
                break;
            }
        }
        if (this.startIndent != 0) {
            printWriter.print("\\li" + this.startIndent);
        }
        if (this.endIndent != 0) {
            printWriter.print("\\ri" + this.endIndent);
        }
        if (this.firstLineIndent != 0) {
            printWriter.print("\\fi" + this.firstLineIndent);
        }
        if (this.lineHeight > 0) {
            printWriter.print("\\sl" + this.lineHeight);
        }
        if (this.listId > 0) {
            printWriter.print("\\ls" + this.listId);
        }
        if (this.tabs != null) {
            int n = this.tabs.size();
            for (int i = 0; i < n; ++i) {
                Tab tab = (Tab)this.tabs.elementAt(i);
                tab.print(printWriter);
            }
        }
        if (this.background > 0) {
            printWriter.print("\\cbpat" + this.background);
        }
        if (this.markProperties != null) {
            this.markProperties.print(printWriter);
        }
    }

    private static int integer(Value value, int n) {
        if (value != null && value.type == 2) {
            return value.integer();
        }
        return n;
    }

    private static int length(Value value) {
        int n = 0;
        if (value.type == 4) {
            n = Rtf.toTwips(value.length());
        }
        return n;
    }

    private static boolean keep(Value value) {
        boolean bl = false;
        switch (value.type) {
            case 1: {
                if (value.keyword() != 8) break;
                bl = true;
                break;
            }
            case 2: {
                if (value.integer() <= 0) break;
                bl = true;
            }
        }
        return bl;
    }

    public static class Tab {
        public static final int LEADER_NONE = 0;
        public static final int LEADER_DOTS = 1;
        public static final int LEADER_LINE = 2;
        public static final int ALIGN_LEFT = 0;
        public static final int ALIGN_RIGHT = 1;
        public static final int ALIGN_CENTER = 2;
        public static final int ALIGN_DECIMAL = 3;
        public int position;
        public int leader;
        public int align;

        public Tab(int n) {
            this(n, 0, 0);
        }

        public Tab(int n, int n2, int n3) {
            this.position = n;
            this.leader = n2;
            this.align = n3;
        }

        public void print(PrintWriter printWriter) {
            switch (this.align) {
                case 1: {
                    printWriter.print("\\tqr");
                    break;
                }
                case 2: {
                    printWriter.print("\\tqc");
                    break;
                }
                case 3: {
                    printWriter.print("\\tqdec");
                }
            }
            switch (this.leader) {
                case 1: {
                    printWriter.print("\\tldot");
                    break;
                }
                case 2: {
                    printWriter.print("\\tlth");
                }
            }
            printWriter.print("\\tx" + this.position);
        }
    }
}

