/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.rtf;

import com.xmlmind.fo.converter.GraphicLayout;
import com.xmlmind.fo.converter.rtf.ColorTable;
import com.xmlmind.fo.converter.rtf.RunProperties;
import com.xmlmind.fo.graphic.Graphic;
import com.xmlmind.fo.graphic.GraphicEnv;
import com.xmlmind.fo.graphic.GraphicFactories;
import com.xmlmind.fo.util.StringUtil;
import com.xmlmind.fo.util.URLUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;

public class Picture {
    private Graphic graphic;
    private GraphicEnv graphicEnv;
    private RunProperties properties;
    private ColorTable colors;
    private boolean prescaled;
    private int imageResolution;
    private int imageRendererResolution;
    private String[] graphicFormats;
    private double xScale = 1.0;
    private double yScale = 1.0;
    private Graphic picture;
    private GraphicLayout layout;
    private static final String[] graphicFormats1 = new String[]{"image/x-wmf", "image/x-emf", "image/jpeg", "image/png"};
    private static final String[] graphicFormats2 = new String[]{"image/x-wmf", "image/x-emf", "image/png"};

    public Picture(Graphic graphic, GraphicEnv graphicEnv, RunProperties runProperties, ColorTable colorTable, boolean bl, int n, int n2, boolean bl2) {
        this.graphic = graphic;
        this.graphicEnv = graphicEnv;
        this.properties = runProperties;
        this.colors = colorTable;
        this.prescaled = bl;
        this.imageResolution = n;
        this.imageRendererResolution = n2;
        this.graphicFormats = bl2 ? graphicFormats2 : graphicFormats1;
    }

    public int width() {
        double d = GraphicLayout.width(this.graphic, this.imageResolution);
        if (d == 0.0) {
            d = GraphicLayout.intrinsicWidth(this.graphic, this.imageResolution);
        }
        if (this.properties != null && this.properties.border != null) {
            d += (double)(this.properties.border.width + this.properties.border.space) / 10.0;
        }
        return Picture.toTwips(d);
    }

    public void layout(double d) throws Exception {
        if (this.picture != null) {
            return;
        }
        if (this.properties != null && this.properties.border != null) {
            d -= (double)(this.properties.border.width + this.properties.border.space) / 10.0;
        }
        this.layout = new GraphicLayout(this.graphic, this.imageResolution, d);
        double d2 = GraphicLayout.intrinsicWidth(this.graphic, this.imageRendererResolution);
        double d3 = GraphicLayout.intrinsicHeight(this.graphic, this.imageRendererResolution);
        if (this.layout.contentWidth != d2) {
            this.xScale = this.layout.contentWidth / d2;
        }
        if (this.layout.contentHeight != d3) {
            this.yScale = this.layout.contentHeight / d3;
        }
        switch (this.graphic.getType()) {
            case 2: {
                this.prescaled = true;
                break;
            }
            case 0: {
                this.prescaled = false;
                break;
            }
            default: {
                if (this.xScale < 1.0 && this.yScale < 1.0) break;
                this.prescaled = false;
            }
        }
        if (this.prescaled || !StringUtil.contains(this.graphicFormats, this.graphic.getFormat())) {
            try {
                if (this.prescaled) {
                    this.picture = GraphicFactories.convertGraphic(this.graphic, this.graphicFormats, this.xScale, this.yScale, null, this.graphicEnv);
                }
                this.picture = GraphicFactories.convertGraphic(this.graphic, this.graphicFormats, 1.0, 1.0, null, this.graphicEnv);
            }
            catch (Exception exception) {
                this.graphicEnv.reportWarning("failed to convert image \"" + this.graphic.getLocation() + "\": " + exception.getMessage());
                this.picture = null;
                return;
            }
        } else {
            this.picture = this.graphic;
        }
        if (this.properties != null) {
            int n = 0;
            int n2 = (int)Math.round(2.0 * this.layout.viewportHeight);
            int n3 = this.properties.fontSize;
            int n4 = this.properties.fontSize / 4;
            int n5 = (n3 + n4) / 2 - n4;
            switch (this.properties.alignmentBaseline) {
                case 121: {
                    n = -(n2 / 2) + n5;
                    break;
                }
                case 17: 
                case 199: {
                    n = -n2 + n3;
                    break;
                }
                case 5: 
                case 198: {
                    n = -n4;
                }
            }
            if (n != 0) {
                if (n < 0) {
                    this.properties.subscript = true;
                } else {
                    this.properties.superscript = true;
                }
                this.properties.baselineShift = Math.abs(n);
            }
        }
    }

    public void print(PrintWriter printWriter) throws Exception {
        if (this.picture == null) {
            return;
        }
        printWriter.print("{");
        if (this.properties != null) {
            this.properties.print(printWriter);
        }
        printWriter.println();
        this.printPicture(printWriter);
        printWriter.println("}");
    }

    private void printPicture(PrintWriter printWriter) throws Exception {
        int n;
        int n2;
        if (this.prescaled) {
            n2 = 100;
            n = 100;
        } else {
            n2 = (int)Math.round(this.xScale * 100.0);
            n = (int)Math.round(this.yScale * 100.0);
        }
        printWriter.print("{\\pict");
        String string = this.picture.getFormat();
        int n3 = 0;
        if ("image/x-wmf".equals(string)) {
            printWriter.print("\\wmetafile8");
            int n4 = (int)Math.rint((double)this.picture.getWidth() / this.picture.getXResolution() * 2540.0);
            int n5 = (int)Math.rint((double)this.picture.getHeight() / this.picture.getYResolution() * 2540.0);
            printWriter.print("\\picw" + n4);
            printWriter.print("\\pich" + n5);
            int n6 = (int)Math.rint(this.picture.getXResolution());
            printWriter.print("\\blipupi" + n6);
            n3 = 22;
        } else if ("image/x-emf".equals(string)) {
            printWriter.print("\\emfblip");
        } else {
            printWriter.print("\\pngblip");
        }
        printWriter.print("\\picscalex" + n2);
        printWriter.println("\\picscaley" + n);
        if (this.layout.contentWidth != this.layout.viewportWidth || this.layout.contentHeight != this.layout.viewportHeight) {
            double d;
            double d2;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            if (this.layout.contentWidth < this.layout.viewportWidth) {
                d3 = -this.layout.contentX;
                double d7 = this.layout.contentX + this.layout.contentWidth;
                d5 = -(this.layout.viewportWidth - d7);
            } else if (this.layout.contentWidth > this.layout.viewportWidth) {
                d3 = this.layout.cropX;
                double d8 = this.layout.cropX + this.layout.viewportWidth;
                d5 = this.layout.contentWidth - d8;
            }
            if (this.layout.contentHeight < this.layout.viewportHeight) {
                d4 = -this.layout.contentY;
                double d9 = this.layout.contentY + this.layout.contentHeight;
                d6 = -(this.layout.viewportHeight - d9);
            } else if (this.layout.contentHeight > this.layout.viewportHeight) {
                d4 = this.layout.cropY;
                double d10 = this.layout.cropY + this.layout.viewportHeight;
                d6 = this.layout.contentHeight - d10;
            }
            if (this.prescaled) {
                d2 = this.layout.contentWidth;
                d = this.layout.contentHeight;
            } else {
                d2 = GraphicLayout.intrinsicWidth(this.graphic, this.imageRendererResolution);
                d = GraphicLayout.intrinsicHeight(this.graphic, this.imageRendererResolution);
                d3 /= this.xScale;
                d5 /= this.xScale;
                d4 /= this.yScale;
                d6 /= this.yScale;
            }
            printWriter.print("\\picwgoal" + Picture.toTwips(d2));
            printWriter.print("\\pichgoal" + Picture.toTwips(d));
            printWriter.print("\\piccropl" + Picture.toTwips(d3));
            printWriter.print("\\piccropt" + Picture.toTwips(d4));
            printWriter.print("\\piccropr" + Picture.toTwips(d5));
            printWriter.println("\\piccropb" + Picture.toTwips(d6));
        }
        try {
            Picture.printImageData(this.picture, n3, printWriter);
        }
        catch (Exception exception) {
            this.graphicEnv.reportWarning("failed to read image \"" + this.picture.getLocation() + "\": " + exception.getMessage());
        }
        printWriter.println("}");
    }

    private static int toTwips(double d) {
        return (int)Math.round(d * 20.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printImageData(Graphic graphic, int n, PrintWriter printWriter) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(URLUtil.openStream(graphic.getLocation()));
        try {
            int n2;
            if (n > 0) {
                ((InputStream)bufferedInputStream).skip(n);
            }
            byte[] byArray = new byte[256];
            StringBuffer stringBuffer = new StringBuffer(2 * byArray.length);
            while ((n2 = ((InputStream)bufferedInputStream).read(byArray)) >= 0) {
                stringBuffer.setLength(0);
                for (int i = 0; i < n2; ++i) {
                    byte by = byArray[i];
                    stringBuffer.append(Integer.toHexString(by >> 4 & 0xF));
                    stringBuffer.append(Integer.toHexString(by & 0xF));
                }
                printWriter.println(stringBuffer.toString());
            }
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }
}

