/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.rtf;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.rtf.Borders;
import com.xmlmind.fo.converter.rtf.ColorTable;
import com.xmlmind.fo.converter.rtf.Rtf;
import com.xmlmind.fo.properties.Value;

public class TableColumn {
    public int number;
    public int repeat;
    public int span;
    public int width;
    public double percentage;
    public double proportion;
    public Borders borders;
    public int background;

    public TableColumn() {
    }

    public TableColumn(Context context, ColorTable colorTable) {
        this();
        this.initialize(context, colorTable);
    }

    public void initialize(Context context, ColorTable colorTable) {
        Value[] valueArray = context.properties.values;
        this.number = TableColumn.number(valueArray[82]);
        this.repeat = TableColumn.number(valueArray[186]);
        this.span = TableColumn.number(valueArray[187]);
        Value value = valueArray[83];
        if (value != null) {
            switch (value.type) {
                case 4: {
                    this.width = Rtf.toTwips(value.length());
                    break;
                }
                case 13: {
                    this.percentage = value.percentage();
                    break;
                }
                case 29: {
                    this.proportion = value.proportionalColumnWidth();
                }
            }
        }
        this.borders = new Borders(valueArray, colorTable);
        Value value2 = valueArray[8];
        if (value2.type == 24) {
            this.background = Rtf.colorIndex(value2.color(), colorTable);
        }
    }

    public void setReference(int n) {
        if (this.percentage > 0.0) {
            this.width = (int)((double)n * this.percentage / 100.0);
        }
    }

    private static int number(Value value) {
        int n = (int)Math.round(value.number());
        if (n < 1) {
            n = 1;
        }
        return n;
    }
}

