/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.rtf;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.rtf.Borders;
import com.xmlmind.fo.converter.rtf.ColorTable;
import com.xmlmind.fo.converter.rtf.Rtf;
import com.xmlmind.fo.converter.rtf.TableRow;
import com.xmlmind.fo.properties.Value;
import com.xmlmind.fo.util.Encoder;
import java.io.PrintWriter;
import java.util.Vector;

public class TableGroup {
    public Borders borders;
    public int background;
    public boolean isHeader;
    public Vector rows = new Vector();

    public TableGroup() {
        this(false);
    }

    public TableGroup(boolean bl) {
        this.isHeader = bl;
    }

    public TableGroup(Context context, ColorTable colorTable) {
        this(false, context, colorTable);
    }

    public TableGroup(boolean bl, Context context, ColorTable colorTable) {
        this(bl);
        this.initialize(context, colorTable);
    }

    public void initialize(Context context, ColorTable colorTable) {
        Value[] valueArray = context.properties.values;
        this.borders = new Borders(valueArray, colorTable);
        Value value = valueArray[8];
        if (value.type == 24) {
            this.background = Rtf.colorIndex(value.color(), colorTable);
        }
    }

    public void add(TableRow tableRow) {
        this.rows.addElement(tableRow);
        if (this.isHeader) {
            tableRow.isHeaderRow = true;
        }
    }

    public int size() {
        return this.rows.size();
    }

    public TableRow get(int n) {
        return (TableRow)this.rows.elementAt(n);
    }

    public void print(PrintWriter printWriter, Encoder encoder, int n) throws Exception {
        int n2 = this.rows.size();
        for (int i = 0; i < n2; ++i) {
            TableRow tableRow = (TableRow)this.rows.elementAt(i);
            tableRow.print(printWriter, encoder, n);
        }
    }
}

