/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.wml;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.wml.ListTable;
import com.xmlmind.fo.converter.wml.Paragraph;
import com.xmlmind.fo.converter.wml.RunProperties;
import com.xmlmind.fo.converter.wml.Text;
import com.xmlmind.fo.converter.wml.Wml;
import com.xmlmind.fo.properties.LabelFormat;
import com.xmlmind.fo.properties.Value;
import java.util.Vector;

public final class List {
    public int id = -1;
    public boolean plainText;
    public int labelSeparation;
    public LabelFormat labelFormat;
    public Item item;

    public List() {
    }

    public List(Context context) {
        this();
        this.initialize(context);
    }

    public void initialize(Context context) {
        Value[] valueArray = context.properties.values;
        Value value = valueArray[224];
        if (value.type == 4) {
            this.labelSeparation = Wml.toTwips(value.length());
        }
        if ((value = valueArray[321]) != null && value.type == 30) {
            this.labelFormat = value.labelFormat();
        }
    }

    public static class Item {
        public int breakBefore;
        public int spaceBefore;
        public Label label;

        public Item() {
        }

        public Item(Paragraph paragraph) {
            this();
            this.initialize(paragraph);
        }

        public void initialize(Paragraph paragraph) {
            this.breakBefore = paragraph.properties.breakBefore;
            this.spaceBefore = paragraph.properties.spaceBefore;
            this.label = new Label(paragraph);
        }

        public static class Label {
            public static final int ALIGNMENT_LEFT = 0;
            public static final int ALIGNMENT_CENTER = 1;
            public static final int ALIGNMENT_RIGHT = 2;
            private static final int STYLE_NONE = 0;
            private static final int STYLE_ARABIC = 1;
            private static final int STYLE_UPPERCASE_ROMAN = 2;
            private static final int STYLE_LOWERCASE_ROMAN = 3;
            private static final int STYLE_UPPERCASE_LETTER = 4;
            private static final int STYLE_LOWERCASE_LETTER = 5;
            private static final int STYLE_BULLET = 6;
            public int alignment = 0;
            public int startIndent;
            public int endIndent;
            public Vector runs = new Vector();
            public RunProperties properties;
            public String text = "";

            public Label() {
            }

            public Label(Paragraph paragraph) {
                this();
                this.initialize(paragraph);
            }

            public void initialize(Paragraph paragraph) {
                Paragraph.Run run;
                String string = paragraph.properties.alignment;
                boolean bl = true;
                if (string == "center") {
                    this.alignment = 1;
                } else if (string == "right") {
                    this.alignment = 2;
                }
                this.startIndent = paragraph.properties.startIndent;
                this.endIndent = paragraph.properties.endIndent;
                int n = paragraph.runs.size();
                for (int i = 0; i < n; ++i) {
                    run = (Paragraph.Run)paragraph.runs.elementAt(i);
                    if (run.type == 2) break;
                    if (run.type != 1) {
                        bl = false;
                    }
                    this.runs.addElement(run);
                }
                if (bl) {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n2 = this.runs.size();
                    for (n = 0; n < n2; ++n) {
                        run = (Paragraph.Run)this.runs.elementAt(n);
                        Text text = (Text)run.object;
                        if (this.properties == null) {
                            this.properties = text.properties;
                        }
                        stringBuffer.append(text.text);
                    }
                    this.text = stringBuffer.toString().trim();
                }
            }

            public ListTable.List list(LabelFormat labelFormat) {
                ListTable.List list;
                if (labelFormat != null) {
                    if (labelFormat.type == 0) {
                        return null;
                    }
                    list = new ListTable.List();
                    list.format = "%1";
                    switch (labelFormat.type) {
                        case 2: {
                            list.style = 0;
                            break;
                        }
                        case 3: {
                            list.style = 4;
                            break;
                        }
                        case 4: {
                            list.style = 3;
                            break;
                        }
                        case 5: {
                            list.style = 2;
                            break;
                        }
                        case 6: {
                            list.style = 1;
                            break;
                        }
                        default: {
                            list.style = 23;
                            list.format = Wml.escape(labelFormat.suffix);
                        }
                    }
                    if (labelFormat.type != 1) {
                        list.start = labelFormat.start;
                        if (labelFormat.prefix != null) {
                            list.format = Wml.escape(labelFormat.prefix) + list.format;
                        }
                        if (labelFormat.suffix != null) {
                            list.format = list.format + Wml.escape(labelFormat.suffix);
                        }
                    }
                } else {
                    char c = '1';
                    int n = 0;
                    String string = "%1";
                    block7 : switch (this.text.length()) {
                        case 1: {
                            c = this.text.charAt(0);
                            n = Label.style(c);
                            if (n != 6) break;
                            string = "&#" + Integer.toString(c) + ";";
                            break;
                        }
                        case 2: {
                            char c2 = this.text.charAt(1);
                            if (c2 != '.' && c2 != ')') break;
                            c = this.text.charAt(0);
                            n = Label.style(c);
                            switch (n) {
                                case 0: {
                                    break block7;
                                }
                                case 6: {
                                    n = 0;
                                    break block7;
                                }
                            }
                            string = "%1" + Wml.escape(c2);
                            break;
                        }
                        case 3: {
                            char c3 = this.text.charAt(0);
                            char c4 = this.text.charAt(2);
                            if (!(c3 == '(' && c4 == ')' || c3 == '<' && c4 == '>') && (c3 != '[' || c4 != ']')) break;
                            c = this.text.charAt(1);
                            n = Label.style(c);
                            switch (n) {
                                case 0: {
                                    break block7;
                                }
                                case 6: {
                                    n = 0;
                                    break block7;
                                }
                            }
                            string = Wml.escape(c3) + "%1" + Wml.escape(c4);
                        }
                    }
                    if (n == 0) {
                        return null;
                    }
                    list = new ListTable.List();
                    switch (n) {
                        case 1: {
                            list.style = 0;
                            break;
                        }
                        case 2: {
                            list.style = 1;
                            break;
                        }
                        case 3: {
                            list.style = 2;
                            break;
                        }
                        case 4: {
                            list.style = 3;
                            break;
                        }
                        case 5: {
                            list.style = 4;
                            break;
                        }
                        case 6: {
                            list.style = 23;
                        }
                    }
                    list.start = c == '0' ? 0 : 1;
                    list.format = string;
                }
                switch (this.alignment) {
                    default: {
                        list.alignment = "left";
                        break;
                    }
                    case 1: {
                        list.alignment = "center";
                        break;
                    }
                    case 2: {
                        list.alignment = "right";
                    }
                }
                list.properties = this.properties;
                return list;
            }

            private static int style(char c) {
                int n = 0;
                switch (c) {
                    case '*': 
                    case '+': 
                    case '-': 
                    case '\u2013': 
                    case '\u2022': {
                        n = 6;
                        break;
                    }
                    case '0': 
                    case '1': {
                        n = 1;
                        break;
                    }
                    case 'I': {
                        n = 2;
                        break;
                    }
                    case 'i': {
                        n = 3;
                        break;
                    }
                    case 'A': {
                        n = 4;
                        break;
                    }
                    case 'a': {
                        n = 5;
                    }
                }
                return n;
            }
        }
    }
}

