/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.wml;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.wml.Borders;
import com.xmlmind.fo.converter.wml.RunProperties;
import com.xmlmind.fo.converter.wml.Wml;
import com.xmlmind.fo.properties.Color;
import com.xmlmind.fo.properties.Value;
import java.io.PrintWriter;
import java.util.Vector;

public final class ParProperties {
    public static final String ALIGNMENT_LEFT = "left";
    public static final String ALIGNMENT_CENTER = "center";
    public static final String ALIGNMENT_RIGHT = "right";
    public static final String ALIGNMENT_JUSTIFIED = "both";
    public int breakBefore;
    public int spaceBefore;
    public int lineHeight;
    public boolean keepTogether;
    public boolean keepWithNext;
    public String alignment = "left";
    public int startIndent;
    public int endIndent;
    public int firstLineIndent;
    public int outlineLevel;
    public Borders borders;
    public Color background;
    public int listId;
    public Vector tabs;
    public RunProperties markProperties;

    public ParProperties() {
    }

    public ParProperties(Context context) {
        this();
        this.initialize(context);
    }

    public void initialize(Context context) {
        Context context2 = context.block();
        Value[] valueArray = context2.properties.values;
        this.breakBefore = context2.breakBefore;
        this.spaceBefore = Wml.toTwips(context2.spaceBefore());
        this.lineHeight = ParProperties.length(context2.lineHeight);
        this.keepTogether = ParProperties.keep(valueArray[137]);
        this.keepWithNext = ParProperties.keep(valueArray[141]);
        switch (valueArray[289].keyword()) {
            default: {
                break;
            }
            case 31: {
                this.alignment = ALIGNMENT_CENTER;
                break;
            }
            case 52: 
            case 144: 
            case 165: {
                this.alignment = ALIGNMENT_RIGHT;
                break;
            }
            case 93: {
                this.alignment = ALIGNMENT_JUSTIFIED;
            }
        }
        this.startIndent = ParProperties.length(valueArray[277]);
        this.endIndent = ParProperties.length(valueArray[97]);
        this.firstLineIndent = ParProperties.length(valueArray[294]);
        this.outlineLevel = ParProperties.integer(valueArray[322], 0);
        this.borders = new Borders(valueArray);
        this.background = context2.background;
    }

    public void addTab(Tab tab) {
        if (this.tabs == null) {
            this.tabs = new Vector();
        }
        this.tabs.addElement(tab);
    }

    public boolean hasTabs() {
        return this.tabs != null && this.tabs.size() > 0;
    }

    public Tab[] tabs() {
        Tab[] tabArray = null;
        if (this.hasTabs()) {
            tabArray = new Tab[this.tabs.size()];
            for (int i = 0; i < tabArray.length; ++i) {
                tabArray[i] = (Tab)this.tabs.elementAt(i);
            }
        }
        return tabArray;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("<w:pPr>");
        if (this.keepWithNext) {
            printWriter.print("<w:keepNext />");
        }
        if (this.keepTogether) {
            printWriter.print("<w:keepLines />");
        }
        if (this.breakBefore == 2) {
            printWriter.print("<w:pageBreakBefore />");
        }
        if (this.listId > 0) {
            printWriter.print("<w:listPr>");
            printWriter.print("<w:ilfo w:val=\"" + this.listId + "\" />");
            printWriter.print("</w:listPr>");
        }
        if (this.borders != null && this.borders.materialized()) {
            printWriter.print("<w:pBdr>");
            this.borders.print(printWriter);
            printWriter.print("</w:pBdr>");
        }
        if (this.background != null) {
            printWriter.print("<w:shd");
            printWriter.print(" w:val=\"clear\"");
            printWriter.print(" w:fill=\"" + Wml.hexColorType(this.background) + "\"");
            printWriter.print(" />");
        }
        if (this.tabs != null) {
            printWriter.print("<w:tabs>");
            int n = this.tabs.size();
            for (int i = 0; i < n; ++i) {
                Tab tab = (Tab)this.tabs.elementAt(i);
                tab.print(printWriter);
            }
            printWriter.print("</w:tabs>");
        }
        if (this.spaceBefore != 0 || this.lineHeight != 0) {
            printWriter.print("<w:spacing");
            printWriter.print(" w:before=\"" + this.spaceBefore + "\"");
            printWriter.print(" w:after=\"0\"");
            if (this.lineHeight != 0) {
                printWriter.print(" w:line=\"" + this.lineHeight + "\"");
                printWriter.print(" w:line-rule=\"at-least\"");
            }
            printWriter.print(" />");
        }
        if (this.startIndent != 0 || this.endIndent != 0 || this.firstLineIndent != 0) {
            printWriter.print("<w:ind");
            printWriter.print(" w:left=\"" + this.startIndent + "\"");
            printWriter.print(" w:right=\"" + this.endIndent + "\"");
            printWriter.print(" w:first-line=\"" + this.firstLineIndent + "\"");
            printWriter.print(" />");
        }
        if (this.alignment != ALIGNMENT_LEFT) {
            printWriter.print("<w:jc");
            printWriter.print(" w:val=\"" + this.alignment + "\"");
            printWriter.print(" />");
        }
        if (this.outlineLevel >= 1 && this.outlineLevel <= 9) {
            printWriter.print("<w:outlineLvl w:val=\"" + Integer.toString(this.outlineLevel - 1) + "\" />");
        }
        if (this.markProperties != null) {
            this.markProperties.print(printWriter);
        }
        printWriter.println("</w:pPr>");
    }

    private static int integer(Value value, int n) {
        if (value != null && value.type == 2) {
            return value.integer();
        }
        return n;
    }

    private static int length(Value value) {
        int n = 0;
        if (value.type == 4) {
            n = Wml.toTwips(value.length());
        }
        return n;
    }

    private static boolean keep(Value value) {
        boolean bl = false;
        switch (value.type) {
            case 1: {
                if (value.keyword() != 8) break;
                bl = true;
                break;
            }
            case 2: {
                if (value.integer() <= 0) break;
                bl = true;
            }
        }
        return bl;
    }

    public static class Tab {
        public static final String ALIGNMENT_LEFT = "left";
        public static final String ALIGNMENT_CENTER = "center";
        public static final String ALIGNMENT_RIGHT = "right";
        public static final String ALIGNMENT_DECIMAL = "decimal";
        public static final String ALIGNMENT_LIST = "list";
        public static final String LEADER_DOTS = "dot";
        public static final String LEADER_LINE = "underscore";
        public int position;
        public String alignment;
        public String leader;

        public Tab(int n) {
            this(n, "left");
        }

        public Tab(int n, String string) {
            this(n, string, null);
        }

        public Tab(int n, String string, String string2) {
            this.position = n;
            this.alignment = string;
            this.leader = string2;
        }

        public void print(PrintWriter printWriter) {
            printWriter.print("<w:tab");
            printWriter.print(" w:val=\"" + this.alignment + "\"");
            printWriter.print(" w:pos=\"" + this.position + "\"");
            if (this.leader != null) {
                printWriter.print(" w:leader=\"" + this.leader + "\"");
            }
            printWriter.print(" />");
        }
    }
}

